/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.common.util.Log;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.PlayerUtil;
import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.UsernameCache;

public class UserIdent {
    @Nonnull
    private static final String NONE_MARKER = "none";
    @Nullable
    private final UUID uuid;
    @Nonnull
    private final UUID uuid_offline;
    @Nonnull
    private final String playerName;
    @Nonnull
    public static final Nobody NOBODY = new Nobody();

    @Nonnull
    public String getPlayerName() {
        String lastKnownName;
        if (this.uuid != null && (lastKnownName = UsernameCache.getLastKnownUsername((UUID)this.uuid)) != null) {
            return lastKnownName;
        }
        return this.playerName;
    }

    @Nonnull
    public UUID getUUID() {
        return this.uuid != null ? this.uuid : this.uuid_offline;
    }

    @Nonnull
    public String getUUIDString() {
        return this.uuid != null ? this.uuid + "" : NONE_MARKER;
    }

    @Nonnull
    public GameProfile getAsGameProfile() {
        return new GameProfile(this.getUUID(), this.getPlayerName());
    }

    @Nonnull
    public static UserIdent create(@Nullable UUID uuid, @Nullable String playerName) {
        if (uuid != null) {
            String lastKnownName;
            if (NOBODY.equals(uuid)) {
                return NOBODY;
            }
            if (playerName != null && (lastKnownName = UsernameCache.getLastKnownUsername((UUID)uuid)) != null && !lastKnownName.equals(playerName)) {
                Log.warn("The user with the UUID " + uuid + " changed name from '" + playerName + "' to '" + lastKnownName + "'");
                return new UserIdent(uuid, lastKnownName);
            }
            return new UserIdent(uuid, playerName);
        }
        if (playerName != null) {
            return new UserIdent(null, playerName);
        }
        return NOBODY;
    }

    @Nonnull
    public static UserIdent create(@Nonnull String suuid, @Nullable String playerName) {
        if (NONE_MARKER.equals(suuid)) {
            return new UserIdent(null, playerName);
        }
        try {
            UUID uuid = UUID.fromString(suuid);
            if (NOBODY.equals(uuid)) {
                return NOBODY;
            }
            return UserIdent.create(uuid, playerName);
        }
        catch (IllegalArgumentException e) {
            return NOBODY;
        }
    }

    @Nonnull
    public static UserIdent create(@Nullable String legacyData) {
        UUID uuid = PlayerUtil.getPlayerUIDUnstable(legacyData);
        if (uuid != null) {
            return new UserIdent(uuid, legacyData);
        }
        if (legacyData != null) {
            return new UserIdent(null, legacyData);
        }
        return NOBODY;
    }

    @Nonnull
    public static UserIdent create(@Nullable GameProfile gameProfile) {
        if (gameProfile != null && (gameProfile.getId() != null || gameProfile.getName() != null)) {
            if (gameProfile.getId() != null && gameProfile.getName() != null && gameProfile.getId().equals(UserIdent.offlineUUID(gameProfile.getName()))) {
                return new UserIdent(null, gameProfile.getName());
            }
            return new UserIdent(gameProfile.getId(), gameProfile.getName());
        }
        return NOBODY;
    }

    @Nonnull
    private static UUID offlineUUID(@Nullable String playerName) {
        UUID result = UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes(Charsets.UTF_8));
        return result;
    }

    UserIdent(@Nullable UUID uuid, @Nullable String playerName) {
        this.uuid = uuid;
        this.uuid_offline = UserIdent.offlineUUID(playerName);
        this.playerName = playerName != null ? playerName : "[" + uuid + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.playerName.hashCode();
        UUID uuidNullChecked = this.uuid;
        result = 31 * result + (uuidNullChecked == null ? 0 : uuidNullChecked.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UserIdent) {
            return this.equals((UserIdent)obj);
        }
        if (obj instanceof GameProfile) {
            return this.equals((GameProfile)obj);
        }
        if (obj instanceof UUID) {
            return this.equals((UUID)obj);
        }
        return false;
    }

    public boolean equals(UserIdent other) {
        if (this.uuid != null && other.uuid != null) {
            return this.uuid.equals(other.uuid);
        }
        return this.uuid_offline.equals(other.uuid_offline);
    }

    public boolean equals(UUID other) {
        return other.equals(this.uuid) || other.equals(this.uuid_offline);
    }

    public boolean equals(GameProfile other) {
        UUID other_uuid = other.getId();
        if (this.uuid != null && other_uuid != null) {
            return this.uuid.equals(other_uuid);
        }
        UUID uuid_offline_other = UserIdent.offlineUUID(other.getName());
        return uuid_offline_other.equals(this.uuid) || this.uuid_offline.equals(uuid_offline_other);
    }

    public void saveToNbt(@Nonnull NBTTagCompound nbt, @Nonnull String prefix) {
        if (this.uuid != null) {
            nbt.func_74778_a(prefix + ".uuid", this.uuid.toString());
        }
        nbt.func_74778_a(prefix + ".login", this.playerName);
    }

    public static boolean existsInNbt(@Nonnull NBTTagCompound nbt, @Nonnull String prefix) {
        return nbt.func_74764_b(prefix + ".uuid") || nbt.func_74764_b(prefix + ".login");
    }

    @Nonnull
    public static UserIdent readfromNbt(@Nonnull NBTTagCompound nbt, @Nonnull String prefix) {
        String suuid = nbt.func_74779_i(prefix + ".uuid");
        String login = NullHelper.untrusted(nbt.func_74779_i(prefix + ".login"), "NBTTagCompound.getString()");
        if ("nobody".equals(suuid)) {
            return NOBODY;
        }
        try {
            UUID uuid = UUID.fromString(suuid);
            return UserIdent.create(uuid, login);
        }
        catch (IllegalArgumentException e) {
            if (login.isEmpty()) {
                return NOBODY;
            }
            return new UserIdent(null, login);
        }
    }

    public String toString() {
        return "User [uuid=" + (this.uuid != null ? this.uuid : "(unknown)") + ", name=" + this.playerName + "]";
    }

    private static class Nobody
    extends UserIdent {
        @Nonnull
        private static final String NOBODY_MARKER = "nobody";

        Nobody() {
            super(null, "[unknown player]");
        }

        @Override
        public boolean equals(UserIdent other) {
            return this == other;
        }

        @Override
        public void saveToNbt(@Nonnull NBTTagCompound nbt, @Nonnull String prefix) {
            nbt.func_74778_a(prefix + ".uuid", NOBODY_MARKER);
        }
    }
}

