/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityFarmer
extends TileEntityInventoryBase
implements IFarmer {
    private static final List<IFarmerBehavior> SORTED_FARMER_BEHAVIORS = new ArrayList<IFarmerBehavior>();
    public final CustomEnergyStorage storage = new CustomEnergyStorage(100000, 1000, 0);
    private int waitTime;
    private int checkX;
    private int checkY;
    private int lastEnergy;
    private static boolean sorted = false;

    public TileEntityFarmer() {
        super(12, "farmer");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("WaitTime", this.waitTime);
        }
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            compound.func_74768_a("CheckX", this.checkX);
            compound.func_74768_a("CheckY", this.checkY);
        }
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.waitTime = compound.func_74762_e("WaitTime");
        }
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            this.checkX = compound.func_74762_e("CheckX");
            this.checkY = compound.func_74762_e("CheckY");
        }
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && this.storage.getEnergyStored() > 0) {
                if (this.waitTime > 0) {
                    --this.waitTime;
                    if (this.waitTime <= 0) {
                        int radiusAroundCenter = 4;
                        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                        int meta = state.func_177230_c().func_176201_c(state);
                        BlockPos center = this.field_174879_c.func_177967_a(EnumFacing.func_176731_b((int)meta), radiusAroundCenter + 1);
                        BlockPos query = center.func_177982_a(this.checkX, 0, this.checkY);
                        this.checkBehaviors(query);
                        ++this.checkX;
                        if (this.checkX > radiusAroundCenter) {
                            this.checkX = -radiusAroundCenter;
                            ++this.checkY;
                            if (this.checkY > radiusAroundCenter) {
                                this.checkY = -radiusAroundCenter;
                            }
                        }
                    }
                } else {
                    this.waitTime = 5;
                }
            }
            if (this.lastEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    private static void sort() {
        SORTED_FARMER_BEHAVIORS.clear();
        SORTED_FARMER_BEHAVIORS.addAll(ActuallyAdditionsAPI.FARMER_BEHAVIORS);
        Collections.sort(SORTED_FARMER_BEHAVIORS, (b1, b2) -> b2.getPrioInt().compareTo(b1.getPrioInt()));
    }

    private void checkBehaviors(BlockPos query) {
        if (!sorted) {
            TileEntityFarmer.sort();
        }
        for (IFarmerBehavior behavior : SORTED_FARMER_BEHAVIORS) {
            FarmerResult harvestResult = behavior.tryHarvestPlant(this.field_145850_b, query, this);
            if (harvestResult == FarmerResult.STOP_PROCESSING) {
                return;
            }
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.inv.getStackInSlot(i);
                IBlockState state = this.field_145850_b.func_180495_p(query);
                if (!StackUtil.isValid(stack) || !state.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, query)) continue;
                FarmerResult plantResult = behavior.tryPlantSeed(stack, this.field_145850_b, query, this);
                if (plantResult == FarmerResult.SUCCESS) {
                    this.inv.getStackInSlot(i).func_190918_g(1);
                    return;
                }
                if (plantResult != FarmerResult.STOP_PROCESSING) continue;
                return;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot < 6;
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot >= 6;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }

    @Override
    public EnumFacing getOrientation() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return WorldUtil.getDirectionByPistonRotation(state);
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public int getX() {
        return this.field_174879_c.func_177958_n();
    }

    @Override
    public int getY() {
        return this.field_174879_c.func_177956_o();
    }

    @Override
    public int getZ() {
        return this.field_174879_c.func_177952_p();
    }

    @Override
    public World getWorldObject() {
        return this.field_145850_b;
    }

    @Override
    public void extractEnergy(int amount) {
        this.storage.extractEnergyInternal(amount, false);
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean canAddToSeeds(List<ItemStack> stacks) {
        return StackUtil.canAddAll(this.inv, stacks, 0, 6, false);
    }

    @Override
    public boolean canAddToOutput(List<ItemStack> stacks) {
        return StackUtil.canAddAll(this.inv, stacks, 6, 12, false);
    }

    @Override
    public void addToSeeds(List<ItemStack> stacks) {
        StackUtil.addAll(this.inv, stacks, 0, 6, false);
    }

    @Override
    public void addToOutput(List<ItemStack> stacks) {
        StackUtil.addAll(this.inv, stacks, 6, 12, false);
    }
}

