/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;
import team.chisel.Chisel;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.common.block.MessageAutochiselFX;
import team.chisel.common.block.MessageUpdateAutochiselSource;
import team.chisel.common.config.Configurations;
import team.chisel.common.util.SoundUtil;

@ParametersAreNonnullByDefault
public class TileAutoChisel
extends TileEntity
implements ITickable,
IWorldNameable {
    private static final int INPUT_COUNT = 12;
    private static final int OUTPUT_COUNT = 12;
    private static final int MAX_PROGRESS = 1024;
    private static final int BASE_PROGRESS = 16;
    private static final int SPEEDUP_PROGRESS = 64;
    private static final int POWER_PER_TICK = 20;
    private final ItemStackHandler otherInv = new DirtyingStackHandler(2){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return stack;
            }
            if (slot == 0 && stack.func_77973_b() instanceof IChiselItem) {
                return super.insertItem(slot, stack, simulate);
            }
            if (slot == 1 && CarvingUtils.getChiselRegistry().getVariation(stack) != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private final ItemStackHandler inputInv = new DirtyingStackHandler(12){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!stack.func_190926_b() && CarvingUtils.getChiselRegistry().getVariation(stack) != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private final ItemStackHandler outputInv = new DirtyingStackHandler(12);
    private final EnergyStorageMutable energyStorage = new EnergyStorageMutable(10000, 40, 20);
    private int sourceSlot = -1;
    private int prevSource = -1;
    private int progress = 0;
    @Nullable
    private String customName;
    @Nullable
    private ItemStack source;

    public IItemHandler getOtherInv() {
        return this.otherInv;
    }

    public ItemStack getChisel() {
        return this.getOtherInv().getStackInSlot(0);
    }

    public ItemStack getTarget() {
        return this.getOtherInv().getStackInSlot(1);
    }

    public IItemHandler getInputInv() {
        return this.inputInv;
    }

    public IItemHandler getOutputInv() {
        return this.outputInv;
    }

    public int getMaxProgress() {
        return 1024;
    }

    public float getSpeedFactor() {
        return Configurations.autoChiselPowered ? (float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored() : 1.0f;
    }

    public int getPowerProgressPerTick() {
        int maxPerTick = Configurations.autoChiselNeedsPower ? 80 : 64;
        return (int)Math.ceil(this.getSpeedFactor() * (float)maxPerTick);
    }

    public int getUsagePerTick() {
        return (int)Math.ceil(this.getSpeedFactor() * 20.0f);
    }

    public void setEnergy(int energy) {
        this.energyStorage.setEnergyStored(energy);
    }

    protected boolean canOutput(ItemStack stack) {
        ItemStack res = stack;
        for (int i = 0; i < this.getOutputInv().getSlots(); ++i) {
            res = this.getOutputInv().insertItem(i, res, true);
            if (!res.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    protected void setSourceSlot(int slot) {
        this.sourceSlot = slot;
    }

    protected void updateClientSlot() {
        if (this.sourceSlot != this.prevSource) {
            Chisel.network.sendToDimension((IMessage)new MessageUpdateAutochiselSource(this.func_174877_v(), this.sourceSlot < 0 ? ItemStack.field_190927_a : this.inputInv.getStackInSlot(this.sourceSlot)), this.func_145831_w().field_73011_w.getDimension());
        }
        this.prevSource = this.sourceSlot;
    }

    protected void mergeOutput(ItemStack stack) {
        for (int i = 0; stack != null && i < this.getOutputInv().getSlots(); ++i) {
            stack = this.getOutputInv().insertItem(i, stack, false);
        }
    }

    public void func_73660_a() {
        ICarvingGroup g;
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.energyStorage.getEnergyStored() == 0 && Configurations.autoChiselNeedsPower) {
            return;
        }
        ItemStack target = this.getTarget();
        ItemStack chisel = this.getChisel();
        ItemStack source = this.sourceSlot < 0 ? ItemStack.field_190927_a : this.getInputInv().getStackInSlot(this.sourceSlot);
        chisel = chisel.func_190926_b() ? ItemStack.field_190927_a : chisel.func_77946_l();
        ICarvingVariation v = target.func_190926_b() || chisel.func_190926_b() ? null : CarvingUtils.getChiselRegistry().getVariation(target);
        ICarvingGroup iCarvingGroup = g = target.func_190926_b() || chisel.func_190926_b() ? null : CarvingUtils.getChiselRegistry().getGroup(target);
        if (chisel.func_190926_b() || v == null) {
            this.setSourceSlot(-1);
            this.progress = 0;
            this.updateClientSlot();
            return;
        }
        if (!source.func_190926_b() && CarvingUtils.getChiselRegistry().getGroup(source) != g) {
            source = ItemStack.field_190927_a;
        }
        IChiselItem chiselitem = (IChiselItem)chisel.func_77973_b();
        if (this.sourceSlot < 0 && this.func_145831_w().func_82737_E() % 20L == 0L || this.sourceSlot >= 0) {
            if (source.func_190926_b()) {
                this.setSourceSlot(-1);
            }
            ItemStack res = v.getStack();
            if (!source.func_190926_b()) {
                res.func_190920_e(source.func_190916_E());
            }
            if (source.func_190926_b() || this.canOutput(res)) {
                for (int i = 0; this.sourceSlot < 0 && i < this.getInputInv().getSlots(); ++i) {
                    ItemStack stack = this.getInputInv().getStackInSlot(i);
                    if (stack.func_190926_b() || g != CarvingUtils.getChiselRegistry().getGroup(stack)) continue;
                    res.func_190920_e(stack.func_190916_E());
                    if (!this.canOutput(res) || !chiselitem.canChisel(this.func_145831_w(), (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.func_145831_w())), chisel, v)) continue;
                    this.setSourceSlot(i);
                    source = res.func_77946_l();
                }
            } else {
                this.setSourceSlot(-1);
            }
        }
        if (this.sourceSlot >= 0) {
            source = this.getInputInv().getStackInSlot(this.sourceSlot);
            Validate.notNull((Object)source);
            ICarvingVariation sourceVar = CarvingUtils.getChiselRegistry().getVariation(source);
            if (sourceVar != v) {
                if (this.progress < 1024) {
                    if (!Configurations.autoChiselNeedsPower) {
                        this.progress = Math.min(1024, this.progress + 16);
                    }
                    int toUse = Math.min(1024 - this.progress, this.getPowerProgressPerTick());
                    int powerToUse = this.getUsagePerTick();
                    if (toUse > 0 && powerToUse > 0) {
                        if (Configurations.autoChiselPowered) {
                            int used = this.energyStorage.extractEnergy(powerToUse, false);
                            this.progress = (int)((float)this.progress + (float)toUse * ((float)used / (float)powerToUse));
                        } else {
                            this.progress += toUse;
                        }
                    }
                } else {
                    ItemStack res = v.getStack();
                    source = source.func_77946_l();
                    chisel = chisel.func_77946_l();
                    FakePlayer player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.func_145831_w()));
                    player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)chisel);
                    res = chiselitem.craftItem(chisel, source, res, (EntityPlayer)player);
                    player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
                    chiselitem.onChisel(this.func_145831_w(), (EntityPlayer)player, chisel, v);
                    this.inputInv.setStackInSlot(this.sourceSlot, source);
                    Chisel.network.sendToDimension((IMessage)new MessageAutochiselFX(this.func_174877_v(), chisel, sourceVar.getBlockState()), this.func_145831_w().field_73011_w.getDimension());
                    this.otherInv.setStackInSlot(0, chisel);
                    this.mergeOutput(res);
                    this.setSourceSlot((this.sourceSlot + 1) % this.getInputInv().getSlots());
                    this.progress = 0;
                }
            } else {
                this.inputInv.setStackInSlot(this.sourceSlot, ItemStack.field_190927_a);
                this.mergeOutput(source);
            }
        } else {
            this.progress = 0;
        }
        this.updateClientSlot();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || Configurations.autoChiselPowered && capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new ItemView(facing));
        }
        if (Configurations.autoChiselPowered && capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new EnergyView());
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound ret = super.func_189517_E_();
        if (this.func_145818_k_()) {
            ret.func_74778_a("customName", this.func_70005_c_());
        }
        return ret;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        if (tag.func_74764_b("customName")) {
            this.customName = tag.func_74779_i("customName");
        }
        super.handleUpdateTag(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("other", (NBTBase)this.otherInv.serializeNBT());
        compound.func_74782_a("input", (NBTBase)this.inputInv.serializeNBT());
        compound.func_74782_a("output", (NBTBase)this.outputInv.serializeNBT());
        compound.func_74768_a("energy", this.energyStorage.getEnergyStored());
        compound.func_74768_a("progress", this.getProgress());
        compound.func_74768_a("source", this.sourceSlot);
        if (this.func_145818_k_()) {
            compound.func_74778_a("customName", this.func_70005_c_());
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.otherInv.deserializeNBT(compound.func_74775_l("other"));
        this.inputInv.deserializeNBT(compound.func_74775_l("input"));
        this.outputInv.deserializeNBT(compound.func_74775_l("output"));
        this.energyStorage.setEnergyStored(compound.func_74762_e("energy"));
        this.progress = compound.func_74762_e("progress");
        this.sourceSlot = compound.func_74762_e("source");
        if (compound.func_74764_b("customName")) {
            this.customName = compound.func_74779_i("customName");
        }
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public String func_70005_c_() {
        String name = this.customName;
        if (name == null) {
            name = "container.autochisel.title";
        }
        return name;
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public void spawnCompletionFX(EntityPlayer player, ItemStack chisel, IBlockState source) {
        SoundUtil.playSound(player, this.func_174877_v(), SoundUtil.getSound(player, chisel, source));
        if (chisel.func_190926_b()) {
            this.func_145831_w().func_184133_a(player, this.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.8f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
        }
        int i = 3;
        float mid = (float)i / 2.0f;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double vx = (double)(mid - (float)j) * 0.05;
                    double vz = (double)(mid - (float)l) * 0.05;
                    ((ParticleDigging)Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.625, (double)this.field_174879_c.func_177952_p() + 0.5, vx, 0.0, vz, new int[]{Block.func_149682_b((Block)source.func_177230_c())})).func_174846_a(this.field_174879_c).func_187117_a(Minecraft.func_71410_x().func_175602_ab().func_184389_a(source).func_177554_e());
                }
            }
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setCustomName(@Nullable String customName) {
        this.customName = customName;
    }

    public void setSource(@Nullable ItemStack source) {
        this.source = source;
    }

    @Nullable
    public ItemStack getSource() {
        return this.source;
    }

    private class EnergyView
    extends EnergyStorageMutable {
        public EnergyView() {
            super(TileAutoChisel.this.energyStorage.getMaxEnergyStored(), 40, 0);
            this.setEnergyStored(TileAutoChisel.this.energyStorage.getEnergyStored());
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return TileAutoChisel.this.energyStorage.receiveEnergy(maxReceive, simulate);
        }
    }

    private static class EnergyStorageMutable
    extends EnergyStorage {
        public EnergyStorageMutable(int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
        }

        public void setEnergyStored(int energy) {
            this.energy = MathHelper.func_76125_a((int)energy, (int)0, (int)this.getMaxEnergyStored());
        }
    }

    private class ItemView
    implements IItemHandlerModifiable {
        private final IItemHandlerModifiable input;
        private final IItemHandlerModifiable output;

        ItemView(EnumFacing side) {
            if (side == null || side.func_176740_k().func_176720_b()) {
                this.input = TileAutoChisel.this.inputInv;
                this.output = TileAutoChisel.this.outputInv;
            } else {
                this.input = this.output = TileAutoChisel.this.otherInv;
            }
        }

        public int getSlots() {
            return this.input == this.output ? this.input.getSlots() : this.input.getSlots() + this.output.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                if (slot < this.input.getSlots()) {
                    return this.input.getStackInSlot(slot);
                }
                return this.output.getStackInSlot(slot - this.input.getSlots());
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot >= 0 && slot < this.input.getSlots()) {
                return this.input.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= this.input.getSlots() && slot < this.getSlots()) {
                return this.output.extractItem(slot -= this.input.getSlots(), amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (slot >= 0 && slot < this.getSlots()) {
                if (slot < this.input.getSlots()) {
                    this.input.setStackInSlot(slot, stack);
                } else {
                    this.output.setStackInSlot(slot - this.input.getSlots(), stack);
                }
            }
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }

    private class DirtyingStackHandler
    extends ItemStackHandler {
        DirtyingStackHandler() {
        }

        DirtyingStackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileAutoChisel.this.func_70296_d();
        }
    }
}

