/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen;

import appeng.api.AEApi;
import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.features.IWorldGen;
import appeng.core.AEConfig;
import appeng.core.features.registries.WorldGenRegistry;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public final class QuartzWorldGen
implements IWorldGenerator {
    private final WorldGenMinable oreNormal;
    private final WorldGenMinable oreCharged;

    public QuartzWorldGen() {
        IBlocks blocks = AEApi.instance().definitions().blocks();
        IBlockDefinition oreDefinition = blocks.quartzOre();
        IBlockDefinition chargedDefinition = blocks.quartzOreCharged();
        this.oreNormal = oreDefinition.maybeBlock().map(b -> new WorldGenMinable(b.func_176223_P(), AEConfig.instance().getQuartzOresPerCluster())).orElse(null);
        this.oreCharged = chargedDefinition.maybeBlock().map(b -> new WorldGenMinable(b.func_176223_P(), AEConfig.instance().getQuartzOresPerCluster())).orElse(null);
    }

    public void generate(Random r, int chunkX, int chunkZ, World w, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (this.oreNormal == null && this.oreCharged == null) {
            return;
        }
        int seaLevel = w.field_73011_w.func_76557_i() + 1;
        if (seaLevel < 20) {
            int x = (chunkX << 4) + 8;
            int z = (chunkZ << 4) + 8;
            seaLevel = w.func_189649_b(x, z);
        }
        double oreDepthMultiplier = AEConfig.instance().getQuartzOresClusterAmount() * seaLevel / 64;
        int scale = (int)Math.round(r.nextGaussian() * Math.sqrt(oreDepthMultiplier) + oreDepthMultiplier);
        for (int cnt = 0; cnt < (r.nextBoolean() ? scale * 2 : scale) / 2; ++cnt) {
            WorldGenMinable whichOre;
            boolean isCharged = false;
            if (this.oreCharged != null) {
                isCharged = r.nextFloat() > AEConfig.instance().getSpawnChargedChance();
            }
            WorldGenMinable worldGenMinable = whichOre = isCharged ? this.oreCharged : this.oreNormal;
            if (whichOre == null || !QuartzWorldGen.shouldGenerate(isCharged, w)) continue;
            int cx = chunkX * 16 + r.nextInt(16);
            int cy = r.nextInt(40 * seaLevel / 64) + r.nextInt(22 * seaLevel / 64) + 12 * seaLevel / 64;
            int cz = chunkZ * 16 + r.nextInt(16);
            whichOre.func_180709_b(w, r, new BlockPos(cx, cy, cz));
        }
    }

    private static boolean shouldGenerate(boolean isCharged, World w) {
        return WorldGenRegistry.INSTANCE.isWorldGenEnabled(isCharged ? IWorldGen.WorldGenType.CHARGED_CERTUS_QUARTZ : IWorldGen.WorldGenType.CERTUS_QUARTZ, w);
    }
}

