/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import net.malisis.core.MalisisCore;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.SubtypeComponent;
import net.malisis.core.item.MalisisItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ColorComponent
extends SubtypeComponent<EnumDyeColor>
implements IRegisterComponent {
    private boolean useColorMultiplier = true;

    public ColorComponent(boolean useColorMultiplier) {
        super(EnumDyeColor.class, BlockColored.field_176581_a);
        this.useColorMultiplier = useColorMultiplier;
    }

    public boolean useColorMultiplier() {
        return this.useColorMultiplier;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a(this.getProperty(), (Comparable)EnumDyeColor.WHITE);
    }

    @Override
    public void register(IComponentProvider block) {
        if (MalisisCore.isClient() && block instanceof Block) {
            this.registerColorHandler((Block)block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerColorHandler(Block block) {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(this::getRenderColor, new Block[]{block});
    }

    @Override
    public String getUnlocalizedName(Block block, IBlockState state) {
        return block.func_149739_a() + "." + ColorComponent.getColor(state).func_176762_d();
    }

    @Override
    public Item getItem(Block block) {
        if (block instanceof MalisisBlock) {
            return new MalisisItemBlock((MalisisBlock)block);
        }
        return new ItemBlock(block);
    }

    @Override
    public int damageDropped(Block block, IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(this.getProperty())).func_176765_a();
    }

    @Override
    public boolean getHasSubtypes(Block block, Item item) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Block block, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            list.add((Object)new ItemStack(block, 1, color.func_176765_a()));
        }
    }

    public int getRenderColor(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
        if (!this.useColorMultiplier()) {
            return 0xFFFFFF;
        }
        return ItemDye.field_150922_c[ColorComponent.getColor(state).func_176767_b()];
    }

    @Override
    public MapColor getMapColor(Block block, IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.func_193558_a((EnumDyeColor)((EnumDyeColor)state.func_177229_b(this.getProperty())));
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a(this.getProperty(), (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(this.getProperty())).func_176765_a();
    }

    public static EnumDyeColor getColor(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? ColorComponent.getColor(world.func_180495_p(pos)) : EnumDyeColor.WHITE;
    }

    public static EnumDyeColor getColor(IBlockState state) {
        ColorComponent cc = IComponent.getComponent(ColorComponent.class, state.func_177230_c());
        if (cc == null) {
            return EnumDyeColor.WHITE;
        }
        PropertyEnum property = cc.getProperty();
        if (property == null || !state.func_177228_b().containsKey(property)) {
            return EnumDyeColor.WHITE;
        }
        return (EnumDyeColor)state.func_177229_b(property);
    }
}

