/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.renderers;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import sonar.core.client.renderers.ISonarCustomRenderer;

public abstract class SonarRendererBase
implements ISonarCustomRenderer {
    public final Block block;
    public final ModelResourceLocation location;
    public TextureAtlasSprite icon;
    public ArrayList<ResourceLocation> textures = new ArrayList();

    public SonarRendererBase(Block block, ModelResourceLocation location) {
        this.block = block;
        this.location = location;
    }

    public SonarRendererBase setBreakTexture(ResourceLocation location) {
        this.icon = this.getIcon(location);
        return this;
    }

    public SonarRendererBase addTexture(ResourceLocation location) {
        this.textures.add(location);
        return this;
    }

    @Nonnull
    public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
        return this.getBlockModelResourceLocation();
    }

    @Override
    public ModelResourceLocation getBlockModelResourceLocation() {
        return this.location;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public boolean hasStaticRendering() {
        return false;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    @Override
    public boolean doInventoryRendering() {
        return true;
    }

    @Override
    public ArrayList<ResourceLocation> getAllTextures() {
        return this.textures;
    }

    public final TextureAtlasSprite getIcon(ResourceLocation loc) {
        if (loc == null) {
            return (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(loc);
        }
        return null;
    }
}

