/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories.handling.filters;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import sonar.core.handlers.inventories.handling.filters.IExtractFilter;
import sonar.core.handlers.inventories.handling.filters.IInsertFilter;
import sonar.core.helpers.SonarHelper;

public class SlotFilter
implements IInsertFilter,
IExtractFilter {
    public int[] filtered;
    @Nullable
    public Boolean defaultReturn;
    public EnumFacing[] faces;

    public SlotFilter(Boolean defaultReturn, int[] filtered) {
        this.defaultReturn = defaultReturn;
        this.filtered = filtered;
        this.faces = null;
    }

    public SlotFilter(Boolean defaultReturn, int[] filtered, int[] faces) {
        this.defaultReturn = defaultReturn;
        this.filtered = filtered;
        EnumFacing[] newFaces = new EnumFacing[faces.length];
        for (int i = 0; i < faces.length; ++i) {
            newFaces[i] = EnumFacing.values()[faces[i]];
        }
        this.faces = newFaces;
    }

    public SlotFilter(Boolean defaultReturn, int[] filtered, EnumFacing ... faces) {
        this.defaultReturn = defaultReturn;
        this.filtered = filtered;
        this.faces = faces;
    }

    public boolean checkSlot(int slot) {
        return SonarHelper.intContains(this.filtered, slot);
    }

    public boolean checkFace(EnumFacing face) {
        return this.faces == null || face == null || SonarHelper.arrayContains(this.faces, face);
    }

    public boolean checkFilter(int slot, EnumFacing face) {
        return (this.faces == null || face == null || SonarHelper.arrayContains(this.faces, face)) && SonarHelper.intContains(this.filtered, slot);
    }

    public boolean checkFilterSafe(int slot, EnumFacing face) {
        if (this.checkFace(face)) {
            return this.checkSlot(slot);
        }
        return true;
    }

    @Override
    public Boolean canExtract(int slot, int amount, EnumFacing face) {
        if (this.checkFace(face)) {
            return this.checkSlot(slot);
        }
        return this.defaultReturn;
    }

    @Override
    public Boolean canInsert(int slot, @Nonnull ItemStack stack, EnumFacing face) {
        if (this.checkFace(face)) {
            return this.checkSlot(slot);
        }
        return this.defaultReturn;
    }
}

