/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.annotation;

import codechicken.lib.annotation.FunctionProxy;
import codechicken.lib.reflect.ReflectionManager;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxyInjector {
    private static Logger logger = LogManager.getLogger((String)"CodeChickenLib Proxy Injection");

    public static void runInjector(ASMDataTable table) {
        Side loadSide = FMLLaunchHandler.side();
        Set targets = table.getAll(FunctionProxy.class.getName());
        Set sidedClasses = table.getAll(SideOnly.class.getName());
        Set filteredTargets = Sets.filter((Set)targets, input -> {
            for (ASMDataTable.ASMData data : sidedClasses) {
                if (!data.getClassName().equals(input.getClassName()) || !data.getObjectName().equalsIgnoreCase(input.getClassName()) && !data.getObjectName().equalsIgnoreCase(input.getObjectName())) continue;
                for (Map.Entry entry : data.getAnnotationInfo().entrySet()) {
                    if (!((String)entry.getKey()).equals("value") || !(entry.getValue() instanceof ModAnnotation.EnumHolder)) continue;
                    ModAnnotation.EnumHolder holder = (ModAnnotation.EnumHolder)entry.getValue();
                    if (loadSide.toString().equalsIgnoreCase(holder.getValue())) continue;
                    return false;
                }
            }
            return true;
        });
        ModClassLoader classLoader = Loader.instance().getModClassLoader();
        for (ASMDataTable.ASMData data : filteredTargets) {
            try {
                Class<?> proxyTarget = Class.forName(data.getClassName(), true, (ClassLoader)classLoader);
                Field target = proxyTarget.getDeclaredField(data.getObjectName());
                if (target == null) {
                    throw new RuntimeException(String.format("Attempted to load proxy into field %s.%s but field does not exist..", data.getClassName(), data.getObjectName()));
                }
                target.setAccessible(true);
                FunctionProxy annotation = target.getAnnotation(FunctionProxy.class);
                String targetClass = ProxyInjector.getInjectClass(annotation.injectClassCallback(), data, (ClassLoader)classLoader);
                Object proxyInstance = Class.forName(targetClass, true, (ClassLoader)classLoader).newInstance();
                if (!target.getType().isAssignableFrom(proxyInstance.getClass())) {
                    throw new RuntimeException(String.format("Attempted to load incompatible class type to proxy field!, Field Type: %s, Inject Type %s, Field %s.%s", target.getType().getName(), targetClass, data.getClassName(), data.getObjectName()));
                }
                target.set(null, proxyInstance);
                logger.debug("Successfully injected proxy to field %s.%s", (Object)data.getClassName(), (Object)data.getObjectName());
            }
            catch (Exception e) {
                logger.fatal("Fatal Exception thrown whilst loading proxy for class %s.%s", (Object)e, (Object)data.getClassName(), (Object)data.getObjectName());
                Throwables.propagate((Throwable)e);
            }
        }
    }

    private static String getInjectClass(String test, ASMDataTable.ASMData data, ClassLoader classLoader) throws Exception {
        String methodName;
        String className;
        if (!test.equals("")) {
            int index = test.lastIndexOf(46);
            className = test.substring(0, index);
            methodName = test.substring(index + 1);
        } else {
            className = data.getClassName();
            methodName = "proxyCallback";
        }
        Class<?> clazz = Class.forName(className, true, classLoader);
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !method.getReturnType().equals(String.class) || !ReflectionManager.isStatic(method)) continue;
            method.setAccessible(true);
            return (String)method.invoke(null, new Object[0]);
        }
        throw new RuntimeException(String.format("Unable to find static method with string return type! Method: %s.%s", className, methodName));
    }
}

