/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.render;

import net.machinemuse.numina.client.render.MuseIconUtils;
import net.machinemuse.numina.client.render.MuseTextureUtils;
import net.machinemuse.numina.client.render.RenderState;
import net.machinemuse.numina.item.IModeChangingItem;
import net.machinemuse.numina.utils.math.Colour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderGameOverlayEventHandler {
    @SubscribeEvent
    public void onPreRenderGameOverlayEvent(RenderGameOverlayEvent.Pre e) {
    }

    @SubscribeEvent
    public void onPostRenderGameOverlayEvent(RenderGameOverlayEvent.Post e) {
        switch (e.getType()) {
            case HOTBAR: {
                this.drawModeChangeIcons();
                break;
            }
        }
    }

    public void drawModeChangeIcons() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        int i = player.field_71071_by.field_70461_c;
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IModeChangingItem) {
            IModeChangingItem item = (IModeChangingItem)stack.func_77973_b();
            ScaledResolution screen = new ScaledResolution(mc);
            MuseTextureUtils.pushTexture("textures/atlas/blocks.png");
            RenderState.blendingOn();
            TextureAtlasSprite currentMode = item.getModeIcon(item.getActiveMode(stack), stack, (EntityPlayer)player);
            int sw = screen.func_78326_a();
            int sh = screen.func_78328_b();
            int baroffset = 22;
            if (!player.field_71075_bZ.field_75098_d) {
                baroffset += 16;
                if (ForgeHooks.getTotalArmorValue((EntityPlayer)player) > 0) {
                    baroffset += 8;
                }
            }
            RenderState.scissorsOn(0.0, 0.0, sw, sh - baroffset);
            baroffset = screen.func_78328_b() - baroffset;
            double currX = (double)sw / 2.0 - 89.0 + 20.0 * (double)i;
            double currY = baroffset - 18;
            this.drawIcon(currX, currY, currentMode, 0.8);
            RenderState.scissorsOff();
            RenderState.blendingOff();
            MuseTextureUtils.popTexture();
            Colour.WHITE.doGL();
        }
    }

    public void drawIcon(double x, double y, TextureAtlasSprite icon, double alpha) {
        if (icon != null) {
            MuseIconUtils.drawIconAt(x, y, icon, Colour.WHITE.withAlpha(alpha));
        }
    }

    static {
        new RenderGameOverlayEventHandler();
    }
}

