/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.helpers;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.powersuits.api.constants.MPSResourceConstants;
import net.machinemuse.powersuits.client.event.ModelBakeEventHandler;
import net.machinemuse.powersuits.client.helper.ModelHelper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum ModelPowerFistHelper {
    INSTANCE;

    public static final ResourceLocation powerFistLocation;
    public static final ResourceLocation powerFistFingersNormalLocation;
    public static final ResourceLocation powerFistFingersFiringLocation;
    public static final ResourceLocation powerFistLeftLocation;
    public static final ResourceLocation powerFistFingersLeftNormalLocation;
    public static final ResourceLocation powerFistFingersLeftFiringLocation;
    public static final IModelState powerfistState;
    public static IBakedModel powerFist;
    public static IBakedModel powerFistFingers;
    public static IBakedModel powerFistFingersFiring;
    public static IBakedModel powerFistLeft;
    public static IBakedModel powerFistFingersLeft;
    public static IBakedModel powerFistFingersLeftFiring;
    public static LoadingCache<PowerFistQuadMapKey, List<BakedQuad>> colouredPowerFistQuadMap;

    public static void loadPowerFistModels(TextureStitchEvent event) {
        if (event == null) {
            powerFist = ModelHelper.loadBakedModel(powerFistLocation);
            powerFistFingers = ModelHelper.loadBakedModel(powerFistFingersNormalLocation);
            powerFistFingersFiring = ModelHelper.loadBakedModel(powerFistFingersFiringLocation);
            powerFistLeft = ModelHelper.loadBakedModel(powerFistLeftLocation);
            powerFistFingersLeft = ModelHelper.loadBakedModel(powerFistFingersLeftNormalLocation);
            powerFistFingersLeftFiring = ModelHelper.loadBakedModel(powerFistFingersLeftFiringLocation);
        }
    }

    static IModelState getPowerfistState() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ModelHelper.get(8.0f, 8.01f, 9.0f, -15.0f, 180.0f, 0.0f, 0.63f, 0.63f, 0.63f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ModelHelper.get(13.2f, 8.01f, 9.0f, -15.0f, 180.0f, 0.0f, 0.63f, 0.63f, 0.63f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ModelHelper.get(11.8f, 8.0f, 7.0f, -16.0f, -162.0f, 0.0f, 0.5f, 0.5f, 0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ModelHelper.get(14.8f, 8.0f, 7.0f, 344.0f, 198.0f, 0.0f, 0.5f, 0.5f, 0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ModelHelper.get(0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.63f));
        return new SimpleModelState(builder.build());
    }

    static {
        powerFistLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerfist/powerfist.obj");
        powerFistFingersNormalLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerfist/powerfist_fingers_normal.obj");
        powerFistFingersFiringLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerfist/powerfist_fingers_firing.obj");
        powerFistLeftLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerFist/powerfist_left.obj");
        powerFistFingersLeftNormalLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerfist/powerfist_fingers_normal_left.obj");
        powerFistFingersLeftFiringLocation = new ResourceLocation(MPSResourceConstants.RESOURCE_DOMAIN, "models/item/powerfist/powerfist_fingers_firing_left.obj");
        powerfistState = ModelPowerFistHelper.getPowerfistState();
        colouredPowerFistQuadMap = CacheBuilder.newBuilder().maximumSize(40L).build((CacheLoader)new CacheLoader<PowerFistQuadMapKey, List<BakedQuad>>(){

            public List<BakedQuad> load(PowerFistQuadMapKey key) throws Exception {
                ImmutableList.Builder builder = ImmutableList.builder();
                switch (key.transformType) {
                    case THIRD_PERSON_LEFT_HAND: 
                    case FIRST_PERSON_LEFT_HAND: {
                        powerFistLeft.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)ModelHelper.colorQuad(key.getColour(), quad, quad.shouldApplyDiffuseLighting())));
                        if (key.isFiring()) {
                            powerFistFingersLeftFiring.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)ModelHelper.colorQuad(key.getColour(), quad, quad.shouldApplyDiffuseLighting())));
                        } else {
                            powerFistFingersLeft.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)ModelHelper.colorQuad(key.getColour(), quad, quad.shouldApplyDiffuseLighting())));
                        }
                        return builder.build();
                    }
                    case THIRD_PERSON_RIGHT_HAND: 
                    case FIRST_PERSON_RIGHT_HAND: 
                    case GROUND: {
                        powerFist.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)ModelHelper.colorQuad(key.getColour(), quad, quad.shouldApplyDiffuseLighting())));
                        if (key.isFiring()) {
                            powerFistFingersFiring.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)ModelHelper.colorQuad(key.getColour(), quad, quad.shouldApplyDiffuseLighting())));
                        } else {
                            powerFistFingers.func_188616_a(null, null, 0L).forEach(quad -> builder.add((Object)ModelHelper.colorQuad(key.getColour(), quad, quad.shouldApplyDiffuseLighting())));
                        }
                        return builder.build();
                    }
                }
                return ModelHelper.getColoredQuads(ModelBakeEventHandler.powerFistIconModel.func_188616_a(null, null, 0L), key.getColour());
            }
        });
    }

    public static class PowerFistQuadMapKey {
        private final Colour colour;
        private final ItemCameraTransforms.TransformType transformType;
        private final boolean firing;

        public PowerFistQuadMapKey(Colour colour, ItemCameraTransforms.TransformType transformType, boolean firing) {
            this.colour = colour;
            this.transformType = transformType;
            this.firing = firing;
        }

        public Colour getColour() {
            return this.colour;
        }

        public ItemCameraTransforms.TransformType getTransformType() {
            return this.transformType;
        }

        public boolean isFiring() {
            return this.firing;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PowerFistQuadMapKey that = (PowerFistQuadMapKey)o;
            return this.firing == that.firing && Objects.equal((Object)this.getColour(), (Object)that.getColour()) && this.getTransformType() == that.getTransformType();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getColour(), this.getTransformType(), this.firing});
        }
    }
}

