/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import java.util.Arrays;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.inventory.EntityEquipmentSlot;

public enum MorphTarget {
    Head("HEAD", EntityEquipmentSlot.HEAD),
    Body("BODY", EntityEquipmentSlot.CHEST),
    RightArm("RIGHTARM", EntityEquipmentSlot.CHEST),
    LeftArm("LEFTARM", EntityEquipmentSlot.CHEST),
    RightLeg("RIGHTLEG", EntityEquipmentSlot.LEGS),
    LeftLeg("LEFTLEG", EntityEquipmentSlot.LEGS),
    RightFoot("RIGHTFOOT", EntityEquipmentSlot.FEET),
    LeftFoot("LEFTFOOT", EntityEquipmentSlot.FEET),
    RightHand("RIGHTHAND", EntityEquipmentSlot.MAINHAND),
    Lefthand("LEFTHAND", EntityEquipmentSlot.OFFHAND);

    String name;
    EntityEquipmentSlot slot;

    private MorphTarget(String name, EntityEquipmentSlot slot) {
        this.name = name;
        this.slot = slot;
    }

    public static MorphTarget getMorph(String name) {
        return Arrays.stream(MorphTarget.values()).filter(morph -> name.toUpperCase().equals(morph.name)).findAny().orElseGet(null);
    }

    public ModelRenderer apply(ModelBiped m) {
        switch (this) {
            case Head: {
                return m.field_78116_c;
            }
            case Body: {
                return m.field_78115_e;
            }
            case RightHand: 
            case RightArm: {
                return m.field_178723_h;
            }
            case Lefthand: 
            case LeftArm: {
                return m.field_178724_i;
            }
            case RightFoot: 
            case RightLeg: {
                return m.field_178721_j;
            }
            case LeftFoot: 
            case LeftLeg: {
                return m.field_178722_k;
            }
        }
        return null;
    }
}

