/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.machinemuse.numina.gui.frame.IGuiFrame;
import net.machinemuse.numina.item.IModeChangingItem;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.numina.network.packets.MusePacketModeChangeRequest;
import net.machinemuse.numina.utils.math.geometry.MusePoint2D;
import net.machinemuse.numina.utils.math.geometry.SpiralPointToPoint2D;
import net.machinemuse.numina.utils.render.MuseRenderer;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableModule;
import net.machinemuse.powersuits.network.MPSPackets;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class RadialModeSelectionFrame
implements IGuiFrame {
    protected final long spawnTime;
    protected List<ClickableModule> modeButtons = new ArrayList<ClickableModule>();
    protected int selectedModuleOriginal = -1;
    protected int selectedModuleNew = -1;
    protected EntityPlayer player;
    protected MusePoint2D center;
    protected double radius;
    protected ItemStack stack;

    public RadialModeSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, EntityPlayer player) {
        this.spawnTime = System.currentTimeMillis();
        this.player = player;
        this.center = bottomright.plus(topleft).times(0.5);
        this.radius = Math.min(this.center.minus(topleft).getX(), this.center.minus(topleft).getY());
        this.stack = player.field_71071_by.func_70448_g();
        this.loadItems();
        if (!this.stack.func_190926_b() && this.stack.func_77973_b() instanceof IModeChangingItem && this.modeButtons != null) {
            int i = 0;
            for (ClickableModule mode : this.modeButtons) {
                if (mode.getModule().getDataName().equals(((IModeChangingItem)this.stack.func_77973_b()).getActiveMode(this.stack))) {
                    this.selectedModuleOriginal = i;
                    break;
                }
                ++i;
            }
        }
    }

    public RadialModeSelectionFrame() {
        this.spawnTime = System.currentTimeMillis();
    }

    private boolean alreadyAdded(IRightClickModule module) {
        for (ClickableModule clickie : this.modeButtons) {
            if (!clickie.getModule().getDataName().equals(module.getDataName())) continue;
            return true;
        }
        return false;
    }

    private void loadItems() {
        if (this.player != null) {
            ArrayList<IRightClickModule> modes = new ArrayList<IRightClickModule>();
            for (IPowerModule module : ModuleManager.INSTANCE.getModulesOfType(IRightClickModule.class)) {
                if (!ModuleManager.INSTANCE.isValidForItem(this.stack, module) || !ModuleManager.INSTANCE.itemHasModule(this.stack, module.getDataName())) continue;
                modes.add((IRightClickModule)module);
            }
            int modeNum = 0;
            for (IRightClickModule module : modes) {
                if (this.alreadyAdded(module)) continue;
                ClickableModule clickie = new ClickableModule(module, new SpiralPointToPoint2D(this.center, this.radius, 4.71238898038469 - Math.PI * 2 * (double)modeNum / (double)modes.size(), 250.0));
                this.modeButtons.add(clickie);
                ++modeNum;
            }
        }
    }

    private void selectModule(double x, double y) {
        if (this.modeButtons != null) {
            int i = 0;
            for (ClickableModule module : this.modeButtons) {
                if (module.hitBox(x, y)) {
                    this.selectedModuleNew = i;
                    break;
                }
                ++i;
            }
        }
    }

    public ClickableModule getSelectedModule() {
        if (this.modeButtons.size() > this.selectedModuleNew && this.selectedModuleNew != -1) {
            return this.modeButtons.get(this.selectedModuleNew);
        }
        return null;
    }

    @Override
    public void update(double mousex, double mousey) {
        this.loadItems();
        if (System.currentTimeMillis() - this.spawnTime > 250L) {
            this.selectModule(mousex, mousey);
        }
        if (this.getSelectedModule() != null && this.selectedModuleOriginal != this.selectedModuleNew && !this.stack.func_190926_b() && this.stack.func_77973_b() instanceof IModeChangingItem) {
            this.selectedModuleOriginal = this.selectedModuleNew;
            ((IModeChangingItem)this.stack.func_77973_b()).setActiveMode(this.stack, this.getSelectedModule().getModule().getDataName());
            MPSPackets.sendToServer(new MusePacketModeChangeRequest(this.player, this.getSelectedModule().getModule().getDataName(), this.player.field_71071_by.field_70461_c));
        }
    }

    public void drawSelection() {
        ClickableModule module = this.getSelectedModule();
        if (module != null) {
            MusePoint2D pos = module.getPosition();
            MuseRenderer.drawCircleAround(pos.getX(), pos.getY(), 10.0);
        }
    }

    @Override
    public void draw() {
        for (ClickableModule mode : this.modeButtons) {
            mode.draw();
        }
        this.drawSelection();
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        ClickableModule module = this.getSelectedModule();
        if (module != null) {
            IPowerModule selectedModule = module.getModule();
            return Collections.singletonList(module.getLocalizedName(selectedModule));
        }
        return null;
    }
}

