/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.frame;

import java.util.List;
import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.numina.utils.math.geometry.MusePoint2D;
import net.machinemuse.numina.utils.render.MuseRenderer;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableButton;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableItem;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableModule;
import net.machinemuse.powersuits.gui.tinker.frame.ItemSelectionFrame;
import net.machinemuse.powersuits.gui.tinker.frame.ModuleSelectionFrame;
import net.machinemuse.powersuits.network.MPSPackets;
import net.machinemuse.powersuits.network.packets.MusePacketInstallModuleRequest;
import net.machinemuse.powersuits.network.packets.MusePacketSalvageModuleRequest;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class InstallSalvageFrame
extends ScrollableFrame {
    protected ItemSelectionFrame targetItem;
    protected ModuleSelectionFrame targetModule;
    protected ClickableButton installButton;
    protected ClickableButton salvageButton;
    protected EntityPlayerSP player;

    public InstallSalvageFrame(EntityPlayerSP player, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame targetItem, ModuleSelectionFrame targetModule) {
        super(topleft, bottomright, borderColour, insideColour);
        this.player = player;
        this.targetItem = targetItem;
        this.targetModule = targetModule;
        double sizex = this.border.right() - this.border.left();
        double sizey = this.border.bottom() - this.border.top();
        this.installButton = new ClickableButton(I18n.func_135052_a((String)"gui.powersuits.install", (Object[])new Object[0]), new MusePoint2D(this.border.right() - sizex / 2.0, this.border.bottom() - sizey / 4.0), true);
        this.salvageButton = new ClickableButton(I18n.func_135052_a((String)"gui.powersuits.salvage", (Object[])new Object[0]), new MusePoint2D(this.border.left() + sizex / 2.0, this.border.top() + sizey / 4.0), true);
    }

    @Override
    public void update(double mousex, double mousey) {
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        if (this.targetItem.getSelectedItem() != null && this.targetModule.getSelectedModule() != null) {
            double xoffset;
            ItemStack stack = this.targetItem.getSelectedItem().getItem();
            IPowerModule module = this.targetModule.getSelectedModule().getModule();
            NonNullList<ItemStack> itemsToCheck = ModuleManager.INSTANCE.getInstallCost(module.getDataName());
            double yoffset = !ModuleManager.INSTANCE.itemHasModule(stack, module.getDataName()) ? this.border.top() + 4.0 : this.border.bottom() - 20.0;
            if (yoffset + 16.0 > (double)y && yoffset < (double)y && (xoffset = -8.0 * (double)itemsToCheck.size() + (this.border.left() + this.border.right()) / 2.0) + (double)(16 * itemsToCheck.size()) > (double)x && xoffset < (double)x) {
                int index = (int)((double)x - xoffset) / 16;
                return ((ItemStack)itemsToCheck.get(index)).func_82840_a((EntityPlayer)this.player, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            }
        }
        return null;
    }

    @Override
    public void draw() {
        if (this.targetItem.getSelectedItem() != null && this.targetModule.getSelectedModule() != null) {
            this.drawBackground();
            this.drawItems();
            this.drawButtons();
        }
    }

    private void drawBackground() {
        super.draw();
    }

    private void drawItems() {
        ItemStack stack = this.targetItem.getSelectedItem().getItem();
        IPowerModule module = this.targetModule.getSelectedModule().getModule();
        NonNullList<ItemStack> itemsToDraw = ModuleManager.INSTANCE.getInstallCost(module.getDataName());
        double yoffset = !ModuleManager.INSTANCE.itemHasModule(stack, module.getDataName()) ? this.border.top() + 4.0 : this.border.bottom() - 20.0;
        double xoffset = -8.0 * (double)itemsToDraw.size() + (this.border.left() + this.border.right()) / 2.0;
        int i = 0;
        for (ItemStack costItem : itemsToDraw) {
            MuseRenderer.drawItemAt((double)(16 * i++) + xoffset, yoffset, costItem);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawButtons() {
        block4: {
            block3: {
                stack = this.targetItem.getSelectedItem().getItem();
                if (ModuleManager.INSTANCE.itemHasModule(stack, (module = this.targetModule.getSelectedModule().getModule()).getDataName())) break block3;
                installedModulesOfType = ModuleManager.INSTANCE.getNumberInstalledModulesOfType(stack, module.getCategory());
                if (this.player.field_71075_bZ.field_75098_d) ** GOTO lbl-1000
                if (MuseItemUtils.hasInInventory(ModuleManager.INSTANCE.getInstallCost(module.getDataName()), this.player.field_71071_by)) {
                    ** if (installedModulesOfType >= MPSConfig.getMaxModulesOfType((EnumModuleCategory)module.getCategory())) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v0 = true;
                    ** GOTO lbl12
                }
lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
lbl12:
                // 2 sources

                this.installButton.setEnabled(v0);
                this.installButton.draw();
                break block4;
            }
            this.salvageButton.draw();
        }
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
        ClickableItem selItem = this.targetItem.getSelectedItem();
        ClickableModule selModule = this.targetModule.getSelectedModule();
        if (selItem != null && selModule != null) {
            IPowerModule module;
            ItemStack stack = selItem.getItem();
            if (!ModuleManager.INSTANCE.itemHasModule(stack, (module = selModule.getModule()).getDataName())) {
                if (this.installButton.hitBox(x, y)) {
                    this.doInstall();
                }
            } else if (this.salvageButton.hitBox(x, y)) {
                this.doSalvage();
            }
        }
    }

    private void doSalvage() {
        IPowerModule module = this.targetModule.getSelectedModule().getModule();
        MPSPackets.sendToServer(new MusePacketSalvageModuleRequest((EntityPlayer)this.player, this.targetItem.getSelectedItem().inventorySlot, module.getDataName()));
    }

    private void doInstall() {
        IPowerModule module = this.targetModule.getSelectedModule().getModule();
        if (this.player.field_71075_bZ.field_75098_d || MuseItemUtils.hasInInventory(ModuleManager.INSTANCE.getInstallCost(module.getDataName()), this.player.field_71071_by)) {
            Musique.playClientSound(SoundDictionary.SOUND_EVENT_GUI_INSTALL, SoundCategory.BLOCKS, 1.0f, null);
            MPSPackets.sendToServer(new MusePacketInstallModuleRequest((EntityPlayer)this.player, this.targetItem.getSelectedItem().inventorySlot, module.getDataName()));
        }
    }
}

