/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import javax.annotation.Nonnull;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.heat.MuseHeatUtils;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.entity.EntityLuxCapacitor;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LuxCapacitor
extends PowerModuleBase
implements IRightClickModule {
    public LuxCapacitor(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), new ItemStack(Items.field_151114_aO, 1));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), new ItemStack(Items.field_151042_j, 2));
        this.addBasePropertyDouble("luxCapEnergyCon", 1000.0, "RF");
        this.addTradeoffPropertyDouble("red", "luxCapRed", 1.0, "%");
        this.addTradeoffPropertyDouble("green", "luxCapGreen", 1.0, "%");
        this.addTradeoffPropertyDouble("blue", "luxCapBlue", 1.0, "%");
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_TOOL;
    }

    @Override
    public String getDataName() {
        return "luxCapacitor";
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        if (!worldIn.field_72995_K) {
            double energyConsumption = this.getEnergyUsage(itemStackIn);
            MuseHeatUtils.heatPlayer(playerIn, energyConsumption / 500.0);
            if ((double)ElectricItemUtils.getPlayerEnergy(playerIn) > energyConsumption) {
                ElectricItemUtils.drainPlayerEnergy(playerIn, (int)energyConsumption);
                double red = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStackIn, "luxCapRed");
                double green = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStackIn, "luxCapGreen");
                double blue = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStackIn, "luxCapBlue");
                EntityLuxCapacitor luxCapacitor = new EntityLuxCapacitor(worldIn, (EntityLivingBase)playerIn, new Colour(red, green, blue));
                worldIn.func_72838_d((Entity)luxCapacitor);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "luxCapEnergyCon");
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.luxCapacitor;
    }
}

