/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils;

import asmodeuscore.core.utils.JsonUtils$ACAttributePlayer;
import asmodeuscore.core.utils.JsonUtils$ACAttributePlayer$1;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public class Utils {
    public static TextureAtlasSprite missingIcon;
    private static TextureMap texMap;
    private static volatile transient Object[] \ud3b1;

    public static void initFluidTextures(TextureMap map) {
        missingIcon = map.func_174944_f();
        texMap = map;
    }

    public static TextureAtlasSprite getBlockTexture(Block block) {
        return Utils.getBlockTexture(block, "");
    }

    public static TextureAtlasSprite getBlockTexture(Block block, String addpath) {
        if (block == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = block.getRegistryName();
        TextureAtlasSprite sprite = texMap.func_110572_b((String)Utils.\ub13c("\u63f8", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)new StringBuilder(), (String)spriteLocation.func_110624_b()), (String)JsonUtils$ACAttributePlayer.\u46bd("\uc9dd\u77a5\u6992\ud64c\u4566\u9505\ud3bc\u6c59")), (String)spriteLocation.func_110623_a()), (String)addpath)));
        return sprite != null ? sprite : missingIcon;
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill() : fluid.getFlowing();
        TextureAtlasSprite sprite = texMap.getTextureExtry(spriteLocation.toString());
        return sprite != null ? sprite : missingIcon;
    }

    public static void drawFluid(int xPos, int yPos, int scale, FluidStack fluid) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int guiWidth = 0;
        int guiHeight = 0;
        int start = 0;
        do {
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Utils.drawTexturedModalRect(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, Utils.getFluidTexture(fluid.getFluid(), FluidType.STILL), 16, 16 - (16 - renderRemaining));
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static int getIntColor(int r, int g, int b, int a) {
        int A = a * 256 * 256 * 256;
        int R = r * 256 * 256;
        int G = g * 256;
        int B = b;
        int color = A + R + G + B;
        return color - 0x1000000;
    }

    public static float calculateCelestialAngle(long worldtime, float ticks, float daylenght) {
        int j = (int)((float)worldtime % daylenght);
        float f1 = ((float)j + ticks) / daylenght - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Utils.\u5622("\u7635", (double)((double)f1 * Math.PI)) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    public static List<Integer> getPossibleDimensionsForSpaceshipTier(int tier, EntityPlayerMP playerBase) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        if (!ConfigManagerCore.disableRocketsToOverworld) {
            temp.add((Integer)Utils.\u5730("\u7441", (int)ConfigManagerCore.idDimensionOverworld));
        }
        for (Integer element : WorldUtil.registeredPlanets) {
            WorldProvider provider;
            if (Utils.\ub4f3("\u53a9", (Integer)element) == ConfigManagerCore.idDimensionOverworld || (provider = WorldUtil.getProviderForDimensionServer((int)Utils.\ub4f3("\u53a9", (Integer)element))) == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        Iterator iterator = Utils.\uc715("\u1b17", (HashMap)WorldUtil.registeredSpaceStations).iterator();
        while (iterator.hasNext()) {
            WorldProvider homeWorld;
            Integer element;
            element = (Integer)iterator.next();
            SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)Utils.\ub4f3("\u53a9", (Integer)element), null);
            if (ConfigManagerCore.spaceStationsRequirePermission && !data.getAllowedAll() && Utils.\u4799("\u83d6", (ArrayList)data.getAllowedPlayers(), (Object)PlayerUtil.getName((EntityPlayer)playerBase)) == false && !ArrayUtils.contains((Object[])playerBase.field_71133_b.func_184103_al().func_152606_n(), (Object)playerBase.func_70005_c_())) continue;
            if (playerBase != null) {
                SpaceStationWorldData dataCurrent;
                int currentWorld = playerBase.field_71093_bK;
                if (currentWorld == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
                if (playerBase.field_70170_p.field_73011_w instanceof IOrbitDimension && (dataCurrent = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)playerBase.field_71093_bK, null)).getHomePlanet() == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
            }
            if ((homeWorld = WorldUtil.getProviderForDimensionServer((int)data.getHomePlanet())) == null) continue;
            if (homeWorld instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)homeWorld).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        return temp;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(int tier, EntityPlayerMP playerBase) {
        List<Integer> ids = Utils.getPossibleDimensionsForSpaceshipTier(tier, playerBase);
        HashMap<String, Integer> map = new HashMap<String, Integer>(ids.size(), 1.0f);
        for (Integer id : ids) {
            CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForDimensionID((int)Utils.\ub4f3("\u53a9", (Integer)id));
            if (Utils.\ub4f3("\u53a9", (Integer)id) > 0 && celestialBody == null) {
                celestialBody = GalacticraftCore.satelliteSpaceStation;
                if (playerBase == null) continue;
                SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)Utils.\ub4f3("\u53a9", (Integer)id), null);
                Utils.\u5ef0("\ub82a", map, (Object)Utils.\ub13c("\u63f8", (StringBuilder)Utils.\u4cba("\u3dc1", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)Utils.\u78fe("\u4abc", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)new StringBuilder(), (String)celestialBody.getName()), (String)JsonUtils$ACAttributePlayer$1.\u06ac("\uccac")), (String)data.getOwner()), (String)JsonUtils$ACAttributePlayer$1.\u06ac("\uccac")), (String)data.getSpaceStationName()), (String)JsonUtils$ACAttributePlayer$1.\u06ac("\uccac")), (Object)id), (String)JsonUtils$ACAttributePlayer$1.\u06ac("\uccac")), (int)data.getHomePlanet())), (Object)id);
                continue;
            }
            if (celestialBody == GalacticraftCore.planetOverworld) {
                Utils.\u5ef0("\ub82a", map, (Object)celestialBody.getName(), (Object)id);
                continue;
            }
            WorldProvider provider = WorldUtil.getProviderForDimensionServer((int)Utils.\ub4f3("\u53a9", (Integer)id));
            if (celestialBody == null || provider == null || (!(provider instanceof IGalacticraftWorldProvider) || provider instanceof IOrbitDimension) && GCCoreUtil.getDimensionID((WorldProvider)provider) != 0) continue;
            Utils.\u5ef0("\ub82a", map, (Object)celestialBody.getName(), (Object)Utils.\u5730("\u7441", (int)GCCoreUtil.getDimensionID((WorldProvider)provider)));
        }
        ArrayList cBodyList = new ArrayList();
        Utils.\u1d6e("\u6311", cBodyList, GalaxyRegistry.getRegisteredPlanets().values());
        Utils.\u1d6e("\u6311", cBodyList, GalaxyRegistry.getRegisteredMoons().values());
        Object object = Utils.\u01f3("\u4323", cBodyList);
        while (object.hasNext()) {
            CelestialBody body = (CelestialBody)object.next();
            if (body.getReachable()) continue;
            Utils.\u5ef0("\ub82a", map, (Object)Utils.\ub13c("\u63f8", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)Utils.\u9eb0("\ub83a", (StringBuilder)new StringBuilder(), (String)body.getLocalizedName()), (String)JsonUtils$ACAttributePlayer$1.\u06ac("\ucca2"))), (Object)Utils.\u5730("\u7441", (int)body.getDimensionID()));
        }
        WorldUtil.celestialMapCache.put(playerBase, map);
        return map;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensionsAgain(int tier, EntityPlayerMP playerBase) {
        HashMap map = (HashMap)WorldUtil.celestialMapCache.get(playerBase);
        if (map != null) {
            return map;
        }
        return Utils.getArrayOfPossibleDimensions(tier, playerBase);
    }

    static {
        texMap = null;
    }

    private static Object \u1d6e(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[2] == null) {
            Utils.\ud3b1[2] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer.\u46bd("\uc98d\u77a6\u6988\ud642\u452b\u951b\ud3bb\u6c1f\u4adb\uf87a\u8005\u04e2\u227d\u21ec\u7037\u15ea\u6f85\u37da\uaa1d")), JsonUtils$ACAttributePlayer.\u46bd("\uc986\u77a3\u699a\ud662\u4569\u9502"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ud3b1[2];
    }

    private static Object \u4cba(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[6] == null) {
            Utils.\ud3b1[6] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer$1.\u06ac("\ucce2\ue612\u20a1\ua071\u7c71\ue2c2\u0d3a\u4ff3\ue6d9\u7314\u102e\u6f5e\u7fc8\ufd80\ue892\u12dc\uc199\uabaa\uabdc\u59b6\ud4b1\u02cb\uf35b")), JsonUtils$ACAttributePlayer$1.\u06ac("\ucce9\ue603\u20a7\ua075\u7c31\ue2ca"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ud3b1[6];
    }

    private static Object \u5730(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[7] == null) {
            Utils.\ud3b1[7] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(JsonUtils$ACAttributePlayer.\u46bd("\uc98d\u77a6\u6988\ud642\u452b\u9502\ud3ae\u6c18\u4ad0\uf87a\u800d\u04fe\u227b\u21e8\u7029\u15c3\u6f9e")), JsonUtils$ACAttributePlayer.\u46bd("\uc991\u77a6\u6992\ud656\u4560\u9521\ud3a9"), methodType).asType(methodType));
        }
        return \ud3b1[7];
    }

    private static Object \ub13c(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[0] == null) {
            Utils.\ud3b1[0] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer.\u46bd("\uc98d\u77a6\u6988\ud642\u452b\u9502\ud3ae\u6c18\u4ad0\uf87a\u8017\u04e4\u227d\u21e4\u7020\u15c1\u6fae\u37dc\uaa00\uc2f8\ucaf8\u1b5e\u9564")), JsonUtils$ACAttributePlayer.\u46bd("\uc993\u77a8\u69ad\ud657\u4577\u9507\ud3a1\u6c11"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ud3b1[0];
    }

    private static Object \uc715(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[10] == null) {
            Utils.\ud3b1[10] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer.\u46bd("\uc98d\u77a6\u6988\ud642\u452b\u951b\ud3bb\u6c1f\u4adb\uf87a\u800c\u04f1\u227c\u21e5\u7003\u15c7\u6f9c")), JsonUtils$ACAttributePlayer.\u46bd("\uc98c\u77a2\u6987\ud670\u4560\u951a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ud3b1[10];
    }

    private static Object \ub4f3(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[11] == null) {
            Utils.\ud3b1[11] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer$1.\u06ac("\ucce2\ue612\u20a1\ua071\u7c71\ue2c2\u0d3a\u4ff3\ue6d9\u7314\u1034\u6f44\u7fce\ufd8c\ue89b\u12de\uc1a9")), JsonUtils$ACAttributePlayer$1.\u06ac("\ucce1\ue61d\u20a3\ua046\u7c3e\ue2c2\u0d2e\u4ff8"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ud3b1[11];
    }

    private static Object \u4799(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[9] == null) {
            Utils.\ud3b1[9] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer.\u46bd("\uc98d\u77a6\u6988\ud642\u452b\u951b\ud3bb\u6c1f\u4adb\uf87a\u8005\u04e2\u227d\u21ec\u7037\u15ea\u6f85\u37da\uaa1d")), JsonUtils$ACAttributePlayer.\u46bd("\uc984\u77a8\u6990\ud657\u4564\u9507\ud3a1\u6c05"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ud3b1[9];
    }

    private static Object \u01f3(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[5] == null) {
            Utils.\ud3b1[5] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer.\u46bd("\uc98d\u77a6\u6988\ud642\u452b\u951b\ud3bb\u6c1f\u4adb\uf87a\u8005\u04e2\u227d\u21ec\u7037\u15ea\u6f85\u37da\uaa1d")), JsonUtils$ACAttributePlayer.\u46bd("\uc98e\u77b3\u699b\ud651\u4564\u951a\ud3a0\u6c04"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ud3b1[5];
    }

    private static Object \u5622(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[4] == null) {
            Utils.\ud3b1[4] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(JsonUtils$ACAttributePlayer$1.\u06ac("\ucce2\ue612\u20a1\ua071\u7c71\ue2c2\u0d3a\u4ff3\ue6d9\u7314\u1030\u6f4b\u7fce\ufd81")), JsonUtils$ACAttributePlayer$1.\u06ac("\ucceb\ue61c\u20a4"), methodType).asType(methodType));
        }
        return \ud3b1[4];
    }

    private static Object \u9eb0(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[3] == null) {
            Utils.\ud3b1[3] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer.\u46bd("\uc98d\u77a6\u6988\ud642\u452b\u9502\ud3ae\u6c18\u4ad0\uf87a\u8017\u04e4\u227d\u21e4\u7020\u15c1\u6fae\u37dc\uaa00\uc2f8\ucaf8\u1b5e\u9564")), JsonUtils$ACAttributePlayer.\u46bd("\uc986\u77b7\u698e\ud646\u456b\u950a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ud3b1[3];
    }

    private static Object \u5ef0(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[1] == null) {
            Utils.\ud3b1[1] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer.\u46bd("\uc98d\u77a6\u6988\ud642\u452b\u951b\ud3bb\u6c1f\u4adb\uf87a\u800c\u04f1\u227c\u21e5\u7003\u15c7\u6f9c")), JsonUtils$ACAttributePlayer.\u46bd("\uc997\u77b2\u698a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ud3b1[1];
    }

    private static Object \u78fe(Object object, String string, MethodType methodType) {
        if (\ud3b1 == null) {
            \ud3b1 = new Object[12];
        }
        if (\ud3b1[8] == null) {
            Utils.\ud3b1[8] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer.\u46bd("\uc98d\u77a6\u6988\ud642\u452b\u9502\ud3ae\u6c18\u4ad0\uf87a\u8017\u04e4\u227d\u21e4\u7020\u15c1\u6fae\u37dc\uaa00\uc2f8\ucaf8\u1b5e\u9564")), JsonUtils$ACAttributePlayer.\u46bd("\uc986\u77b7\u698e\ud646\u456b\u950a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ud3b1[8];
    }

    public static enum FluidType {
        STILL,
        FLOWING;

        private static volatile transient Object[] \u51c8;

        private static Object \u4a9b(Object object, String string, MethodType methodType) {
            if (\u51c8 == null) {
                \u51c8 = new Object[1];
            }
            if (\u51c8[0] == null) {
                FluidType.\u51c8[0] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(JsonUtils$ACAttributePlayer.\u46bd("\uc98d\u77a6\u6988\ud642\u452b\u9502\ud3ae\u6c18\u4ad0\uf87a\u8001\u04fe\u227a\u21e0")), JsonUtils$ACAttributePlayer.\u46bd("\uc991\u77a6\u6992\ud656\u4560\u9521\ud3a9"), methodType).asType(methodType));
            }
            return \u51c8[0];
        }
    }
}

