/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.api.energy;

import net.minecraft.nbt.NBTTagCompound;

public enum EnergyType {
    FE("Forge Energy", "FE", "FE/T"),
    TESLA("Tesla", "T", "T/t"),
    RF("Redstone Flux", "RF", "RF/T"),
    EU("Energy Units", "EU", "EU/T"),
    MJ("Minecraft Joules", "J", "J/T"),
    AE("Applied Energistics", "AE", "AE/t");

    private String name = "";
    private String storage = "";
    private String usage = "";

    private EnergyType(String name, String storage, String usage) {
        this.name = name;
        this.storage = storage;
        this.usage = usage;
    }

    public String getName() {
        return this.name;
    }

    public String getStorageSuffix() {
        return this.storage;
    }

    public String getUsageSuffix() {
        return this.usage;
    }

    public static EnergyType readFromNBT(NBTTagCompound tag, String tagName) {
        String storage_name = tag.func_74779_i(tagName);
        if (!storage_name.isEmpty()) {
            for (EnergyType type : EnergyType.values()) {
                if (!type.name.equals(storage_name)) continue;
                return type;
            }
            return FE;
        }
        int storage_ordinal = tag.func_74762_e(tagName);
        return EnergyType.values()[storage_ordinal];
    }

    public static NBTTagCompound writeToNBT(EnergyType type, NBTTagCompound tag, String tagName) {
        tag.func_74768_a(tagName, type.ordinal());
        return tag;
    }
}

