/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.oc;

import gcewing.sg.BaseConfiguration;
import gcewing.sg.SGBaseTE;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Packet;
import li.cil.oc.api.network.WirelessEndpoint;
import net.minecraft.world.World;

public class OCWirelessEndpoint
implements WirelessEndpoint {
    public static double forwardingStrength = 50.0;
    static boolean debugWireless = false;
    SGBaseTE te;

    public static void configure(BaseConfiguration config) {
        forwardingStrength = config.getDouble("opencomputers", "wirelessRebroadcastStrength", forwardingStrength);
    }

    public OCWirelessEndpoint(SGBaseTE te) {
        if (debugWireless) {
            System.out.printf("SGCraft: OCSGWirelessEndpoint: added %s for %s\n", this, te);
        }
        this.te = te;
        Network.joinWirelessNetwork((WirelessEndpoint)this);
    }

    public void remove() {
        if (debugWireless) {
            System.out.printf("SGCraft: OCSGWirelessEndpoint: removed for %s\n", this.te);
        }
        Network.leaveWirelessNetwork((WirelessEndpoint)this);
    }

    public int x() {
        return this.te.func_174877_v().func_177958_n();
    }

    public int y() {
        return this.te.func_174877_v().func_177956_o();
    }

    public int z() {
        return this.te.func_174877_v().func_177952_p();
    }

    public World world() {
        return this.te.func_145831_w();
    }

    public void receivePacket(Packet packet, WirelessEndpoint sender) {
        SGBaseTE dte;
        if (debugWireless) {
            System.out.printf("OCSGWirelessEndpoint.receivePacket: ttl %s from %s by %s\n", packet.ttl(), sender, this.te);
        }
        if (packet.ttl() > 0 && (dte = this.te.getConnectedStargateTE()) != null && dte.ocWirelessEndpoint != null) {
            if (debugWireless) {
                System.out.printf("OCSGWirelessEndpoint.receivePacket: forwarding to %s\n", dte);
            }
            Network.sendWirelessPacket((WirelessEndpoint)dte.ocWirelessEndpoint, (double)forwardingStrength, (Packet)packet.hop());
        }
    }
}

