/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.HashMap;
import java.util.Map;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityBlockDiaphanous
extends TileEntityBase {
    IBlockState toDisplay = Blocks.field_150348_b.func_176223_P();
    HashMap<EnumFacing, Boolean> renderMap = new HashMap();
    boolean isItem = false;
    boolean inverted = false;

    public TileEntityBlockDiaphanous() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.renderMap.put(facing, true);
        }
    }

    public void setItem() {
        this.isItem = true;
    }

    public boolean isItem() {
        return this.isItem;
    }

    public IBlockState getDisplayState() {
        return this.toDisplay;
    }

    @Override
    public boolean syncAdditionalData() {
        return true;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            compound.func_74757_a(facing.toString().toLowerCase(), this.renderMap.get(facing).booleanValue());
        }
        compound.func_74778_a("block", this.toDisplay.func_177230_c().getRegistryName().toString());
        compound.func_74768_a("meta", this.toDisplay.func_177230_c().func_176201_c(this.toDisplay));
        compound.func_74757_a("inverted", this.inverted);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.renderMap.put(facing, compound.func_74767_n(facing.toString().toLowerCase()));
        }
        Block b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("block")));
        int meta = compound.func_74762_e("meta");
        try {
            this.toDisplay = b.func_176203_a(meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.toDisplay = Blocks.field_150348_b.func_176223_P();
        }
        this.inverted = compound.func_74767_n("inverted");
    }

    @Override
    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        int n = enumFacingArray.length;
        for (int i = 0; i < n; ++i) {
            EnumFacing facing;
            IBlockState neighbor = worldIn.func_180495_p(pos.func_177972_a(facing = enumFacingArray[i]));
            this.renderMap.put(facing, !neighbor.isSideSolid((IBlockAccess)worldIn, pos.func_177972_a(facing), facing.func_176734_d()) && neighbor.func_177230_c() != ModBlocks.blockDiaphanous);
        }
        this.syncTE();
    }

    public boolean shouldRenderSide(EnumFacing facing) {
        return this.renderMap.get(facing);
    }

    public Map<EnumFacing, Boolean> getFacingMap() {
        return this.renderMap;
    }

    public void setDisplayState(IBlockState toDisplay) {
        this.toDisplay = toDisplay;
        this.syncTE();
    }

    public void setDisplayStateInternal(IBlockState toDisplay) {
        this.toDisplay = toDisplay;
    }
}

