/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.base;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.blocks.render.IHasModel;
import de.ellpeck.actuallyadditions.mod.config.ConfigValues;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class BlockContainerBase
extends BlockContainer
implements ItemBlockBase.ICustomRarity,
IHasModel {
    private final String name;

    public BlockContainerBase(Material material, String name) {
        super(material);
        this.name = name;
        this.register();
    }

    private void register() {
        ItemUtil.registerBlock((Block)this, this.getItemBlock(), this.getBaseName(), this.shouldAddCreative());
    }

    protected String getBaseName() {
        return this.name;
    }

    protected ItemBlockBase getItemBlock() {
        return new ItemBlockBase((Block)this);
    }

    public boolean shouldAddCreative() {
        return true;
    }

    @Override
    public void registerRendering() {
        ActuallyAdditions.PROXY.addRenderRegister(new ItemStack((Block)this), this.getRegistryName(), "inventory");
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    private void dropInventory(World world, BlockPos position) {
        TileEntity aTile;
        if (!world.field_72995_K && (aTile = world.func_175625_s(position)) instanceof TileEntityInventoryBase) {
            TileEntityInventoryBase tile = (TileEntityInventoryBase)aTile;
            if (tile.inv.getSlots() > 0) {
                for (int i = 0; i < tile.inv.getSlots(); ++i) {
                    this.dropSlotFromInventory(i, tile, world, position);
                }
            }
        }
    }

    private void dropSlotFromInventory(int i, TileEntityInventoryBase tile, World world, BlockPos pos) {
        ItemStack stack = tile.inv.getStackInSlot(i);
        if (StackUtil.isValid(stack)) {
            float dX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float dY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float dZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + dX), (double)((float)pos.func_177956_o() + dY), (double)((float)pos.func_177952_p() + dZ), stack.func_77946_l());
            float factor = 0.05f;
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)factor;
            entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public boolean tryToggleRedstone(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        ItemStack stack = player.func_184614_ca();
        if (StackUtil.isValid(stack) && stack.func_77973_b() == ConfigValues.itemRedstoneTorchConfigurator && (tile = world.func_175625_s(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            if (!world.field_72995_K && base.isRedstoneToggle()) {
                base.isPulseMode = !base.isPulseMode;
                base.func_70296_d();
                base.sendUpdate();
            }
            return true;
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        TileEntityBase base;
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityBase && (base = (TileEntityBase)tile).respondsToPulses()) {
            base.activateOnPulse();
        }
    }

    public void neighborsChangedCustom(World world, BlockPos pos) {
        TileEntityBase base;
        this.updateRedstoneState(world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBase && (base = (TileEntityBase)tile).shouldSaveDataOnChangeOrWorldStart()) {
            base.saveDataOnChangeOrWorldStart();
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos otherPos) {
        this.neighborsChangedCustom(worldIn, pos);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        if (world instanceof World) {
            this.neighborsChangedCustom((World)world, pos);
        }
    }

    public void updateRedstoneState(World world, BlockPos pos) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            boolean powered = world.func_175687_A(pos) > 0;
            boolean wasPowered = base.isRedstonePowered;
            if (powered && !wasPowered) {
                if (base.respondsToPulses()) {
                    world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
                }
                base.setRedstonePowered(true);
            } else if (!powered && wasPowered) {
                base.setRedstonePowered(false);
            }
        }
    }

    protected boolean tryUseItemOnTank(EntityPlayer player, EnumHand hand, FluidTank tank) {
        ItemStack heldItem = player.func_184586_b(hand);
        return StackUtil.isValid(heldItem) && FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)tank);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.updateRedstoneState(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile;
        if (stack.func_77942_o() && (tile = world.func_175625_s(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            NBTTagCompound compound = stack.func_77978_p().func_74775_l("Data");
            if (compound != null) {
                base.readSyncableNBT(compound, TileEntityBase.NBTType.SAVE_BLOCK);
            }
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile;
        if (!player.field_71075_bZ.field_75098_d && (tile = world.func_175625_s(pos)) instanceof TileEntityBase && ((TileEntityBase)tile).stopFromDropping) {
            player.func_145747_a(new TextComponentTranslation("info.actuallyadditions.machineBroke", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBase) {
            return ((TileEntityBase)tile).getComparatorStrength();
        }
        return 0;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            if (!base.stopFromDropping) {
                NBTTagCompound data = new NBTTagCompound();
                base.writeSyncableNBT(data, TileEntityBase.NBTType.SAVE_BLOCK);
                ArrayList<String> keysToRemove = new ArrayList<String>();
                for (String key : data.func_150296_c()) {
                    NBTBase tag = data.func_74781_a(key);
                    if (!(tag instanceof NBTTagInt) || ((NBTTagInt)tag).func_150287_d() != 0) continue;
                    keysToRemove.add(key);
                }
                for (String key : keysToRemove) {
                    data.func_82580_o(key);
                }
                ItemStack stack = new ItemStack(this.func_180660_a(state, tile.func_145831_w().field_73012_v, fortune), 1, this.func_180651_a(state));
                if (!data.func_82582_d()) {
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74782_a("Data", (NBTBase)data);
                }
                drops.add((Object)stack);
            }
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (this.shouldDropInventory(world, pos)) {
            this.dropInventory(world, pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean shouldDropInventory(World world, BlockPos pos) {
        return true;
    }
}

