/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.capabilities;

import javax.annotation.Nonnull;
import net.machinemuse.numina.capabilities.heat.HeatStorage;
import net.machinemuse.numina.module.IModuleManager;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.numina.utils.nbt.MuseNBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class MuseHeatItemWrapper
extends HeatStorage
implements INBTSerializable<NBTTagCompound> {
    IModuleManager moduleManager;
    ItemStack container;
    double baseMaxHeat;

    public MuseHeatItemWrapper(@Nonnull ItemStack container, double baseMaxHeat, IModuleManager moduleManagerIn) {
        super(moduleManagerIn.getOrSetModularPropertyDouble(container, "maxHeat") + baseMaxHeat);
        this.container = container;
        this.moduleManager = moduleManagerIn;
        this.baseMaxHeat = baseMaxHeat;
    }

    @Override
    public double receiveHeat(double heatProvided, boolean simulate) {
        if (!this.canReceive()) {
            return 0.0;
        }
        double heatReceived = super.receiveHeat(heatProvided, simulate);
        if (!simulate && heatReceived > 0.0) {
            NBTTagCompound nbt = this.serializeNBT();
            this.heat = nbt.func_150297_b("curHeat", 6) ? nbt.func_74769_h("curHeat") : 0.0;
            this.maxExtract = this.maxReceive = nbt.func_74769_h("maxHeat");
            this.capacity = this.maxReceive;
            MuseItemUtils.setDoubleOrRemove(this.container, "curHeat", this.heat);
        }
        return heatReceived;
    }

    @Override
    public double extractHeat(double heatRequested, boolean simulate) {
        if (!this.canExtract()) {
            return 0.0;
        }
        double heatExtracted = super.extractHeat(heatRequested, simulate);
        if (!simulate) {
            NBTTagCompound nbt = this.serializeNBT();
            this.heat = nbt.func_150297_b("curHeat", 6) ? nbt.func_74769_h("curHeat") : 0.0;
            this.maxExtract = this.maxReceive = nbt.func_74769_h("maxHeat");
            this.capacity = this.maxReceive;
            MuseItemUtils.setDoubleOrRemove(this.container, "curHeat", this.heat);
        }
        return heatExtracted;
    }

    public void updateFromNBT() {
        NBTTagCompound itemNBT = MuseNBTUtils.getMuseItemTag(this.container);
        NBTTagCompound outNBT = new NBTTagCompound();
        this.maxExtract = this.maxReceive = this.moduleManager.getOrSetModularPropertyDouble(this.container, "maxHeat") + this.baseMaxHeat;
        this.capacity = this.maxReceive;
        this.heat = Math.round(MuseItemUtils.getDoubleOrZero(itemNBT, "curHeat"));
        outNBT.func_74780_a("maxHeat", this.capacity);
        if (this.heat > 0.0) {
            outNBT.func_74780_a("curHeat", this.heat);
        }
        this.deserializeNBT(outNBT);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.heat > 0.0) {
            nbt.func_74780_a("curHeat", this.heat);
        }
        nbt.func_74780_a("maxHeat", this.capacity);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.heat = nbt.func_150297_b("curHeat", 6) ? nbt.func_74769_h("curHeat") : 0.0;
        this.maxExtract = this.maxReceive = nbt.func_74769_h("maxHeat");
        this.capacity = this.maxReceive;
    }
}

