/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import java.util.Objects;
import java.util.Optional;
import net.machinemuse.powersuits.client.model.obj.OBJModelPlus;
import net.machinemuse.powersuits.client.render.modelspec.EnumSpecType;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.SpecBase;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelSpec
extends SpecBase {
    private final OBJModelPlus.OBJBakedModelPus model;
    private final IModelState modelState;

    public ModelSpec(OBJModelPlus.OBJBakedModelPus model, IModelState state, String name, boolean isDefault, EnumSpecType specType) {
        super(name, isDefault, specType);
        this.modelState = state;
        this.model = model;
    }

    public TRSRTransformation getTransform(ItemCameraTransforms.TransformType transformType) {
        Optional transformation = this.modelState.apply(Optional.of(transformType));
        return transformation.orElse(TRSRTransformation.identity());
    }

    @Override
    public String getDisaplayName() {
        return I18n.func_135052_a((String)("model." + this.getOwnName() + ".modelName"), (Object[])new Object[0]);
    }

    @Override
    public String getOwnName() {
        String name = (String)ModelRegistry.getInstance().getName(this);
        return name != null ? name : "";
    }

    public OBJModelPlus.OBJBakedModelPus getModel() {
        return this.model;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelSpec modelSpec = (ModelSpec)o;
        return Objects.equals(this.model, modelSpec.model) && Objects.equals(this.modelState, modelSpec.modelState);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.model, this.modelState);
    }
}

