/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.common.config.NuminaConfig;
import net.machinemuse.numina.control.PlayerInputMap;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IToggleableModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.utils.MusePlayerUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class JetBootsModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public JetBootsModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.ionThruster, 2));
        this.addBasePropertyDouble("jetBootsEnergyCon", 0.0);
        this.addBasePropertyDouble("jetbootsThrust", 0.0);
        this.addTradeoffPropertyDouble("thrust", "jetBootsEnergyCon", 750.0, "RF");
        this.addTradeoffPropertyDouble("thrust", "jetbootsThrust", 0.08);
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_MOVEMENT;
    }

    @Override
    public String getDataName() {
        return "jetBoots";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (player.func_70090_H()) {
            return;
        }
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.func_174793_f().func_70005_c_());
        boolean jumpkey = movementInput.jumpKey;
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        boolean hasFlightControl = ModuleManager.INSTANCE.itemHasActiveModule(helmet, "flightControl");
        double jetEnergy = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "jetBootsEnergyCon");
        double thrust = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "jetbootsThrust");
        if (jetEnergy < (double)ElectricItemUtils.getPlayerEnergy(player)) {
            if (hasFlightControl && thrust > 0.0) {
                thrust = MusePlayerUtils.thrust(player, thrust, true);
                if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                    Musique.playerSound(player, SoundDictionary.SOUND_EVENT_JETBOOTS, SoundCategory.PLAYERS, (float)(thrust * 12.5), Float.valueOf(1.0f), (Boolean)true);
                }
                ElectricItemUtils.drainPlayerEnergy(player, (int)(thrust * jetEnergy));
            } else if (jumpkey && player.field_70181_x < 0.5) {
                thrust = MusePlayerUtils.thrust(player, thrust, false);
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
                    Musique.playerSound(player, SoundDictionary.SOUND_EVENT_JETBOOTS, SoundCategory.PLAYERS, (float)(thrust * 12.5), Float.valueOf(1.0f), (Boolean)true);
                }
                ElectricItemUtils.drainPlayerEnergy(player, (int)(thrust * jetEnergy));
            } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                Musique.stopPlayerSound(player, SoundDictionary.SOUND_EVENT_JETBOOTS);
            }
        } else if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
            Musique.stopPlayerSound(player, SoundDictionary.SOUND_EVENT_JETBOOTS);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
            Musique.stopPlayerSound(player, SoundDictionary.SOUND_EVENT_JETBOOTS);
        }
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.jetBoots;
    }
}

