/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.utils;

import com.enderio.core.common.transform.EnderCoreMethods;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nonnull;
import net.machinemuse.numina.common.ModCompatibility;
import net.machinemuse.numina.control.PlayerInputMap;
import net.machinemuse.numina.item.IModularItem;
import net.machinemuse.numina.player.NuminaPlayerUtils;
import net.machinemuse.numina.utils.MuseLogger;
import net.machinemuse.numina.utils.math.MuseMathUtils;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.chunk.Chunk;

public class MusePlayerUtils {
    static final double root2 = Math.sqrt(2.0);
    protected static Field movementfactorfieldinstance;

    public static RayTraceResult raytraceEntities(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        RayTraceResult pickedEntity = null;
        Vec3d playerPosition = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d playerLook = player.func_70040_Z();
        Vec3d playerViewOffset = new Vec3d(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance, playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance, playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance);
        AxisAlignedBB boxToScan = player.func_174813_aQ().func_72321_a(playerLook.field_72450_a * reachDistance, playerLook.field_72448_b * reachDistance, playerLook.field_72449_c * reachDistance);
        List entitiesHit = world.func_72839_b((Entity)player, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesHit == null || entitiesHit.isEmpty()) {
            return null;
        }
        for (Entity entityHit : entitiesHit) {
            if (entityHit == null || !entityHit.func_70067_L() || entityHit.func_174813_aQ() == null) continue;
            float border = entityHit.func_70111_Y();
            AxisAlignedBB aabb = entityHit.func_174813_aQ().func_72321_a((double)border, (double)border, (double)border);
            RayTraceResult raytraceResult = aabb.func_72327_a(playerPosition, playerViewOffset);
            if (raytraceResult == null) continue;
            if (aabb.func_72318_a(playerPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0 || (pickedEntity = new RayTraceResult(entityHit)) == null) continue;
                pickedEntity.field_72307_f = raytraceResult.field_72307_f;
                closestEntity = 0.0;
                continue;
            }
            double distance = playerPosition.func_72438_d(raytraceResult.field_72307_f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new RayTraceResult(entityHit);
            pickedEntity.field_72307_f = raytraceResult.field_72307_f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public static RayTraceResult raytraceBlocks(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        Vec3d playerPosition = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d playerLook = player.func_70040_Z();
        Vec3d playerViewOffset = new Vec3d(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance, playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance, playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance);
        return world.func_72933_a(playerPosition, playerViewOffset);
    }

    public static RayTraceResult doCustomRayTrace(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        RayTraceResult pickedBlock = MusePlayerUtils.raytraceBlocks(world, player, collisionFlag, reachDistance);
        RayTraceResult pickedEntity = MusePlayerUtils.raytraceEntities(world, player, collisionFlag, reachDistance);
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        Vec3d playerPosition = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        double dBlock = pickedBlock.field_72307_f.func_72438_d(playerPosition);
        double dEntity = pickedEntity.field_72307_f.func_72438_d(playerPosition);
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public static void teleportEntity(EntityPlayer entityPlayer, RayTraceResult rayTraceResult) {
        if (rayTraceResult != null && entityPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
            if (player.field_71135_a.field_147371_a.func_150724_d()) {
                switch (rayTraceResult.field_72313_a) {
                    case ENTITY: {
                        player.func_70634_a(rayTraceResult.field_72307_f.field_72450_a, rayTraceResult.field_72307_f.field_72448_b, rayTraceResult.field_72307_f.field_72449_c);
                        break;
                    }
                    case BLOCK: {
                        double hitx = rayTraceResult.field_72307_f.field_72450_a;
                        double hity = rayTraceResult.field_72307_f.field_72448_b;
                        double hitz = rayTraceResult.field_72307_f.field_72449_c;
                        switch (rayTraceResult.field_178784_b) {
                            case DOWN: {
                                hity -= 2.0;
                                break;
                            }
                            case UP: {
                                break;
                            }
                            case NORTH: {
                                hitx -= 0.5;
                                break;
                            }
                            case SOUTH: {
                                hitx += 0.5;
                                break;
                            }
                            case WEST: {
                                hitz += 0.5;
                                break;
                            }
                            case EAST: {
                                hitz -= 0.5;
                            }
                        }
                        player.func_70634_a(hitx, hity, hitz);
                        break;
                    }
                }
            }
        }
    }

    public static double thrust(EntityPlayer player, double thrust, boolean flightControl) {
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.func_174793_f().func_70005_c_());
        boolean jumpkey = movementInput.jumpKey;
        float forwardkey = movementInput.forwardKey;
        float strafekey = movementInput.strafeKey;
        boolean downkey = movementInput.downKey;
        boolean sneakkey = movementInput.sneakKey;
        double thrustUsed = 0.0;
        if (flightControl) {
            Vec3d desiredDirection = player.func_70040_Z().func_72432_b();
            double strafeX = desiredDirection.field_72449_c;
            double strafeZ = -desiredDirection.field_72450_a;
            double flightVerticality = 0.0;
            ItemStack helm = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!helm.func_190926_b() && helm.func_77973_b() instanceof IModularItem) {
                flightVerticality = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(helm, "yLookRatio");
            }
            desiredDirection = new Vec3d(desiredDirection.field_72450_a * (double)Math.signum(forwardkey) + strafeX * (double)Math.signum(strafekey), flightVerticality * desiredDirection.field_72448_b * (double)Math.signum(forwardkey) + (double)(jumpkey ? 1 : 0) - (double)(downkey ? 1 : 0), desiredDirection.field_72449_c * (double)Math.signum(forwardkey) + strafeZ * (double)Math.signum(strafekey));
            desiredDirection = desiredDirection.func_72432_b();
            if (player.field_70181_x < 0.0 && desiredDirection.field_72448_b >= 0.0) {
                if (-player.field_70181_x > thrust) {
                    player.field_70181_x += thrust;
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrust -= player.field_70181_x;
                    thrustUsed += player.field_70181_x;
                    player.field_70181_x = 0.0;
                }
            }
            if (player.field_70181_x < -1.0) {
                thrust += 1.0 + player.field_70181_x;
                thrustUsed -= 1.0 + player.field_70181_x;
                player.field_70181_x = -1.0;
            }
            if (Math.abs(player.field_70159_w) > 0.0 && desiredDirection.func_72433_c() == 0.0) {
                if (Math.abs(player.field_70159_w) > thrust) {
                    player.field_70159_w -= Math.signum(player.field_70159_w) * thrust;
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrust -= Math.abs(player.field_70159_w);
                    thrustUsed += Math.abs(player.field_70159_w);
                    player.field_70159_w = 0.0;
                }
            }
            if (Math.abs(player.field_70179_y) > 0.0 && desiredDirection.func_72433_c() == 0.0) {
                if (Math.abs(player.field_70179_y) > thrust) {
                    player.field_70179_y -= Math.signum(player.field_70179_y) * thrust;
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrustUsed += Math.abs(player.field_70179_y);
                    thrust -= Math.abs(player.field_70179_y);
                    player.field_70179_y = 0.0;
                }
            }
            double vx = thrust * desiredDirection.field_72450_a;
            double vy = thrust * desiredDirection.field_72448_b;
            double vz = thrust * desiredDirection.field_72449_c;
            player.field_70159_w += vx;
            player.field_70181_x += vy;
            player.field_70179_y += vz;
            thrustUsed += thrust;
        } else {
            Vec3d playerHorzFacing = player.func_70040_Z();
            playerHorzFacing = new Vec3d(playerHorzFacing.field_72450_a, 0.0, playerHorzFacing.field_72449_c);
            playerHorzFacing.func_72432_b();
            if (forwardkey == 0.0f) {
                player.field_70181_x += thrust;
            } else {
                player.field_70181_x += thrust / root2;
                player.field_70159_w += playerHorzFacing.field_72450_a * thrust / root2 * (double)Math.signum(forwardkey);
                player.field_70179_y += playerHorzFacing.field_72449_c * thrust / root2 * (double)Math.signum(forwardkey);
            }
            thrustUsed += thrust;
        }
        double horzm2 = player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y;
        double horzmlim = MPSConfig.INSTANCE.getMaximumFlyingSpeedmps() * MPSConfig.INSTANCE.getMaximumFlyingSpeedmps() / 400.0;
        if (sneakkey && horzmlim > 0.05) {
            horzmlim = 0.05;
        }
        if (horzm2 > horzmlim) {
            double ratio = Math.sqrt(horzmlim / horzm2);
            player.field_70159_w *= ratio;
            player.field_70179_y *= ratio;
        }
        NuminaPlayerUtils.resetFloatKickTicks(player);
        return thrustUsed;
    }

    public static EntityPlayer toPlayer(Object data) {
        EntityPlayer player = null;
        try {
            player = (EntityPlayer)data;
        }
        catch (ClassCastException e) {
            MuseLogger.logError("MMMPS: Player tick handler received invalid Player object");
            e.printStackTrace();
        }
        return player;
    }

    public static double getPlayerCoolingBasedOnMaterial(@Nonnull EntityPlayer player) {
        if (ModCompatibility.isEnderCoreLoaded() ? EnderCoreMethods.isInLavaSafe((Entity)player) : player.func_180799_ab()) {
            return 0.0;
        }
        double cool = 2.0 - (double)(MusePlayerUtils.getBiome(player).func_180626_a(new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v)) / 2.0f);
        if (player.func_70090_H()) {
            cool += 0.5;
        }
        if ((int)player.field_70163_u > 128) {
            cool += 0.5;
        }
        if (!player.field_70170_p.func_72935_r() && MusePlayerUtils.getBiome(player) instanceof BiomeDesert) {
            cool += 0.8;
        }
        if (player.field_70170_p.func_180494_b(player.func_180425_c()).func_76738_d() && player.field_70170_p.func_72896_J() && player.field_70170_p.func_175710_j(player.func_180425_c().func_177982_a(0, 1, 0))) {
            cool += 0.2;
        }
        return cool;
    }

    public static Biome getBiome(EntityPlayer player) {
        Chunk chunk = player.field_70170_p.func_175726_f(player.func_180425_c());
        return chunk.func_177411_a(player.func_180425_c(), player.field_70170_p.func_72959_q());
    }

    public static void setFOVMult(EntityPlayer player, float fovmult) {
        Field movementfactor = MusePlayerUtils.getMovementFactorField();
        try {
            movementfactor.set(player, Float.valueOf(fovmult));
        }
        catch (IllegalAccessException e) {
            MuseLogger.logDebug("illegalAccessException");
        }
    }

    public static Field getMovementFactorField() {
        if (movementfactorfieldinstance == null) {
            try {
                movementfactorfieldinstance = EntityPlayer.class.getDeclaredField("speedOnGround");
                movementfactorfieldinstance.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                try {
                    movementfactorfieldinstance = EntityPlayer.class.getDeclaredField("field_71108_cd");
                    movementfactorfieldinstance.setAccessible(true);
                }
                catch (NoSuchFieldException e1) {
                    try {
                        movementfactorfieldinstance = EntityPlayer.class.getDeclaredField("ci");
                        movementfactorfieldinstance.setAccessible(true);
                    }
                    catch (NoSuchFieldException e2) {
                        MuseLogger.logDebug("Getting failed");
                    }
                }
            }
        }
        return movementfactorfieldinstance;
    }

    public static double computePlayerVelocity(EntityPlayer entityPlayer) {
        return MuseMathUtils.pythag(entityPlayer.field_70159_w, entityPlayer.field_70181_x, entityPlayer.field_70179_y);
    }
}

