/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import cubex2.cs4.plugins.vanilla.ShapedRecipe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class DamageableShapedOreRecipe
extends ShapedOreRecipe {
    private final int[] damageAmounts;
    private final int[] mirroredDamageAmounts;
    private int matchX;
    private int matchY;
    private boolean wasMirrored;

    public DamageableShapedOreRecipe(@Nullable ResourceLocation group, int[] damageAmounts, @Nonnull ItemStack result, Object ... recipe) {
        super(group, result, recipe);
        this.damageAmounts = damageAmounts;
        this.mirroredDamageAmounts = this.mirror(damageAmounts);
    }

    private DamageableShapedOreRecipe(@Nullable ResourceLocation group, int[] damageAmounts, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
        this.damageAmounts = damageAmounts;
        this.mirroredDamageAmounts = this.mirror(damageAmounts);
    }

    private int[] mirror(int[] array) {
        int[] result = new int[array.length];
        for (int col = 0; col < this.getWidth(); ++col) {
            for (int row = 0; row < this.getHeight(); ++row) {
                result[this.getWidth() - 1 - col + row * this.getWidth()] = array[col + row * this.getWidth()];
            }
        }
        return result;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList items = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.getMatch(inv);
        int[] amounts = this.getAmounts(this.wasMirrored);
        for (int col = 0; col < this.getWidth(); ++col) {
            for (int row = 0; row < this.getHeight(); ++row) {
                int amountIndex = col + row * this.getWidth();
                int invIndex = this.matchX + col + (row + this.matchY) * inv.func_174922_i();
                int amount = amounts[amountIndex];
                if (amount > 0) {
                    ItemStack stack = inv.func_70301_a(invIndex).func_77946_l();
                    stack.func_77964_b(stack.func_77952_i() + amount);
                    if (stack.func_77952_i() > stack.func_77958_k()) {
                        stack = ForgeHooks.getContainerItem((ItemStack)stack);
                    }
                    items.set(invIndex, (Object)stack);
                    continue;
                }
                items.set(invIndex, (Object)ForgeHooks.getContainerItem((ItemStack)inv.func_70301_a(invIndex)));
            }
        }
        return items;
    }

    private int[] getAmounts(boolean mirror) {
        return mirror ? this.mirroredDamageAmounts : this.damageAmounts;
    }

    private void getMatch(InventoryCrafting inv) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    this.matchX = x;
                    this.matchY = y;
                    this.wasMirrored = false;
                    return;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                this.matchX = x;
                this.matchY = y;
                this.wasMirrored = true;
                return;
            }
        }
        this.matchY = -1;
        this.matchX = -1;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        int[] amounts = this.getAmounts(mirror);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack slot;
                int subX = x - startX;
                int subY = y - startY;
                int damage = 0;
                Ingredient target = Ingredient.field_193370_a;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    damage = amounts[subX + this.width * subY];
                    target = mirror ? (Ingredient)this.input.get(this.width - subX - 1 + subY * this.width) : (Ingredient)this.input.get(subX + subY * this.width);
                }
                if (target.apply(slot = inv.func_70463_b(x, y)) && damage <= slot.func_77958_k() - slot.func_77952_i() + 1) continue;
                return false;
            }
        }
        return true;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            HashMap ingMap = Maps.newHashMap();
            for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
            }
            ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
            JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
            if (patternJ.size() == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            String[] pattern = new String[patternJ.size()];
            for (int x = 0; x < pattern.length; ++x) {
                String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
                if (x > 0 && pattern[0].length() != line.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
                }
                pattern[x] = line;
            }
            CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
            primer.width = pattern[0].length();
            primer.height = pattern.length;
            primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
            primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
            HashSet keys = Sets.newHashSet(ingMap.keySet());
            keys.remove(Character.valueOf(' '));
            int x = 0;
            for (String line : pattern) {
                for (char chr : line.toCharArray()) {
                    Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                    if (ing == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                    }
                    primer.input.set(x++, (Object)ing);
                    keys.remove(Character.valueOf(chr));
                }
            }
            if (!keys.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            HashMap damageMap = Maps.newHashMap();
            for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"damage").entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                if (!((JsonElement)entry.getValue()).isJsonPrimitive() || !((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                    throw new JsonSyntaxException("Invalid key value: '" + entry.getValue() + "' is not a number.");
                }
                damageMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), ((JsonElement)entry.getValue()).getAsInt());
            }
            int[] damageAmounts = ShapedRecipe.createDamageAmounts(primer.width, primer.height, pattern, damageMap);
            return new DamageableShapedOreRecipe(group.isEmpty() ? null : new ResourceLocation(group), damageAmounts, result, primer);
        }
    }
}

