/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import cubex2.cs4.plugins.vanilla.block.EnumSubtype;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class BlockHelper {
    private static final Map<IntArray, PropertyEnum<EnumSubtype>> subtypeProperties = Maps.newHashMap();
    private static final Map<Integer, PropertyInteger> cropAgeProperties = Maps.newHashMap();

    public static PropertyEnum<EnumSubtype> getSubtypeProperty(int[] subtypes) {
        int[] sortedSubtypes = Arrays.stream(subtypes).distinct().sorted().toArray();
        return subtypeProperties.computeIfAbsent(new IntArray(sortedSubtypes), BlockHelper::createSubtypeProperty);
    }

    private static PropertyEnum<EnumSubtype> createSubtypeProperty(IntArray subtypes) {
        return PropertyEnum.func_177707_a((String)"subtype", EnumSubtype.class, EnumSubtype.getValues(subtypes.array));
    }

    @Nonnull
    public static PropertyInteger getCropAgeProperty(int maxAge) {
        Preconditions.checkArgument((maxAge >= 0 && maxAge <= 15 ? 1 : 0) != 0, (Object)("Invalid maxAge : " + maxAge));
        return cropAgeProperties.computeIfAbsent(maxAge, BlockHelper::createCropAgeProperty);
    }

    private static PropertyInteger createCropAgeProperty(int maxAge) {
        return PropertyInteger.func_177719_a((String)"age", (int)0, (int)maxAge);
    }

    public static EnumFacing getVerticalFacingFromEntity(BlockPos pos, EntityLivingBase living) {
        double d = living.field_70163_u + (double)living.func_70047_e();
        if (d - (double)pos.func_177956_o() > 2.0) {
            return EnumFacing.UP;
        }
        return EnumFacing.DOWN;
    }

    private static class IntArray {
        private final int[] array;

        private IntArray(int[] array) {
            this.array = array;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntArray intArray = (IntArray)o;
            return Arrays.equals(this.array, intArray.array);
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }
}

