/*
 * Decompiled with CFR 0.152.
 */
package openmods.network;

import com.google.common.collect.ImmutableList;
import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import openmods.network.senders.FmlPacketSenderFactory;
import openmods.network.senders.IPacketSender;
import openmods.network.senders.ITargetedPacketSender;

public abstract class Dispatcher {
    protected abstract EmbeddedChannel getChannel(Side var1);

    protected EmbeddedChannel serverChannel() {
        return this.getChannel(Side.SERVER);
    }

    protected EmbeddedChannel clientChannel() {
        return this.getChannel(Side.CLIENT);
    }

    public class Senders {
        public final IPacketSender client;
        public final IPacketSender global;
        public final IPacketSender nowhere;
        public final ITargetedPacketSender<EntityPlayer> player;
        public final ITargetedPacketSender<Integer> dimension;
        public final ITargetedPacketSender<NetworkRegistry.TargetPoint> point;
        public final ITargetedPacketSender<NetworkRegistry.TargetPoint> block;
        public final ITargetedPacketSender<Entity> entity;

        public Senders() {
            this.client = FmlPacketSenderFactory.createSender((Channel)Dispatcher.this.clientChannel(), FMLOutboundHandler.OutboundTarget.TOSERVER);
            this.global = FmlPacketSenderFactory.createSender((Channel)Dispatcher.this.serverChannel(), FMLOutboundHandler.OutboundTarget.ALL);
            this.nowhere = FmlPacketSenderFactory.createSender((Channel)Dispatcher.this.serverChannel(), FMLOutboundHandler.OutboundTarget.NOWHERE);
            this.player = FmlPacketSenderFactory.createPlayerSender((Channel)Dispatcher.this.serverChannel());
            this.dimension = FmlPacketSenderFactory.createDimensionSender((Channel)Dispatcher.this.serverChannel());
            this.point = FmlPacketSenderFactory.createPointSender((Channel)Dispatcher.this.serverChannel());
            this.block = FmlPacketSenderFactory.createBlockTrackersSender((Channel)Dispatcher.this.serverChannel());
            this.entity = FmlPacketSenderFactory.createEntityTrackersSender((Channel)Dispatcher.this.serverChannel());
        }

        public List<Object> serialize(Object msg) {
            Object packet;
            this.nowhere.sendMessage(msg);
            ImmutableList.Builder result = ImmutableList.builder();
            while ((packet = Dispatcher.this.serverChannel().outboundMessages().poll()) != null) {
                result.add(packet);
            }
            return result.build();
        }
    }
}

