/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.TileNetworkList;
import mekanism.common.inventory.container.ContainerSecurityDesk;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSecurityDesk
extends GuiMekanism {
    public static int MAX_LENGTH = 24;
    public ResourceLocation resource;
    public TileEntitySecurityDesk tileEntity;
    public EntityPlayer entityPlayer;
    public GuiButton removeButton;
    public GuiScrollList scrollList;
    public GuiTextField trustedField;
    public static final List<Character> SPECIAL_CHARS = Arrays.asList(Character.valueOf('-'), Character.valueOf('|'), Character.valueOf('_'));

    public GuiSecurityDesk(InventoryPlayer inventory, TileEntitySecurityDesk tentity) {
        super(tentity, new ContainerSecurityDesk(inventory, tentity));
        this.tileEntity = tentity;
        this.resource = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiSecurityDesk.png");
        this.scrollList = new GuiScrollList(this, this.resource, 14, 14, 120, 4);
        this.guiElements.add(this.scrollList);
        this.field_147000_g += 64;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.removeButton = new GuiButton(0, guiWidth + 13, guiHeight + 81, 122, 20, LangUtils.localize("gui.remove"));
        this.trustedField = new GuiTextField(1, this.field_146289_q, guiWidth + 35, guiHeight + 69, 86, 11);
        this.trustedField.func_146203_f(MAX_LENGTH);
        this.trustedField.func_146185_a(false);
        this.updateButtons();
        this.field_146292_n.add(this.removeButton);
    }

    public void addTrusted(String trusted) {
        if (trusted.isEmpty()) {
            return;
        }
        TileNetworkList data = TileNetworkList.withContents(0, trusted);
        Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
    }

    public void updateButtons() {
        if (this.tileEntity.clientOwner == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.tileEntity.frequency != null) {
            for (String s : this.tileEntity.frequency.trusted) {
                text.add(s);
            }
        }
        this.scrollList.setText(text);
        this.removeButton.field_146124_l = this.scrollList.hasSelection();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
        this.trustedField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.updateButtons();
        this.trustedField.func_146192_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (this.tileEntity.frequency != null && this.tileEntity.ownerUUID != null && this.tileEntity.clientOwner.equals(this.field_146297_k.field_71439_g.func_70005_c_())) {
                if (xAxis >= 123 && xAxis <= 134 && yAxis >= 68 && yAxis <= 79) {
                    this.addTrusted(this.trustedField.func_146179_b());
                    this.trustedField.func_146180_a("");
                    SoundHandler.playSound(SoundEvents.field_187909_gi);
                }
                TileNetworkList data = new TileNetworkList();
                if (xAxis >= 146 && xAxis <= 162 && yAxis >= 59 && yAxis <= 75) {
                    data.add(2);
                }
                if (this.tileEntity.frequency.securityMode != ISecurityTile.SecurityMode.PUBLIC && xAxis >= 13 && xAxis <= 53 && yAxis >= 113 && yAxis <= 129) {
                    data.add(3);
                    data.add(0);
                }
                if (this.tileEntity.frequency.securityMode != ISecurityTile.SecurityMode.PRIVATE && xAxis >= 54 && xAxis <= 94 && yAxis >= 113 && yAxis <= 129) {
                    data.add(3);
                    data.add(1);
                }
                if (this.tileEntity.frequency.securityMode != ISecurityTile.SecurityMode.TRUSTED && xAxis >= 95 && xAxis <= 135 && yAxis >= 113 && yAxis <= 129) {
                    data.add(3);
                    data.add(2);
                }
                if (!data.isEmpty()) {
                    Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                }
            }
        }
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.trustedField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28 && this.trustedField.func_146206_l()) {
            this.addTrusted(this.trustedField.func_146179_b());
            this.trustedField.func_146180_a("");
        }
        if (SPECIAL_CHARS.contains(Character.valueOf(c)) || Character.isDigit(c) || Character.isLetter(c) || GuiSecurityDesk.isTextboxKey(c, i)) {
            this.trustedField.func_146201_a(c, i);
        }
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            int selection = this.scrollList.getSelection();
            if (this.tileEntity.frequency != null && selection != -1) {
                if (this.tileEntity != null) {
                    TileNetworkList data = TileNetworkList.withContents(1, this.tileEntity.frequency.trusted.get(selection));
                    Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                }
                this.scrollList.selected = -1;
            }
        }
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        String ownerText = (Object)((Object)EnumColor.RED) + this.tileEntity.clientOwner != null ? LangUtils.localize("gui.owner") + ": " + this.tileEntity.clientOwner : LangUtils.localize("gui.noOwner");
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.tileEntity.func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(ownerText, this.field_146999_f - 7 - this.field_146289_q.func_78256_a(ownerText), this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        String trusted = LangUtils.localize("gui.trustedPlayers");
        this.field_146289_q.func_78276_b(trusted, 74 - this.field_146289_q.func_78256_a(trusted) / 2, 57, 0x787878);
        String security = (Object)((Object)EnumColor.RED) + LangUtils.localize("gui.securityOffline");
        if (this.tileEntity.frequency != null) {
            security = LangUtils.localize("gui.security") + ": " + this.tileEntity.frequency.securityMode.getDisplay();
        }
        this.field_146289_q.func_78276_b(security, 13, 103, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.add") + ":", 13, 70, 0x404040, 20);
        if (this.tileEntity.frequency != null && xAxis >= 146 && xAxis <= 162 && yAxis >= 59 && yAxis <= 75) {
            this.displayTooltip(LangUtils.localize("gui.securityOverride") + ": " + LangUtils.transOnOff(this.tileEntity.frequency.override), xAxis, yAxis);
        }
        if (xAxis >= 13 && xAxis <= 53 && yAxis >= 113 && yAxis <= 129) {
            this.displayTooltip(LangUtils.localize("gui.publicMode"), xAxis, yAxis);
        }
        if (xAxis >= 54 && xAxis <= 94 && yAxis >= 113 && yAxis <= 129) {
            this.displayTooltip(LangUtils.localize("gui.privateMode"), xAxis, yAxis);
        }
        if (xAxis >= 95 && xAxis <= 135 && yAxis >= 113 && yAxis <= 129) {
            this.displayTooltip(LangUtils.localize("gui.trustedMode"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.resource);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (this.tileEntity.frequency != null && this.tileEntity.clientOwner != null && this.field_146297_k.field_71439_g.func_70005_c_().equals(this.tileEntity.clientOwner)) {
            this.func_73729_b(guiWidth + 145, guiHeight + 78, this.field_146999_f + (this.tileEntity.frequency.override ? 0 : 6), 22, 6, 6);
            if (xAxis >= 146 && xAxis <= 162 && yAxis >= 59 && yAxis <= 75) {
                this.func_73729_b(guiWidth + 146, guiHeight + 59, this.field_146999_f + 12, 0, 16, 16);
            } else {
                this.func_73729_b(guiWidth + 146, guiHeight + 59, this.field_146999_f + 12, 16, 16, 16);
            }
            if (this.tileEntity.frequency.securityMode != ISecurityTile.SecurityMode.PUBLIC) {
                if (xAxis >= 13 && xAxis <= 53 && yAxis >= 113 && yAxis <= 129) {
                    this.func_73729_b(guiWidth + 13, guiHeight + 113, this.field_146999_f, 48, 40, 16);
                } else {
                    this.func_73729_b(guiWidth + 13, guiHeight + 113, this.field_146999_f, 64, 40, 16);
                }
            } else {
                this.func_73729_b(guiWidth + 13, guiHeight + 113, this.field_146999_f, 80, 40, 16);
            }
            if (this.tileEntity.frequency.securityMode != ISecurityTile.SecurityMode.PRIVATE) {
                if (xAxis >= 54 && xAxis <= 94 && yAxis >= 113 && yAxis <= 129) {
                    this.func_73729_b(guiWidth + 54, guiHeight + 113, this.field_146999_f + 40, 48, 40, 16);
                } else {
                    this.func_73729_b(guiWidth + 54, guiHeight + 113, this.field_146999_f + 40, 64, 40, 16);
                }
            } else {
                this.func_73729_b(guiWidth + 54, guiHeight + 113, this.field_146999_f + 40, 80, 40, 16);
            }
            if (this.tileEntity.frequency.securityMode != ISecurityTile.SecurityMode.TRUSTED) {
                if (xAxis >= 95 && xAxis <= 135 && yAxis >= 113 && yAxis <= 129) {
                    this.func_73729_b(guiWidth + 95, guiHeight + 113, this.field_146999_f, 96, 40, 16);
                } else {
                    this.func_73729_b(guiWidth + 95, guiHeight + 113, this.field_146999_f, 112, 40, 16);
                }
            } else {
                this.func_73729_b(guiWidth + 95, guiHeight + 113, this.field_146999_f, 128, 40, 16);
            }
        } else {
            this.func_73729_b(guiWidth + 145, guiHeight + 78, this.field_146999_f, 28, 6, 6);
            this.func_73729_b(guiWidth + 146, guiHeight + 59, this.field_146999_f + 12, 32, 16, 16);
            this.func_73729_b(guiWidth + 13, guiHeight + 113, this.field_146999_f, 80, 40, 16);
            this.func_73729_b(guiWidth + 54, guiHeight + 113, this.field_146999_f + 40, 80, 40, 16);
            this.func_73729_b(guiWidth + 95, guiHeight + 113, this.field_146999_f, 128, 40, 16);
        }
        if (xAxis >= 123 && xAxis <= 134 && yAxis >= 68 && yAxis <= 79) {
            this.func_73729_b(guiWidth + 123, guiHeight + 68, this.field_146999_f, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 123, guiHeight + 68, this.field_146999_f, 11, 11, 11);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.trustedField.func_146194_f();
    }
}

