/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiChemicalCrystallizer;
import mekanism.client.gui.GuiChemicalDissolutionChamber;
import mekanism.client.gui.GuiChemicalInfuser;
import mekanism.client.gui.GuiChemicalInjectionChamber;
import mekanism.client.gui.GuiChemicalOxidizer;
import mekanism.client.gui.GuiChemicalWasher;
import mekanism.client.gui.GuiCombiner;
import mekanism.client.gui.GuiCrusher;
import mekanism.client.gui.GuiElectrolyticSeparator;
import mekanism.client.gui.GuiEnergizedSmelter;
import mekanism.client.gui.GuiEnrichmentChamber;
import mekanism.client.gui.GuiMetallurgicInfuser;
import mekanism.client.gui.GuiOsmiumCompressor;
import mekanism.client.gui.GuiPRC;
import mekanism.client.gui.GuiPrecisionSawmill;
import mekanism.client.gui.GuiPurificationChamber;
import mekanism.client.gui.GuiRotaryCondensentrator;
import mekanism.client.gui.GuiSolarNeutronActivator;
import mekanism.client.gui.GuiThermalEvaporationController;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.jei.GasStackHelper;
import mekanism.client.jei.GuiElementHandler;
import mekanism.client.jei.gas.GasStackRenderer;
import mekanism.client.jei.machine.AdvancedMachineRecipeCategory;
import mekanism.client.jei.machine.ChanceMachineRecipeCategory;
import mekanism.client.jei.machine.DoubleMachineRecipeCategory;
import mekanism.client.jei.machine.MachineRecipeCategory;
import mekanism.client.jei.machine.advanced.ChemicalInjectionChamberRecipeWrapper;
import mekanism.client.jei.machine.advanced.CombinerRecipeWrapper;
import mekanism.client.jei.machine.advanced.OsmiumCompressorRecipeWrapper;
import mekanism.client.jei.machine.advanced.PurificationChamberRecipeWrapper;
import mekanism.client.jei.machine.basic.CrusherRecipeWrapper;
import mekanism.client.jei.machine.basic.EnrichmentRecipeWrapper;
import mekanism.client.jei.machine.basic.SmeltingRecipeWrapper;
import mekanism.client.jei.machine.chance.PrecisionSawmillRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalCrystallizerRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalCrystallizerRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalDissolutionChamberRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalDissolutionChamberRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalInfuserRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalInfuserRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalOxidizerRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalOxidizerRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalWasherRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalWasherRecipeWrapper;
import mekanism.client.jei.machine.other.ElectrolyticSeparatorRecipeCategory;
import mekanism.client.jei.machine.other.ElectrolyticSeparatorRecipeWrapper;
import mekanism.client.jei.machine.other.MetallurgicInfuserRecipeCategory;
import mekanism.client.jei.machine.other.MetallurgicInfuserRecipeWrapper;
import mekanism.client.jei.machine.other.PRCRecipeCategory;
import mekanism.client.jei.machine.other.PRCRecipeWrapper;
import mekanism.client.jei.machine.other.RotaryCondensentratorRecipeCategory;
import mekanism.client.jei.machine.other.RotaryCondensentratorRecipeWrapper;
import mekanism.client.jei.machine.other.SolarNeutronRecipeCategory;
import mekanism.client.jei.machine.other.SolarNeutronRecipeWrapper;
import mekanism.client.jei.machine.other.ThermalEvaporationRecipeCategory;
import mekanism.client.jei.machine.other.ThermalEvaporationRecipeWrapper;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.Tier;
import mekanism.common.base.IFactory;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.integration.crafttweaker.handlers.EnergizedSmelter;
import mekanism.common.inventory.container.ContainerFormulaicAssemblicator;
import mekanism.common.inventory.container.ContainerRobitInventory;
import mekanism.common.item.ItemBlockEnergyCube;
import mekanism.common.item.ItemBlockGasTank;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.machines.CombinerRecipe;
import mekanism.common.recipe.machines.CrusherRecipe;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.EnrichmentRecipe;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.machines.OsmiumCompressorRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.PurificationRecipe;
import mekanism.common.recipe.machines.SawmillRecipe;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.machines.SmeltingRecipe;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.util.MekanismUtils;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.Loader;

@JEIPlugin
public class MekanismJEI
implements IModPlugin {
    private static final GasStackRenderer GAS_RENDERER = new GasStackRenderer();
    private static final boolean CRAFTTWEAKER_LOADED = Loader.isModLoaded((String)"crafttweaker");
    public static final ISubtypeRegistry.ISubtypeInterpreter NBT_INTERPRETER = itemStack -> {
        GasStack gasStack;
        String ret = Integer.toString(itemStack.func_77960_j());
        if (itemStack.func_77973_b() instanceof ITierItem) {
            ret = ret + ":" + ((ITierItem)itemStack.func_77973_b()).getBaseTier(itemStack).getSimpleName();
        }
        if (itemStack.func_77973_b() instanceof IFactory) {
            ret = ret + ":" + IFactory.RecipeType.values()[((IFactory)itemStack.func_77973_b()).getRecipeType(itemStack)].func_176610_l();
        }
        if (itemStack.func_77973_b() instanceof ItemBlockGasTank && (gasStack = ((ItemBlockGasTank)itemStack.func_77973_b()).getGas(itemStack)) != null) {
            ret = ret + ":" + gasStack.getGas().getName();
        }
        if (itemStack.func_77973_b() instanceof ItemBlockEnergyCube) {
            ret = ret + ":" + (((ItemBlockEnergyCube)itemStack.func_77973_b()).getEnergy(itemStack) > 0.0 ? "filled" : "empty");
        }
        return ret.isEmpty() ? null : ret.toLowerCase(Locale.ROOT);
    };

    public void registerItemSubtypes(ISubtypeRegistry registry) {
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.EnergyCube), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock2), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock3), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.BasicBlock), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.BasicBlock2), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.GasTank), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.CardboardBox), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.Transmitter), NBT_INTERPRETER);
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        List list = GasRegistry.getRegisteredGasses().stream().filter(Gas::isVisible).map(g -> new GasStack((Gas)g, 1000)).collect(Collectors.toList());
        registry.register(GasStack.class, list, (IIngredientHelper)new GasStackHelper(), (IIngredientRenderer)GAS_RENDERER);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        ChemicalCrystallizerRecipeCategory chemicalCrystallizerCategory = new ChemicalCrystallizerRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        ChemicalDissolutionChamberRecipeCategory chemicalDissolutionChamberCategory = new ChemicalDissolutionChamberRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        ChemicalInfuserRecipeCategory chemicalInfuserCategory = new ChemicalInfuserRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        ChemicalOxidizerRecipeCategory chemicalOxidizerCategory = new ChemicalOxidizerRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        ChemicalWasherRecipeCategory chemicalWasherCategory = new ChemicalWasherRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        ElectrolyticSeparatorRecipeCategory electrolyticSeparatorCategory = new ElectrolyticSeparatorRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        MetallurgicInfuserRecipeCategory metallurgicInfuserCategory = new MetallurgicInfuserRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        PRCRecipeCategory prcCategory = new PRCRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        RotaryCondensentratorRecipeCategory rotaryCondensentratorCondensentratingCategory = new RotaryCondensentratorRecipeCategory(registry.getJeiHelpers().getGuiHelper(), true);
        RotaryCondensentratorRecipeCategory rotaryCondensentratorDecondensentratingCategory = new RotaryCondensentratorRecipeCategory(registry.getJeiHelpers().getGuiHelper(), false);
        SolarNeutronRecipeCategory solarNeutronCategory = new SolarNeutronRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        ThermalEvaporationRecipeCategory thermalEvaporationCategory = new ThermalEvaporationRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        DoubleMachineRecipeCategory doubleMachineRecipeCategoryCombiner = new DoubleMachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), RecipeHandler.Recipe.COMBINER.name().toLowerCase(Locale.ROOT), "tile.MachineBlock.Combiner.name", GuiProgress.ProgressBar.STONE);
        AdvancedMachineRecipeCategory advancedMachineRecipeCategoryPurificationChamber = new AdvancedMachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), RecipeHandler.Recipe.PURIFICATION_CHAMBER.name().toLowerCase(Locale.ROOT), "tile.MachineBlock.PurificationChamber.name", GuiProgress.ProgressBar.RED);
        AdvancedMachineRecipeCategory advancedMachineRecipeCategoryOsmiumCompressor = new AdvancedMachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), RecipeHandler.Recipe.OSMIUM_COMPRESSOR.name().toLowerCase(Locale.ROOT), "tile.MachineBlock.OsmiumCompressor.name", GuiProgress.ProgressBar.RED);
        AdvancedMachineRecipeCategory advancedMachineRecipeCategoryChemicalInjectionChamber = new AdvancedMachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.name().toLowerCase(Locale.ROOT), "nei.chemicalInjectionChamber", GuiProgress.ProgressBar.YELLOW);
        ChanceMachineRecipeCategory chanceMachineRecipeCategoryPrecisionSawmill = new ChanceMachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), RecipeHandler.Recipe.PRECISION_SAWMILL.name().toLowerCase(Locale.ROOT), "tile.MachineBlock2.PrecisionSawmill.name", GuiProgress.ProgressBar.PURPLE);
        MachineRecipeCategory machineRecipeCategoryEnrichment = new MachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), RecipeHandler.Recipe.ENRICHMENT_CHAMBER.name().toLowerCase(Locale.ROOT), "tile.MachineBlock.EnrichmentChamber.name", GuiProgress.ProgressBar.BLUE);
        MachineRecipeCategory machineRecipeCategoryCrusher = new MachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), RecipeHandler.Recipe.CRUSHER.name().toLowerCase(Locale.ROOT), "tile.MachineBlock.Crusher.name", GuiProgress.ProgressBar.CRUSH);
        MachineRecipeCategory machineRecipeCategoryEnergizedSmelter = new MachineRecipeCategory(registry.getJeiHelpers().getGuiHelper(), RecipeHandler.Recipe.ENERGIZED_SMELTER.name().toLowerCase(Locale.ROOT), "tile.MachineBlock.EnergizedSmelter.name", GuiProgress.ProgressBar.BLUE);
        registry.addRecipeCategories(new IRecipeCategory[]{chemicalCrystallizerCategory, chemicalDissolutionChamberCategory, chemicalInfuserCategory, chemicalOxidizerCategory, chemicalWasherCategory, electrolyticSeparatorCategory, metallurgicInfuserCategory, prcCategory, rotaryCondensentratorCondensentratingCategory, rotaryCondensentratorDecondensentratingCategory, solarNeutronCategory, thermalEvaporationCategory, doubleMachineRecipeCategoryCombiner, advancedMachineRecipeCategoryPurificationChamber, advancedMachineRecipeCategoryOsmiumCompressor, advancedMachineRecipeCategoryChemicalInjectionChamber, chanceMachineRecipeCategoryPrecisionSawmill, machineRecipeCategoryEnrichment, machineRecipeCategoryCrusher, machineRecipeCategoryEnergizedSmelter});
    }

    public void register(IModRegistry registry) {
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new GuiElementHandler()});
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(MekanismItems.ItemProxy));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(MekanismBlocks.BoundingBlock));
        registry.handleRecipes(EnrichmentRecipe.class, EnrichmentRecipeWrapper::new, "mekanism.enrichment_chamber");
        this.addRecipes(registry, RecipeHandler.Recipe.ENRICHMENT_CHAMBER, BasicMachineRecipe.class, EnrichmentRecipeWrapper.class, "mekanism.enrichment_chamber");
        registry.handleRecipes(CrusherRecipe.class, CrusherRecipeWrapper::new, "mekanism.crusher");
        this.addRecipes(registry, RecipeHandler.Recipe.CRUSHER, BasicMachineRecipe.class, CrusherRecipeWrapper.class, "mekanism.crusher");
        registry.handleRecipes(CombinerRecipe.class, CombinerRecipeWrapper::new, "mekanism.combiner");
        this.addRecipes(registry, RecipeHandler.Recipe.COMBINER, DoubleMachineRecipe.class, CombinerRecipeWrapper.class, "mekanism.combiner");
        registry.handleRecipes(PurificationRecipe.class, PurificationChamberRecipeWrapper::new, "mekanism.purification_chamber");
        this.addRecipes(registry, RecipeHandler.Recipe.PURIFICATION_CHAMBER, AdvancedMachineRecipe.class, PurificationChamberRecipeWrapper.class, "mekanism.purification_chamber");
        registry.handleRecipes(OsmiumCompressorRecipe.class, OsmiumCompressorRecipeWrapper::new, "mekanism.osmium_compressor");
        this.addRecipes(registry, RecipeHandler.Recipe.OSMIUM_COMPRESSOR, AdvancedMachineRecipe.class, OsmiumCompressorRecipeWrapper.class, "mekanism.osmium_compressor");
        registry.handleRecipes(InjectionRecipe.class, ChemicalInjectionChamberRecipeWrapper::new, "mekanism.chemical_injection_chamber");
        this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER, AdvancedMachineRecipe.class, ChemicalInjectionChamberRecipeWrapper.class, "mekanism.chemical_injection_chamber");
        registry.handleRecipes(SawmillRecipe.class, PrecisionSawmillRecipeWrapper::new, "mekanism.precision_sawmill");
        this.addRecipes(registry, RecipeHandler.Recipe.PRECISION_SAWMILL, ChanceMachineRecipe.class, PrecisionSawmillRecipeWrapper.class, "mekanism.precision_sawmill");
        registry.handleRecipes(MetallurgicInfuserRecipe.class, MetallurgicInfuserRecipeWrapper::new, "mekanism.metallurgic_infuser");
        this.addRecipes(registry, RecipeHandler.Recipe.METALLURGIC_INFUSER, MetallurgicInfuserRecipe.class, MetallurgicInfuserRecipeWrapper.class, "mekanism.metallurgic_infuser");
        registry.handleRecipes(CrystallizerRecipe.class, ChemicalCrystallizerRecipeWrapper::new, "mekanism.chemical_crystallizer");
        this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER, CrystallizerRecipe.class, ChemicalCrystallizerRecipeWrapper.class, "mekanism.chemical_crystallizer");
        registry.handleRecipes(DissolutionRecipe.class, ChemicalDissolutionChamberRecipeWrapper::new, "mekanism.chemical_dissolution_chamber");
        this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER, DissolutionRecipe.class, ChemicalDissolutionChamberRecipeWrapper.class, "mekanism.chemical_dissolution_chamber");
        registry.handleRecipes(ChemicalInfuserRecipe.class, ChemicalInfuserRecipeWrapper::new, "mekanism.chemical_infuser");
        this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_INFUSER, ChemicalInfuserRecipe.class, ChemicalInfuserRecipeWrapper.class, "mekanism.chemical_infuser");
        registry.handleRecipes(OxidationRecipe.class, ChemicalOxidizerRecipeWrapper::new, "mekanism.chemical_oxidizer");
        this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_OXIDIZER, OxidationRecipe.class, ChemicalOxidizerRecipeWrapper.class, "mekanism.chemical_oxidizer");
        registry.handleRecipes(WasherRecipe.class, ChemicalWasherRecipeWrapper::new, "mekanism.chemical_washer");
        this.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_WASHER, WasherRecipe.class, ChemicalWasherRecipeWrapper.class, "mekanism.chemical_washer");
        registry.handleRecipes(SolarNeutronRecipe.class, SolarNeutronRecipeWrapper::new, "mekanism.solar_neutron_activator");
        this.addRecipes(registry, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR, SolarNeutronRecipe.class, SolarNeutronRecipeWrapper.class, "mekanism.solar_neutron_activator");
        registry.handleRecipes(SeparatorRecipe.class, ElectrolyticSeparatorRecipeWrapper::new, "mekanism.electrolytic_separator");
        this.addRecipes(registry, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR, SeparatorRecipe.class, ElectrolyticSeparatorRecipeWrapper.class, "mekanism.electrolytic_separator");
        registry.handleRecipes(ThermalEvaporationRecipe.class, ThermalEvaporationRecipeWrapper::new, "mekanism.thermal_evaporation_plant");
        this.addRecipes(registry, RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT, ThermalEvaporationRecipe.class, ThermalEvaporationRecipeWrapper.class, "mekanism.thermal_evaporation_plant");
        registry.handleRecipes(PressurizedRecipe.class, PRCRecipeWrapper::new, "mekanism.pressurized_reaction_chamber");
        this.addRecipes(registry, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER, PressurizedRecipe.class, PRCRecipeWrapper.class, "mekanism.pressurized_reaction_chamber");
        ArrayList<RotaryCondensentratorRecipeWrapper> condensentratorRecipes = new ArrayList<RotaryCondensentratorRecipeWrapper>();
        ArrayList<RotaryCondensentratorRecipeWrapper> decondensentratorRecipes = new ArrayList<RotaryCondensentratorRecipeWrapper>();
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            if (!gas.hasFluid()) continue;
            condensentratorRecipes.add(new RotaryCondensentratorRecipeWrapper(gas.getFluid(), gas, true));
            decondensentratorRecipes.add(new RotaryCondensentratorRecipeWrapper(gas.getFluid(), gas, false));
        }
        registry.addRecipes(condensentratorRecipes, "mekanism.rotary_condensentrator_condensentrating");
        registry.addRecipes(decondensentratorRecipes, "mekanism.rotary_condensentrator_decondensentrating");
        registry.handleRecipes(SmeltingRecipe.class, SmeltingRecipeWrapper::new, "mekanism.energized_smelter");
        if (CRAFTTWEAKER_LOADED && EnergizedSmelter.hasRemovedRecipe()) {
            this.addRecipes(registry, RecipeHandler.Recipe.ENERGIZED_SMELTER, BasicMachineRecipe.class, SmeltingRecipeWrapper.class, "mekanism.energized_smelter");
        } else if (CRAFTTWEAKER_LOADED && EnergizedSmelter.hasAddedRecipe()) {
            HashMap smeltingRecipes = RecipeHandler.Recipe.ENERGIZED_SMELTER.get();
            Collection<SmeltingRecipe> recipes = smeltingRecipes.entrySet().stream().filter(entry -> !FurnaceRecipes.func_77602_a().func_77599_b().keySet().contains(((ItemStackInput)entry.getKey()).ingredient)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).values();
            this.addRecipes(registry, recipes, BasicMachineRecipe.class, SmeltingRecipeWrapper.class, "mekanism.energized_smelter");
        }
        registry.addRecipeClickArea(GuiEnrichmentChamber.class, 79, 40, 24, 7, new String[]{"mekanism.enrichment_chamber"});
        registry.addRecipeClickArea(GuiCrusher.class, 79, 40, 24, 7, new String[]{"mekanism.crusher"});
        registry.addRecipeClickArea(GuiCombiner.class, 79, 40, 24, 7, new String[]{"mekanism.combiner"});
        registry.addRecipeClickArea(GuiPurificationChamber.class, 79, 40, 24, 7, new String[]{"mekanism.purification_chamber"});
        registry.addRecipeClickArea(GuiOsmiumCompressor.class, 79, 40, 24, 7, new String[]{"mekanism.osmium_compressor"});
        registry.addRecipeClickArea(GuiChemicalInjectionChamber.class, 79, 40, 24, 7, new String[]{"mekanism.chemical_injection_chamber"});
        registry.addRecipeClickArea(GuiPrecisionSawmill.class, 79, 40, 24, 7, new String[]{"mekanism.precision_sawmill"});
        registry.addRecipeClickArea(GuiMetallurgicInfuser.class, 72, 47, 32, 8, new String[]{"mekanism.metallurgic_infuser"});
        registry.addRecipeClickArea(GuiChemicalCrystallizer.class, 53, 62, 48, 8, new String[]{"mekanism.chemical_crystallizer"});
        registry.addRecipeClickArea(GuiChemicalDissolutionChamber.class, 64, 40, 48, 8, new String[]{"mekanism.chemical_dissolution_chamber"});
        registry.addRecipeClickArea(GuiChemicalInfuser.class, 47, 39, 28, 8, new String[]{"mekanism.chemical_infuser"});
        registry.addRecipeClickArea(GuiChemicalInfuser.class, 101, 39, 28, 8, new String[]{"mekanism.chemical_infuser"});
        registry.addRecipeClickArea(GuiChemicalOxidizer.class, 64, 40, 48, 8, new String[]{"mekanism.chemical_oxidizer"});
        registry.addRecipeClickArea(GuiChemicalWasher.class, 61, 39, 55, 8, new String[]{"mekanism.chemical_washer"});
        registry.addRecipeClickArea(GuiSolarNeutronActivator.class, 64, 39, 48, 8, new String[]{"mekanism.solar_neutron_activator"});
        registry.addRecipeClickArea(GuiElectrolyticSeparator.class, 80, 30, 16, 6, new String[]{"mekanism.electrolytic_separator"});
        registry.addRecipeClickArea(GuiThermalEvaporationController.class, 49, 20, 78, 38, new String[]{"mekanism.thermal_evaporation_plant"});
        registry.addRecipeClickArea(GuiPRC.class, 75, 37, 36, 10, new String[]{"mekanism.pressurized_reaction_chamber"});
        registry.addRecipeClickArea(GuiRotaryCondensentrator.class, 64, 39, 48, 8, new String[]{"mekanism.rotary_condensentrator_condensentrating", "mekanism.rotary_condensentrator_decondensentrating"});
        if (CRAFTTWEAKER_LOADED && EnergizedSmelter.hasRemovedRecipe()) {
            registry.addRecipeClickArea(GuiEnergizedSmelter.class, 79, 40, 24, 7, new String[]{"mekanism.energized_smelter"});
        } else if (CRAFTTWEAKER_LOADED && EnergizedSmelter.hasAddedRecipe()) {
            registry.addRecipeClickArea(GuiEnergizedSmelter.class, 79, 40, 24, 7, new String[]{"minecraft.smelting", "mekanism.energized_smelter"});
        } else {
            registry.addRecipeClickArea(GuiEnergizedSmelter.class, 79, 40, 24, 7, new String[]{"minecraft.smelting"});
        }
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.ENRICHMENT_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CRUSHER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.ENERGIZED_SMELTER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.COMBINER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.PURIFICATION_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.OSMIUM_COMPRESSOR);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.PRECISION_SAWMILL);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.METALLURGIC_INFUSER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_INFUSER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_OXIDIZER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_WASHER);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR);
        this.registerRecipeItem(registry, BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER);
        registry.addRecipeCatalyst((Object)BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR.getStack(), new String[]{"mekanism.rotary_condensentrator_condensentrating", "mekanism.rotary_condensentrator_decondensentrating"});
        registry.addRecipeCatalyst((Object)BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_CONTROLLER.getStack(1), new String[]{"mekanism.thermal_evaporation_plant"});
        registry.addRecipeCatalyst((Object)BlockStateMachine.MachineType.FORMULAIC_ASSEMBLICATOR.getStack(), new String[]{"minecraft.crafting"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerFormulaicAssemblicator.class, "minecraft.crafting", 20, 9, 35, 36);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerRobitInventory.class, "minecraft.crafting", 1, 9, 10, 36);
    }

    private void registerRecipeItem(IModRegistry registry, BlockStateMachine.MachineType type) {
        String category = "mekanism." + type.func_176610_l();
        registry.addRecipeCatalyst((Object)type.getStack(), new String[]{category});
        IFactory.RecipeType factoryType = null;
        for (IFactory.RecipeType recipeType : IFactory.RecipeType.values()) {
            if (recipeType.getType() != type) continue;
            factoryType = recipeType;
            break;
        }
        if (factoryType != null) {
            for (Enum enum_ : Tier.FactoryTier.values()) {
                if (!((Tier.FactoryTier)enum_).machineType.isEnabled()) continue;
                registry.addRecipeCatalyst((Object)MekanismUtils.getFactory((Tier.FactoryTier)enum_, factoryType), new String[]{category});
            }
        }
    }

    private void addRecipes(IModRegistry registry, RecipeHandler.Recipe type, Class<?> recipe, Class<? extends IRecipeWrapper> wrapper, String recipeCategoryUid) {
        this.addRecipes(registry, type.get().values(), recipe, wrapper, recipeCategoryUid);
    }

    private void addRecipes(IModRegistry registry, Collection recipeList, Class<?> recipe, Class<? extends IRecipeWrapper> wrapper, String recipeCategoryUid) {
        ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
        for (Object obj : recipeList) {
            if (!(obj instanceof MachineRecipe)) continue;
            try {
                recipes.add(wrapper.getConstructor(recipe).newInstance(obj));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Mekanism.logger.fatal("Error registering JEI recipe: " + recipe.getName(), (Throwable)e);
            }
        }
        registry.addRecipes(recipes, recipeCategoryUid);
    }
}

