/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine.other;

import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.machine.other.RotaryCondensentratorRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RotaryCondensentratorRecipeCategory
extends BaseRecipeCategory {
    private final IDrawable background;
    private final boolean condensentrating;
    @Nullable
    private RotaryCondensentratorRecipeWrapper tempRecipe;

    public RotaryCondensentratorRecipeCategory(IGuiHelper helper, boolean condensentrating) {
        super(helper, "mekanism:gui/nei/GuiRotaryCondensentrator.png", condensentrating ? "rotary_condensentrator_condensentrating" : "rotary_condensentrator_decondensentrating", condensentrating ? "gui.condensentrating" : "gui.decondensentrating", null);
        this.xOffset = 3;
        this.yOffset = 12;
        this.background = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), this.xOffset, this.yOffset, 170, 71);
        this.condensentrating = condensentrating;
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        if (this.tempRecipe == null) {
            return;
        }
        if (this.condensentrating) {
            this.drawTexturedRect(64 - this.xOffset, 39 - this.yOffset, 176, 123, 48, 8);
        } else {
            this.drawTexturedRect(64 - this.xOffset, 39 - this.yOffset, 176, 115, 48, 8);
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (!(recipeWrapper instanceof RotaryCondensentratorRecipeWrapper)) {
            return;
        }
        this.tempRecipe = (RotaryCondensentratorRecipeWrapper)recipeWrapper;
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(GasStack.class);
        fluidStacks.init(0, !this.tempRecipe.condensentrating, 134 - this.xOffset, 14 - this.yOffset, 16, 58, 1000, false, this.fluidOverlayLarge);
        if (this.tempRecipe.condensentrating) {
            this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 0, true, 26 - this.xOffset, 14 - this.yOffset, 16, 58, new GasStack(this.tempRecipe.gasType, 1), true);
            fluidStacks.set(0, (List)ingredients.getOutputs(FluidStack.class).get(0));
        } else {
            this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 0, false, 26 - this.xOffset, 14 - this.yOffset, 16, 58, new GasStack(this.tempRecipe.gasType, 1), true);
            fluidStacks.set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        }
    }
}

