/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import java.util.HashMap;
import java.util.Iterator;
import mekanism.api.Coord4D;
import mekanism.client.model.ModelTransporterBox;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.HashList;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.transmitter.TileEntityDiversionTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderLogisticalTransporter
extends RenderTransmitterBase<TileEntityLogisticalTransporter> {
    private ModelTransporterBox modelBox = new ModelTransporterBox();
    private EntityItem entityItem = new EntityItem(null);
    private Render<Entity> renderer = Minecraft.func_71410_x().func_175598_ae().func_78715_a(EntityItem.class);
    private static HashMap<EnumFacing, HashMap<Integer, MekanismRenderer.DisplayInteger>> cachedOverlays = new HashMap();
    private static TextureAtlasSprite gunpowderIcon;
    private static TextureAtlasSprite torchOffIcon;
    private static TextureAtlasSprite torchOnIcon;

    public void render(TileEntityLogisticalTransporter transporter, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (MekanismConfig.client.opaqueTransmitters) {
            return;
        }
        GL11.glPushMatrix();
        this.entityItem.func_174873_u();
        this.entityItem.field_70290_d = 0.0f;
        this.entityItem.func_70107_b((double)transporter.func_174877_v().func_177958_n() + 0.5, (double)transporter.func_174877_v().func_177956_o() + 0.5, (double)transporter.func_174877_v().func_177952_p() + 0.5);
        this.entityItem.field_70170_p = transporter.func_145831_w();
        Iterator iterator = ((HashList)transporter.getTransmitter().transit.clone()).iterator();
        while (iterator.hasNext()) {
            TransporterStack stack = (TransporterStack)iterator.next();
            if (stack == null) continue;
            GL11.glPushMatrix();
            this.entityItem.func_92058_a(stack.itemStack);
            float[] pos = TransporterUtils.getStackPosition(transporter.getTransmitter(), stack, partialTick * (float)transporter.tier.speed);
            GL11.glTranslated((double)(x + (double)pos[0]), (double)(y + (double)pos[1]), (double)(z + (double)pos[2]));
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            this.renderer.func_76986_a((Entity)this.entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
            if (stack.color == null) continue;
            this.func_147499_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "TransporterBox.png"));
            GL11.glPushMatrix();
            MekanismRenderer.glowOn();
            GL11.glDisable((int)2884);
            GL11.glColor4f((float)stack.color.getColor(0), (float)stack.color.getColor(1), (float)stack.color.getColor(2), (float)1.0f);
            GL11.glTranslatef((float)((float)(x + (double)pos[0])), (float)((float)(y + (double)pos[1])), (float)((float)(z + (double)pos[2])));
            this.modelBox.render(0.0625f);
            MekanismRenderer.glowOff();
            GL11.glPopMatrix();
        }
        if (transporter instanceof TileEntityDiversionTransporter) {
            Coord4D obj;
            EntityPlayerSP player = this.mc.field_71439_g;
            World world = this.mc.field_71439_g.field_70170_p;
            ItemStack itemStack = player.field_71071_by.func_70448_g();
            RayTraceResult pos = player.func_174822_a(8.0, 1.0f);
            if (pos != null && !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemConfigurator && (obj = new Coord4D(pos.func_178782_a(), transporter.func_145831_w())).equals(new Coord4D(transporter.func_174877_v(), transporter.func_145831_w()))) {
                int mode = ((TileEntityDiversionTransporter)transporter).modes[pos.field_178784_b.ordinal()];
                this.pushTransporter();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                this.func_147499_a(MekanismRenderer.getBlocksTexture());
                GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                int display = this.getOverlayDisplay((World)world, (EnumFacing)pos.field_178784_b, (int)mode).display;
                GL11.glCallList((int)display);
                this.popTransporter();
            }
        }
        GL11.glPopMatrix();
    }

    private MekanismRenderer.DisplayInteger getOverlayDisplay(World world, EnumFacing side, int mode) {
        if (cachedOverlays.containsKey(side) && cachedOverlays.get(side).containsKey(mode)) {
            return cachedOverlays.get(side).get(mode);
        }
        TextureAtlasSprite icon = null;
        switch (mode) {
            case 0: {
                icon = gunpowderIcon;
                break;
            }
            case 1: {
                icon = torchOnIcon;
                break;
            }
            case 2: {
                icon = torchOffIcon;
            }
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150348_b;
        toReturn.setTexture(icon);
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (cachedOverlays.containsKey(side)) {
            cachedOverlays.get(side).put(mode, display);
        } else {
            HashMap<Integer, MekanismRenderer.DisplayInteger> map = new HashMap<Integer, MekanismRenderer.DisplayInteger>();
            map.put(mode, display);
            cachedOverlays.put(side, map);
        }
        switch (side) {
            case DOWN: {
                toReturn.minY = -0.01;
                toReturn.maxY = 0.0;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case UP: {
                toReturn.minY = 1.0;
                toReturn.maxY = 1.01;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case NORTH: {
                toReturn.minZ = -0.01;
                toReturn.maxZ = 0.0;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case SOUTH: {
                toReturn.minZ = 1.0;
                toReturn.maxZ = 1.01;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = -0.01;
                toReturn.maxX = 0.0;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case EAST: {
                toReturn.minX = 1.0;
                toReturn.maxX = 1.01;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        MekanismRenderer.DisplayInteger.endList();
        return display;
    }

    private void popTransporter() {
        GL11.glPopAttrib();
        MekanismRenderer.glowOff();
        MekanismRenderer.blendOff();
        GL11.glPopMatrix();
    }

    private void pushTransporter() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        MekanismRenderer.glowOn();
        MekanismRenderer.blendOn();
    }

    public static void onStitch(TextureMap map) {
        cachedOverlays.clear();
        gunpowderIcon = map.getTextureExtry("minecraft:items/gunpowder");
        torchOffIcon = map.getTextureExtry("minecraft:blocks/redstone_torch_off");
        torchOnIcon = map.getTextureExtry("minecraft:blocks/redstone_torch_on");
    }
}

