/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mcmultipart.api.multipart.IMultipart;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.ITierItem;
import mekanism.common.base.TileNetworkList;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.integration.multipart.MultipartMekanism;
import mekanism.common.item.ItemBlockMultipartAble;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockTransmitter
extends ItemBlockMultipartAble
implements ITierItem {
    public Block metaBlock;

    public ItemBlockTransmitter(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public int func_77647_b(int i) {
        return i;
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        boolean place = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state);
        if (place) {
            TileEntitySidedPipe tileEntity = (TileEntitySidedPipe)world.func_175625_s(pos);
            tileEntity.setBaseTier(this.getBaseTier(stack));
            if (!world.field_72995_K) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(tileEntity)));
            }
        }
        return place;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            TransmissionType transmission = BlockStateTransmitter.TransmitterType.values()[itemstack.func_77952_i()].getTransmission();
            Tier.BaseTier tier = this.getBaseTier(itemstack);
            if (transmission == TransmissionType.ENERGY) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(Tier.CableTier.get((Tier.BaseTier)tier).cableCapacity) + "/t");
            } else if (transmission == TransmissionType.FLUID) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + Tier.PipeTier.get((Tier.BaseTier)tier).pipeCapacity + "mB/t");
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.pumpRate") + ": " + (Object)((Object)EnumColor.GREY) + Tier.PipeTier.get((Tier.BaseTier)tier).pipePullAmount + "mB/t");
            } else if (transmission == TransmissionType.GAS) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + Tier.TubeTier.get((Tier.BaseTier)tier).tubeCapacity + "mB/t");
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.pumpRate") + ": " + (Object)((Object)EnumColor.GREY) + Tier.TubeTier.get((Tier.BaseTier)tier).tubePullAmount + "mB/t");
            } else if (transmission == TransmissionType.ITEM) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.speed") + ": " + (Object)((Object)EnumColor.GREY) + Tier.TransporterTier.get((Tier.BaseTier)tier).speed / 5 + " m/s");
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.pumpRate") + ": " + (Object)((Object)EnumColor.GREY) + Tier.TransporterTier.get((Tier.BaseTier)tier).pullAmount * 2 + "/s");
            } else if (transmission == TransmissionType.HEAT) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.conduction") + ": " + (Object)((Object)EnumColor.GREY) + Tier.ConductorTier.get((Tier.BaseTier)tier).inverseConduction);
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.insulation") + ": " + (Object)((Object)EnumColor.GREY) + Tier.ConductorTier.get((Tier.BaseTier)tier).inverseConductionInsulation);
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.heatCapacity") + ": " + (Object)((Object)EnumColor.GREY) + Tier.ConductorTier.get((Tier.BaseTier)tier).inverseHeatCapacity);
            }
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails"));
        } else {
            BlockStateTransmitter.TransmitterType type = BlockStateTransmitter.TransmitterType.values()[itemstack.func_77952_i()];
            switch (type) {
                case UNIVERSAL_CABLE: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + "RF " + (Object)((Object)EnumColor.GREY) + "(ThermalExpansion)");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + "EU " + (Object)((Object)EnumColor.GREY) + "(IndustrialCraft)");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + "Joules " + (Object)((Object)EnumColor.GREY) + "(Mekanism)");
                    break;
                }
                case MECHANICAL_PIPE: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.fluids") + " " + (Object)((Object)EnumColor.GREY) + "(MinecraftForge)");
                    break;
                }
                case PRESSURIZED_TUBE: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.gasses") + " (Mekanism)");
                    break;
                }
                case LOGISTICAL_TRANSPORTER: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.items") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.blocks") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    break;
                }
                case RESTRICTIVE_TRANSPORTER: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.items") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.blocks") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    list.add("- " + (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("tooltip.restrictiveDesc"));
                    break;
                }
                case DIVERSION_TRANSPORTER: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.items") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.blocks") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    list.add("- " + (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("tooltip.diversionDesc"));
                    break;
                }
                case THERMODYNAMIC_CONDUCTOR: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.heat") + " (Mekanism)");
                }
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        BlockStateTransmitter.TransmitterType type = BlockStateTransmitter.TransmitterType.get(stack.func_77952_i());
        String name = type.getUnlocalizedName();
        if (type.hasTiers()) {
            Tier.BaseTier tier = this.getBaseTier(stack);
            name = tier.getSimpleName() + name;
        }
        return this.func_77658_a() + "." + name;
    }

    @Override
    public Tier.BaseTier getBaseTier(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return Tier.BaseTier.BASIC;
        }
        return Tier.BaseTier.values()[itemstack.func_77978_p().func_74762_e("tier")];
    }

    @Override
    public void setBaseTier(ItemStack itemstack, Tier.BaseTier tier) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("tier", tier.ordinal());
    }

    @Override
    @Optional.Method(modid="mcmultipart")
    protected IMultipart getMultiPart() {
        return MultipartMekanism.TRANSMITTER_MP;
    }
}

