/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.base.ITileNetwork;
import mekanism.common.base.TileNetworkList;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTileEntity
implements IMessageHandler<TileEntityMessage, IMessage> {
    public IMessage onMessage(TileEntityMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (player == null) {
            return null;
        }
        PacketHandler.handlePacket(() -> {
            TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
            if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.TILE_NETWORK_CAPABILITY, null)) {
                ITileNetwork network = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.TILE_NETWORK_CAPABILITY, null);
                try {
                    network.handlePacketData(message.storedBuffer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                message.storedBuffer.release();
            }
        }, player);
        return null;
    }

    public static class TileEntityMessage
    implements IMessage {
        public Coord4D coord4D;
        public TileNetworkList parameters;
        public ByteBuf storedBuffer = null;

        public TileEntityMessage() {
        }

        public TileEntityMessage(Coord4D coord, TileNetworkList params) {
            this.coord4D = coord;
            this.parameters = params;
        }

        public void toBytes(ByteBuf dataStream) {
            this.coord4D.write(dataStream);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                WorldServer world = server.func_71218_a(this.coord4D.dimensionId);
                PacketHandler.log("Sending TileEntity packet from coordinate " + this.coord4D + " (" + this.coord4D.getTileEntity((IBlockAccess)world) + ")");
            }
            PacketHandler.encode(this.parameters.toArray(), dataStream);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = Coord4D.read(dataStream);
            this.storedBuffer = dataStream.copy();
        }
    }
}

