/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public final class StackUtils {
    public static List<ItemStack> split(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return null;
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (stack.func_190916_E() == 1) {
            ret.add(stack);
            return ret;
        }
        int remain = stack.func_190916_E() % 2;
        int split = (int)((float)stack.func_190916_E() / 2.0f);
        ret.add(StackUtils.size(stack, split + remain));
        ret.add(StackUtils.size(stack, split));
        return ret;
    }

    public static Item getItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return stack.func_77973_b();
    }

    public static boolean diffIgnoreNull(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        return stack1.func_77973_b() != stack2.func_77973_b() || stack1.func_77952_i() != stack2.func_77952_i();
    }

    public static boolean equalsWildcard(ItemStack wild, ItemStack check) {
        if (wild.func_190926_b() || check.func_190926_b()) {
            return check == wild;
        }
        return wild.func_77973_b() == check.func_77973_b() && (wild.func_77952_i() == Short.MAX_VALUE || check.func_77952_i() == Short.MAX_VALUE || wild.func_77952_i() == check.func_77952_i());
    }

    public static boolean equalsWildcardWithNBT(ItemStack wild, ItemStack check) {
        boolean wildcard = StackUtils.equalsWildcard(wild, check);
        if (wild.func_190926_b() || check.func_190926_b()) {
            return wildcard;
        }
        return wildcard && (!wild.func_77942_o() ? !check.func_77942_o() : wild.func_77978_p() == check.func_77978_p() || wild.func_77978_p().equals((Object)check.func_77978_p()));
    }

    public static List<ItemStack> even(ItemStack stack1, ItemStack stack2) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (StackUtils.getSize(stack1) == StackUtils.getSize(stack2) || Math.abs(StackUtils.getSize(stack1) - StackUtils.getSize(stack2)) == 1) {
            ret.add(stack1);
            ret.add(stack2);
            return ret;
        }
        if (StackUtils.getSize(stack1) > StackUtils.getSize(stack2)) {
            int diff = StackUtils.getSize(stack1) - StackUtils.getSize(stack2);
            List<ItemStack> split = StackUtils.split(StackUtils.size(stack1, diff));
            ret.add(StackUtils.subtract(stack1, split.get(0)));
            ret.add(StackUtils.add(stack2, split.get(0)));
        } else if (StackUtils.getSize(stack2) > StackUtils.getSize(stack1)) {
            int diff = StackUtils.getSize(stack2) - StackUtils.getSize(stack1);
            List<ItemStack> split = StackUtils.split(StackUtils.size(stack2, diff));
            ret.add(StackUtils.subtract(stack2, split.get(0)));
            ret.add(StackUtils.add(stack1, split.get(0)));
        }
        return ret;
    }

    public static ItemStack add(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b()) {
            return stack2;
        }
        if (stack2.func_190926_b()) {
            return stack1;
        }
        return StackUtils.size(stack1, StackUtils.getSize(stack1) + StackUtils.getSize(stack2));
    }

    public static ItemStack subtract(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack2.func_190926_b()) {
            return stack1;
        }
        return StackUtils.size(stack1, StackUtils.getSize(stack1) - StackUtils.getSize(stack2));
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = stack.func_77946_l();
        ret.func_190920_e(size);
        return ret;
    }

    public static ItemStack copy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return stack.func_77946_l();
    }

    public static int getSize(ItemStack stack) {
        return !stack.func_190926_b() ? stack.func_190916_E() : 0;
    }

    public static List<ItemStack> getMergeRejects(NonNullList<ItemStack> orig, NonNullList<ItemStack> toAdd) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < toAdd.size(); ++i) {
            ItemStack reject;
            if (((ItemStack)toAdd.get(i)).func_190926_b() || (reject = StackUtils.getMergeReject((ItemStack)orig.get(i), (ItemStack)toAdd.get(i))).func_190926_b()) continue;
            ret.add(reject);
        }
        return ret;
    }

    public static void merge(NonNullList<ItemStack> orig, NonNullList<ItemStack> toAdd) {
        for (int i = 0; i < toAdd.size(); ++i) {
            if (((ItemStack)toAdd.get(i)).func_190926_b()) continue;
            orig.set(i, (Object)StackUtils.merge((ItemStack)orig.get(i), (ItemStack)toAdd.get(i)));
        }
    }

    public static ItemStack merge(ItemStack orig, ItemStack toAdd) {
        if (orig.func_190926_b()) {
            return toAdd;
        }
        if (toAdd.func_190926_b()) {
            return orig;
        }
        if (!orig.func_77969_a(toAdd) || !ItemStack.func_77970_a((ItemStack)orig, (ItemStack)toAdd)) {
            return orig;
        }
        return StackUtils.size(orig, Math.min(orig.func_77976_d(), orig.func_190916_E() + toAdd.func_190916_E()));
    }

    public static ItemStack getMergeReject(ItemStack orig, ItemStack toAdd) {
        if (orig.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (toAdd.func_190926_b()) {
            return orig;
        }
        if (!orig.func_77969_a(toAdd) || !ItemStack.func_77970_a((ItemStack)orig, (ItemStack)toAdd)) {
            return orig;
        }
        int newSize = orig.func_190916_E() + toAdd.func_190916_E();
        if (newSize > orig.func_77976_d()) {
            return StackUtils.size(orig, newSize - orig.func_77976_d());
        }
        return StackUtils.size(orig, newSize);
    }

    public static int hashItemStack(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() == null) {
            return -1;
        }
        String name = stack.func_77952_i() == Short.MAX_VALUE ? stack.func_77973_b().func_77658_a() : stack.func_77973_b().func_77667_c(stack);
        return name.hashCode() << 8 | stack.func_77952_i();
    }
}

