/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.init;

import appeng.api.AEApi;
import appeng.api.features.IWirelessTermHandler;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.LoaderState;
import p455w0rd.ae2wtlib.AE2WTLib;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.WTRegistry;
import p455w0rd.ae2wtlib.init.LibConfig;
import p455w0rd.ae2wtlib.init.LibLogger;
import p455w0rd.ae2wtlib.items.ItemWT;

public class LibWTRegistry
extends WTRegistry {
    private static final List<ICustomWirelessTerminalItem> WT_REGISTRY = Lists.newArrayList();

    public List<ICustomWirelessTerminalItem> getRegisteredTerminals() {
        return WT_REGISTRY;
    }

    @Override
    public void registerWirelessTerminal(ICustomWirelessTerminalItem wirelessTerminal) {
        if (AE2WTLib.PROXY.getLoaderState() != LoaderState.PREINITIALIZATION) {
            LibLogger.warn("Wireless Terminals must be registered during PreInit!");
            return;
        }
        if (wirelessTerminal != null) {
            if (!(wirelessTerminal instanceof ItemWT)) {
                LibLogger.warn("Wireless terminal items must extends ItemWT.class");
                return;
            }
            if (!(wirelessTerminal instanceof ICustomWirelessTerminalItem)) {
                LibLogger.warn("Wireless terminal items must implement ICustomWirelessTerminalItem.class");
                return;
            }
            if (WT_REGISTRY.contains(wirelessTerminal)) {
                LibLogger.warn("Terminal " + wirelessTerminal.getClass() + " has already been registered!");
                return;
            }
            this.getRegisteredTerminals().add(wirelessTerminal);
        }
    }

    private static void registerTerminalWithAE2(IWirelessTermHandler wirelessTerminal) {
        if (wirelessTerminal instanceof ItemWT) {
            AEApi.instance().registries().wireless().registerWirelessHandler(wirelessTerminal);
            AEApi.instance().registries().charger().addChargeRate((Item)wirelessTerminal, (double)LibConfig.WT_MAX_POWER);
        }
    }

    public static void registerAllTerminalsWithAE2() {
        for (ICustomWirelessTerminalItem iCustomWirelessTerminalItem : WTApi.instance().getRegistry().getRegisteredTerminals()) {
            if (!(iCustomWirelessTerminalItem instanceof ItemWT)) continue;
            LibWTRegistry.registerTerminalWithAE2(iCustomWirelessTerminalItem);
        }
    }
}

