/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import com.google.common.collect.Iterables;
import ic2.core.IC2;
import ic2.core.Profile;
import ic2.core.ProfileParser;
import ic2.core.ProfileTarget;
import ic2.core.RecipeChange;
import ic2.core.TextureStyle;
import ic2.core.Version;
import ic2.core.init.Rezepte;
import ic2.core.util.ReflectionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProfileManager {
    public static final String EXPERIMENTAL = "Experimental";
    public static final String CLASSIC = "Classic";
    public static final Map<String, Profile> PROFILES = ProfileManager.addDefaultProfiles();
    @SideOnly(value=Side.CLIENT)
    private static List<IResourcePack> textureChanges;
    public static Profile selected;

    private static Map<String, Profile> addDefaultProfiles() {
        HashMap<String, Profile> ret = new HashMap<String, Profile>();
        ret.put(EXPERIMENTAL, new Profile(EXPERIMENTAL, Collections.singleton(TextureStyle.EXPERIMENTAL), Version.NEW, new RecipeChange[0]));
        try {
            ret.put(CLASSIC, ProfileParser.parse(ProfileTarget.fromJar("ic2/profiles/classic")));
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening profile XML", e);
        }
        return ret;
    }

    public static void init() {
        if (System.getProperty("IC2.lotsOfFun") != null) {
            ProfileManager.applySwitch(ProfileManager.getOrError(CLASSIC));
        }
    }

    public static boolean registerProfile(Profile profile) {
        return PROFILES.putIfAbsent(profile.name, profile) == null;
    }

    public static ChangeAction switchProfiles(Profile to) {
        Profile from = selected;
        if (from == to) {
            return ChangeAction.Nothing;
        }
        ProfileManager.applySwitch(to);
        if (from.style != to.style) {
            return ChangeAction.GameReload;
        }
        if (!from.recipeConfigs.equals(to.recipeConfigs) || !from.recipeRemovals.equals(to.recipeRemovals)) {
            return ChangeAction.GameReload;
        }
        if (!from.textures.equals(to.textures)) {
            return ChangeAction.ResourceReload;
        }
        return ChangeAction.Nothing;
    }

    private static void applySwitch(Profile to) {
        selected = to;
        IC2.version = to.style;
    }

    public static Profile get(String name) {
        return PROFILES.get(name);
    }

    public static Profile getOrError(String name) {
        Profile ret = PROFILES.get(name);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("Cannot find profile " + name + "! Only have " + PROFILES);
    }

    public static InputStream getRecipeConfig(String name) {
        List<RecipeChange> configs = selected.processRecipeConfigs(name);
        if (configs.isEmpty()) {
            return Rezepte.getDefaultConfigFile(name);
        }
        boolean isReplacing = configs.stream().anyMatch(change -> change.type == RecipeChange.ChangeType.REPLACEMENT);
        if (isReplacing && configs.size() == 1) {
            return ((RecipeChange)Iterables.getOnlyElement(configs)).getStream();
        }
        List streams = configs.stream().map(RecipeChange::getStream).filter(Objects::nonNull).collect(Collectors.toList());
        if (!isReplacing) {
            streams.add(0, Rezepte.getDefaultConfigFile(name));
        }
        byte[] split = new byte[]{10};
        for (int i = configs.size() - 1; i > 0; --i) {
            streams.add(i, new ByteArrayInputStream(split));
        }
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public static void getRecipeRemovals(String name) {
        List<Object> configs = ProfileManager.selected.recipeRemovals.get(name);
        if (configs.isEmpty()) {
            // empty if block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doTextureChanges() {
        if (textureChanges == null) {
            textureChanges = Collections.emptyList();
        }
        ArrayList<IResourcePack> packs = new ArrayList<IResourcePack>();
        Map domainManagers = (Map)ReflectionUtil.getValue(Minecraft.func_71410_x().func_110442_L(), Map.class);
        for (TextureStyle texture : ProfileManager.selected.textures) {
            FallbackResourceManager manager = (FallbackResourceManager)domainManagers.get(texture.mod);
            if (manager == null) continue;
            ((List)ReflectionUtil.getValue(manager, List.class)).removeAll(textureChanges);
            IResourcePack pack2 = texture.applyChanges();
            if (pack2 == null) continue;
            manager.func_110538_a(pack2);
            packs.add(pack2);
        }
        List defaultPacks = (List)ReflectionUtil.getValue(FMLClientHandler.instance(), List.class);
        defaultPacks.removeAll(textureChanges);
        assert (!defaultPacks.stream().anyMatch(pack -> pack.func_130077_b().startsWith("IC2 Profile Pack for ")));
        packs.forEach(defaultPacks::add);
        textureChanges = packs;
    }

    static {
        selected = ProfileManager.getOrError(EXPERIMENTAL);
    }

    public static enum ChangeAction {
        Nothing,
        ResourceReload,
        GameReload;

    }
}

