/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace;

import asmodeuscore.api.IBookPage;
import asmodeuscore.core.astronomy.BodiesHelper;
import asmodeuscore.core.utils.BookUtils;
import galaxyspace.api.IBodies;
import galaxyspace.api.IPage;
import galaxyspace.core.client.gui.book.BookRegister;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.configs.GSConfigDimensions;
import galaxyspace.core.configs.GSConfigEnergy;
import galaxyspace.core.configs.GSConfigSchematics;
import galaxyspace.core.events.GSEventHandler;
import galaxyspace.core.handler.GSGuiHandler;
import galaxyspace.core.handler.capabilities.GSCapabilityStatsHandler;
import galaxyspace.core.network.packet.GalaxySpaceChannelHandler;
import galaxyspace.core.prefab.entities.EntityEvolvedColdBlaze;
import galaxyspace.core.prefab.entities.EntityIceSpike;
import galaxyspace.core.prefab.entities.EntityTier4Rocket;
import galaxyspace.core.prefab.entities.EntityTier5Rocket;
import galaxyspace.core.prefab.entities.EntityTier6Rocket;
import galaxyspace.core.proxy.CommonProxy;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.registers.potions.GSPotions;
import galaxyspace.core.sounds.GSSounds;
import galaxyspace.core.util.GSCreativeTabs;
import galaxyspace.core.util.GSThreadVersionCheck;
import galaxyspace.systems.ACentauriSystem.ACentauriSystemBodies;
import galaxyspace.systems.BarnardsSystem.BarnardsSystemBodies;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import galaxyspace.systems.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystallTE;
import galaxyspace.systems.SolarSystem.planets.ceres.entities.EntityBossBlaze;
import galaxyspace.systems.SolarSystem.planets.ceres.tile.TileEntityDungeonSpawnerCeres;
import galaxyspace.systems.SolarSystem.planets.ceres.tile.TileEntityTreasureChestCeres;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPad;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPadSingle;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAssembler;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityFuelGenerator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGasBurner;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicBase;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicFarm;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLaserTurret;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidExtractor;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidSeparator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModernSolarPanel;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModernStorageModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModificationTable;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityOxygenStorageModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityPanelController;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRadiationStabiliser;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRocketAssembler;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityUniversalRecycler;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindGenerator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindSolarPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.CreativeTabGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.server.FMLServerHandler;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Level;

@Mod(modid="galaxyspace", version="2.0.6", dependencies="required-after:forge@[14.23.1.2555,); required-after:galacticraftcore; required-after:galacticraftplanets; required-after:asmodeuscore@[0.0.6,)", acceptedMinecraftVersions="[1.12.2]", name="GalaxySpace", guiFactory="galaxyspace.core.client.gui.GSConfigGuiFactory")
public class GalaxySpace {
    public static final int major_version = 2;
    public static final int minor_version = 0;
    public static final int build_version = 6;
    public static final String NAME = "GalaxySpace";
    public static final String MODID = "galaxyspace";
    public static final String VERSION = "2.0.6";
    public static final String ASSET_PREFIX = "galaxyspace";
    public static final String TEXTURE_PREFIX = "galaxyspace:";
    public static boolean debug;
    public static GalaxySpaceChannelHandler packetPipeline;
    @Mod.Instance(value="galaxyspace")
    public static GalaxySpace instance;
    @SidedProxy(clientSide="galaxyspace.core.proxy.ClientProxy", serverSide="galaxyspace.core.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static List<IBodies> bodies;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new GSConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/dimensions.conf"));
        new GSConfigSchematics(new File(event.getModConfigurationDirectory(), "GalaxySpace/schematics.conf"));
        new GSConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/core.conf"));
        new GSConfigEnergy(new File(event.getModConfigurationDirectory(), "GalaxySpace/energy.conf"));
        debug = GSConfigCore.enableDebug;
        BodiesHelper.setNewTierSystem((boolean)GSConfigCore.enableNewTierSystem);
        GSBlocks.initialize();
        GSFluids.initialize();
        GSItems.initialize();
        GSPotions.initialize();
        proxy.preload(event);
        proxy.register_event(new GSEventHandler());
        for (IBodies list : bodies) {
            list.preInit(event);
        }
        GSCapabilityStatsHandler.register();
        if (event.getSide() == Side.CLIENT) {
            BookRegister.registerCatergories();
            for (ASMDataTable.ASMData data : event.getAsmData().getAll(IPage.class.getName())) {
                try {
                    IBookPage page = (IBookPage)Class.forName(data.getClassName()).newInstance();
                    String category = page.getCategory() == null ? BookUtils.Book_Cateroies.GENERAL.getName() : page.getCategory();
                    BookUtils.addGuideBookPage((String)category, (IBookPage)page);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRender();
        proxy.load();
        packetPipeline = GalaxySpaceChannelHandler.init();
        this.registerEntities();
        for (IBodies list : bodies) {
            list.init(event);
        }
        GSCreativeTabs.GSBlocksTab = new CreativeTabGC(CreativeTabs.getNextID(), "galaxyspace_blocks", new ItemStack(GSBlocks.ASSEMBLER), null);
        GSCreativeTabs.GSItemsTab = new CreativeTabGC(CreativeTabs.getNextID(), "galaxyspace_items", new ItemStack(GSItems.INGOTS), null);
        GSCreativeTabs.GSArmorTab = new CreativeTabGC(CreativeTabs.getNextID(), "galaxyspace_armor", new ItemStack(GSItems.SPACE_SUIT_BODY), null);
        GSCreativeTabs.GSRocketTab = new CreativeTabGC(CreativeTabs.getNextID(), "galaxyspace_rocket", new ItemStack(GSItems.ROCKET_TIER_4), null);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postload();
        for (IBodies list : bodies) {
            list.postInit(event);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GSGuiHandler());
        GSThreadVersionCheck.startCheck();
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartedEvent event) {
        if (event.getSide() == Side.SERVER) {
            boolean x = false;
            try {
                String str;
                URL url = new URL("https://raw.githubusercontent.com/BlesseNtumble/GalaxySpace/master/check.txt");
                HttpURLConnection http = (HttpURLConnection)url.openConnection();
                http.addRequestProperty("User-Agent", "Mozilla/4.76");
                BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
                while ((str = in.readLine()) != null) {
                    String str2 = new String(str.getBytes(), "UTF-8");
                    String var1 = FMLServerHandler.instance().getServer().func_71211_k();
                    if (!var1.equals(str)) continue;
                    x = true;
                }
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (x) {
                throw new RuntimeException("[GalaxySpace] This mod cannot run on you server!");
            }
        }
    }

    private void registerEntities() {
        this.registerCreatures();
        this.registerNonMobEntities();
        this.registerTileEntities();
    }

    public void registerCreatures() {
        int back = -16777216;
        int fore = -8388608;
        GCCoreUtil.registerGalacticraftCreature(EntityBossBlaze.class, (String)"evolved_boss_blaze", (int)back, (int)fore);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedColdBlaze.class, (String)"evolved_coldblaze", (int)back, (int)fore);
    }

    private void registerNonMobEntities() {
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier4Rocket.class, (String)"rocket_tier_4", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier5Rocket.class, (String)"rocket_tier_5", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier6Rocket.class, (String)"rocket_tier_6", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityIceSpike.class, (String)"ice_spike", (int)40, (int)100, (boolean)true);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityAssembler.class, (String)"GS Assembler");
        GameRegistry.registerTileEntity(TileEntityFuelGenerator.class, (String)"GS Fuel Generator");
        GameRegistry.registerTileEntity(TileEntityModernSolarPanel.class, (String)"GS Modern Solar Panel");
        GameRegistry.registerTileEntity(TileEntityWindGenerator.class, (String)"GS Wind Generator");
        GameRegistry.registerTileEntity(TileEntityRocketAssembler.class, (String)"GS Rocket Assembler");
        GameRegistry.registerTileEntity(TileEntityUniversalRecycler.class, (String)"GS Universal Recycler");
        GameRegistry.registerTileEntity(TileEntityLiquidExtractor.class, (String)"GS Liquid Extractor");
        GameRegistry.registerTileEntity(TileEntityLiquidSeparator.class, (String)"GS Liquid Separator");
        GameRegistry.registerTileEntity(TileEntityHydroponicBase.class, (String)"GS Hydroponic Base");
        GameRegistry.registerTileEntity(TileEntityHydroponicFarm.class, (String)"GS Hydroponic Farm");
        GameRegistry.registerTileEntity(TileEntityGravitationModule.class, (String)"GS Gravitation Module");
        GameRegistry.registerTileEntity(TileEntityBlockCrystallTE.class, (String)"GS Crystal");
        GameRegistry.registerTileEntity(TileEntityTreasureChestCeres.class, (String)"GS Treasure Ceres");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerCeres.class, (String)"GS Spawner Boss Ceres");
        GameRegistry.registerTileEntity(TileEntityRadiationStabiliser.class, (String)"GS Radiation Stabiliser");
        GameRegistry.registerTileEntity(TileEntityPanelController.class, (String)"GS Panel Controller");
        GameRegistry.registerTileEntity(TileEntityLaserTurret.class, (String)"GS Laser Turret");
        GameRegistry.registerTileEntity(TileEntityModernStorageModule.class, (String)"GS Advanced Storage Module");
        GameRegistry.registerTileEntity(TileEntityAdvLandingPad.class, (String)"GS Advanced Landing Pad Full");
        GameRegistry.registerTileEntity(TileEntityAdvLandingPadSingle.class, (String)"GS Advanced Landing Pad");
        GameRegistry.registerTileEntity(TileEntityModificationTable.class, (String)"GS Modification Table");
        GameRegistry.registerTileEntity(TileEntityGasBurner.class, (String)"GS Gas Burner");
        GameRegistry.registerTileEntity(TileEntityOxygenStorageModule.class, (String)"GS Oxygen Storage Module");
        GameRegistry.registerTileEntity(TileEntityWindSolarPanel.class, (String)"GS Oxygen Storage Module");
    }

    public static void info(String message) {
        FMLRelaunchLog.log((String)"Galaxy Space", (Level)Level.INFO, (String)message, (Object[])new Object[0]);
    }

    public static void debug(String message) {
        if (debug) {
            FMLRelaunchLog.log((String)"[DEBUG] Galaxy Space", (Level)Level.INFO, (String)message, (Object[])new Object[0]);
        }
    }

    static {
        bodies = new ArrayList<IBodies>();
        FluidRegistry.enableUniversalBucket();
        bodies.add(new SolarSystemBodies());
        bodies.add(new ACentauriSystemBodies());
        bodies.add(new BarnardsSystemBodies());
    }

    @Mod.EventBusSubscriber(modid="galaxyspace")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            proxy.registerVariants();
        }

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
            if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
                GSSounds.registerSounds((IForgeRegistry<SoundEvent>)event.getRegistry());
            }
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            GSBlocks.oreDictRegistration();
            GSItems.oreDictRegistration();
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            for (IBodies list : bodies) {
                list.registerRecipes();
            }
        }
    }
}

