/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile.generator;

import com.google.common.base.Predicate;
import java.util.Random;
import nc.block.tile.processor.BlockProcessor;
import nc.config.NCConfig;
import nc.enumm.BlockEnums;
import nc.handler.SoundHandler;
import nc.tile.generator.TileFissionController;
import nc.util.BlockFinder;
import nc.util.NCInventoryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockFissionControllerNewFixed
extends BlockProcessor {
    private static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockFissionControllerNewFixed() {
        super(BlockEnums.ProcessorType.FISSION_CONTROLLER_NEW_FIXED);
    }

    @Override
    protected IBlockState getNewDefaultState() {
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(meta & 7));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setDefaultDirection(world, pos, state);
    }

    private void setDefaultDirection(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            boolean flag = world.func_180495_p(pos.func_177978_c()).func_185913_b();
            boolean flag1 = world.func_180495_p(pos.func_177968_d()).func_185913_b();
            if (enumfacing == EnumFacing.NORTH && flag && !flag1) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && flag1 && !flag) {
                enumfacing = EnumFacing.NORTH;
            } else {
                boolean flag2 = world.func_180495_p(pos.func_177976_e()).func_185913_b();
                boolean flag3 = world.func_180495_p(pos.func_177974_f()).func_185913_b();
                if (enumfacing == EnumFacing.WEST && flag2 && !flag3) {
                    enumfacing = EnumFacing.EAST;
                } else if (enumfacing == EnumFacing.EAST && flag3 && !flag2) {
                    enumfacing = EnumFacing.WEST;
                }
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    public void setActiveState(IBlockState state, World world, BlockPos pos, boolean active) {
        if (!world.field_72995_K && active != (Boolean)state.func_177229_b((IProperty)ACTIVE)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)), 2);
        }
    }

    @Override
    public void setState(boolean active, World world, BlockPos pos) {
    }

    @Override
    public void onGuiOpened(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFissionController) {
            TileFissionController controller = (TileFissionController)tile;
            controller.refreshMultiblock(true);
        }
    }

    @Override
    public void dropItems(World world, BlockPos pos, IInventory tileentity) {
        NCInventoryHelper.dropInventoryItems(world, pos, tileentity, 0, 1);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFissionController) {
            TileFissionController controller = (TileFissionController)tile;
            if (controller.heatChange > 0.0) {
                return (int)MathHelper.func_151237_a((double)(1500.0 / (double)NCConfig.fission_comparator_max_heat * controller.heat / (double)controller.getMaxHeat()), (double)0.0, (double)15.0);
            }
            return (int)MathHelper.func_151237_a((double)(15.0 * (double)controller.getEnergyStored() / (double)controller.getMaxEnergyStored()), (double)0.0, (double)15.0);
        }
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Override
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFissionController) {
            TileFissionController controller = (TileFissionController)tile;
            BlockFinder finder = new BlockFinder(pos, world, controller.func_145832_p() & 7);
            BlockPos position = finder.randomWithin(controller.minX, controller.maxX, controller.minY, controller.maxY, controller.minZ, controller.maxZ);
            if (controller.cells <= 0) {
                return;
            }
            double soundRate = MathHelper.func_151237_a((double)0.08, (double)(2.0 * Math.sqrt(controller.cells) / (double)NCConfig.fission_max_size), (double)1.0);
            if (controller.isProcessing && rand.nextDouble() < soundRate) {
                world.func_184134_a((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), SoundHandler.geiger_tick, SoundCategory.BLOCKS, 1.6f, 1.0f + 0.12f * (rand.nextFloat() - 0.5f), false);
            }
        }
    }
}

