/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.network;

import io.netty.buffer.ByteBuf;
import nc.multiblock.network.MultiblockUpdatePacket;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.tile.TileTurbineController;
import net.minecraft.util.math.BlockPos;

public class TurbineUpdatePacket
extends MultiblockUpdatePacket {
    protected boolean isTurbineOn;

    public TurbineUpdatePacket() {
        this.messageValid = false;
    }

    public TurbineUpdatePacket(BlockPos pos, boolean isTurbineOn) {
        this.pos = pos;
        this.isTurbineOn = isTurbineOn;
        this.messageValid = true;
    }

    @Override
    public void readMessage(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.isTurbineOn = buf.readBoolean();
    }

    @Override
    public void writeMessage(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.isTurbineOn);
    }

    public static class Handler
    extends MultiblockUpdatePacket.Handler<TurbineUpdatePacket, Turbine, TileTurbineController> {
        public Handler() {
            super(TileTurbineController.class);
        }

        @Override
        protected void onPacket(TurbineUpdatePacket message, Turbine reactor) {
            reactor.onPacket(message.isTurbineOn);
        }
    }
}

