/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class Rotating4WaysMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        if (type == BoundingBoxType.COLLISION) {
            return null;
        }
        AxisAlignedBB aabb = IDoorMovement.getHalfBoundingBox();
        EnumFacing.Axis axis = topBlock == tileEntity.isHingeLeft() ? EnumFacing.Axis.X : EnumFacing.Axis.Y;
        int dir = tileEntity.isHingeLeft() ? -1 : 1;
        aabb = AABBUtils.rotate((AxisAlignedBB)aabb, (int)dir, (EnumFacing.Axis)axis);
        return aabb;
    }

    private Rotation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float angle = 90.0f;
        float hingeX = -0.40625f;
        float hingeY = -0.40625f;
        float hingeZ = -0.40625f;
        boolean axisX = false;
        boolean axisY = false;
        if (topBlock) {
            angle = -angle;
            hingeY = 1.0f - hingeY;
        }
        if (tileEntity.isHingeLeft()) {
            hingeX = -hingeX;
        }
        if (topBlock == tileEntity.isHingeLeft()) {
            axisX = true;
        } else {
            axisY = true;
        }
        Rotation rotation = new Rotation(angle);
        rotation.aroundAxis((float)axisX, (float)axisY, 0.0f).offset(hingeX, hingeY, hingeZ);
        rotation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        rotation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return rotation;
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model.getShape("top"), (Transformation)this.getTransformation(tileEntity, true)), new Animation((ITransformable)model.getShape("bottom"), (Transformation)this.getTransformation(tileEntity, false))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

