/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.fluids;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class FluidTankBase
implements IFluidTank,
IFluidHandler {
    protected TileEntity tile;
    protected boolean canFill = true;
    protected boolean canDrain = true;
    protected IFluidTankProperties[] tankProperties;

    public FluidTankBase readFromNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            this.setFluid(fluid);
        } else {
            this.setFluid(null);
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.getFluid() != null) {
            this.getFluid().writeToNBT(nbt);
        } else {
            nbt.func_74778_a("Empty", "");
        }
        return nbt;
    }

    @Nullable
    public abstract FluidStack getFluid();

    public abstract void setFluid(@Nullable FluidStack var1);

    public int getFluidAmount() {
        if (this.getFluid() == null) {
            return 0;
        }
        return this.getFluid().amount;
    }

    public abstract int getCapacity();

    public void setTileEntity(TileEntity tile) {
        this.tile = tile;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.tankProperties == null) {
            this.tankProperties = new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    FluidStack fluid = FluidTankBase.this.getFluid();
                    return fluid != null ? fluid.copy() : null;
                }

                public int getCapacity() {
                    return FluidTankBase.this.getCapacity();
                }

                public boolean canFill() {
                    return FluidTankBase.this.canFill();
                }

                public boolean canDrain() {
                    return FluidTankBase.this.canDrain();
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return FluidTankBase.this.canFillFluidType(fluidStack);
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return FluidTankBase.this.canDrainFluidType(fluidStack);
                }
            }};
        }
        return this.tankProperties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.canFillFluidType(resource)) {
            return 0;
        }
        return this.fillInternal(resource, doFill);
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        FluidStack fluid = this.getFluid();
        if (!doFill) {
            if (fluid == null) {
                return Math.min(this.getCapacity(), resource.amount);
            }
            if (!fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.getCapacity() - fluid.amount, resource.amount);
        }
        if (fluid == null) {
            fluid = new FluidStack(resource, Math.min(this.getCapacity(), resource.amount));
            this.setFluid(fluid);
            this.onContentsChanged();
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, fluid.amount));
            }
            return fluid.amount;
        }
        if (!fluid.isFluidEqual(resource)) {
            return 0;
        }
        fluid = fluid.copy();
        int filled = this.getCapacity() - fluid.amount;
        if (resource.amount < filled) {
            fluid.amount += resource.amount;
            filled = resource.amount;
        } else {
            fluid.amount = this.getCapacity();
        }
        this.onContentsChanged();
        this.setFluid(fluid);
        if (this.tile != null) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, filled));
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (!this.canDrainFluidType(this.getFluid())) {
            return null;
        }
        return this.drainInternal(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.canDrainFluidType(this.getFluid())) {
            return null;
        }
        return this.drainInternal(maxDrain, doDrain);
    }

    public FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.getFluid())) {
            return null;
        }
        return this.drainInternal(resource.amount, doDrain);
    }

    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        FluidStack fluid = this.getFluid();
        if (fluid == null || maxDrain <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            fluid = fluid.copy();
            fluid.amount -= drained;
            if (fluid.amount <= 0) {
                fluid = null;
                this.setFluid(null);
            } else {
                this.setFluid(fluid);
            }
            this.onContentsChanged();
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(fluid, this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, drained));
            }
        }
        return stack;
    }

    public boolean canFill() {
        return this.canFill;
    }

    public boolean canDrain() {
        return this.canDrain;
    }

    public void setCanFill(boolean canFill) {
        this.canFill = canFill;
    }

    public void setCanDrain(boolean canDrain) {
        this.canDrain = canDrain;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.canFill();
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.canDrain();
    }

    protected void onContentsChanged() {
    }
}

