/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.gui.manager;

import net.malisis.advert.advert.ClientAdvert;
import net.malisis.advert.gui.manager.AdvertManagerGui;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIBackgroundContainer;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.renderer.font.FontOptions;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.FileUtils;

public class AdvertComponent
extends UIBackgroundContainer {
    private ClientAdvert advert;
    private FontOptions nameOptions = FontOptions.builder().color(0xFFFFFF).shadow().build();
    private FontOptions nameHoverOptions = FontOptions.builder().color(0xFFFF99).shadow().build();
    private FontOptions fontOptions = FontOptions.builder().scale(0.6666667f).color(0x444444).build();
    private FontOptions hoverFontOptions = FontOptions.builder().scale(0.6666667f).color(0x888866).build();
    private UILabel emptyLabel;
    private UILabel name;
    private UILabel dimensions;
    private UILabel fileSize;
    private UILabel url;

    public AdvertComponent(MalisisGui gui, ClientAdvert advert) {
        super(gui);
        this.setSize(0, 20);
        this.advert = advert;
        this.emptyLabel = new UILabel(gui);
        this.emptyLabel.setParent((UIComponent)this);
        int x = 3;
        this.name = new UILabel(gui, advert.getName());
        this.name.setPosition(x, 3);
        this.add(new UIComponent[]{this.name});
        this.dimensions = new UILabel(gui, advert.getWidth() + "x" + advert.getHeight());
        this.dimensions.setPosition(x += Math.max(70, this.name.getWidth() + 3), 6);
        this.add(new UIComponent[]{this.dimensions});
        String size = FileUtils.byteCountToDisplaySize((long)advert.getSize());
        this.fileSize = new UILabel(gui, "(" + size + ")");
        this.fileSize.setPosition(x += this.dimensions.getWidth() + 3, 6);
        this.add(new UIComponent[]{this.fileSize});
        this.url = new UILabel(gui, advert.getUrl());
        this.url.setPosition(3, 14);
        this.add(new UIComponent[]{this.url});
    }

    private void updateColor() {
        if (this.advert == AdvertManagerGui.advert) {
            this.setColor(0xBBBBEE);
            this.setBorder(0x333333, 1, 255);
        } else {
            this.setColor(0xC6C6C6);
            this.setBorder(0xC6C6C6, 1, 255);
        }
    }

    private void updateLabels() {
        this.name.setFontOptions(this.isHovered() ? this.nameHoverOptions : this.nameOptions);
        FontOptions options = this.isHovered() ? this.hoverFontOptions : this.fontOptions;
        this.dimensions.setFontOptions(options);
        this.fileSize.setFontOptions(options);
        this.url.setFontOptions(options);
    }

    public void drawEmpty(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.emptyLabel.setText(TextFormatting.ITALIC + (ClientAdvert.isPending() ? "malisisadvert.gui.querylist" : "malisisadvert.gui.noad"));
        this.emptyLabel.draw(renderer, mouseX, mouseY, partialTick);
    }

    public void draw(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.updateColor();
        this.updateLabels();
        super.draw(renderer, mouseX, mouseY, partialTick);
    }

    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        super.drawForeground(renderer, mouseX, mouseY, partialTick);
    }

    public boolean onClick(int x, int y) {
        AdvertManagerGui gui = (AdvertManagerGui)this.getGui();
        gui.showForm(true);
        gui.selectAdvert(this.advert);
        return true;
    }
}

