/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import cofh.core.network.PacketBase;
import cofh.core.util.CoreUtils;
import cofh.core.util.helpers.BlockHelper;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import cofh.thermaldynamics.util.TickHandlerClient;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TravelingItem {
    public ItemStack stack;
    public byte progress;
    public byte direction;
    public byte oldDirection;
    public Route myPath;
    public boolean goingToStuff = false;
    public int startX;
    public int startY;
    public int startZ;
    public int destX;
    public int destY;
    public int destZ;
    public boolean mustGoToDest = false;
    public boolean hasDest = false;
    public boolean reRoute = false;
    public StackMap.ItemEntry stackItemEntry;
    public boolean shouldDie = false;
    public int step = 1;

    public TravelingItem(ItemStack theItem, IGridTile<DuctUnitItem, GridItem> start, Route itemPath, byte oldDirection, byte speed) {
        this(theItem, start.x(), start.y(), start.z(), itemPath, oldDirection, speed);
    }

    public TravelingItem(ItemStack theItem, int xCoord, int yCoord, int zCoord, Route itemPath, byte oldDirection, byte speed) {
        this.progress = 0;
        this.direction = itemPath.getNextDirection();
        this.myPath = itemPath;
        this.startX = xCoord;
        this.startY = yCoord;
        this.startZ = zCoord;
        this.stack = theItem;
        this.oldDirection = oldDirection;
        this.step = speed;
        if (this.myPath != null && this.myPath.endPoint != null) {
            this.destX = this.myPath.endPoint.x();
            this.destY = this.myPath.endPoint.y();
            this.destZ = this.myPath.endPoint.z();
            this.hasDest = true;
        }
    }

    public TravelingItem(byte progress, byte direction, byte oldDirection, ItemStack theItem, DuctUnitItem homeTile, byte step) {
        this.progress = progress;
        this.direction = direction;
        this.oldDirection = oldDirection;
        this.stack = theItem;
        this.step = step;
    }

    public TravelingItem(NBTTagCompound theNBT) {
        this.stack = new ItemStack(theNBT.func_74775_l("stack"));
        this.progress = theNBT.func_74771_c("progress");
        this.direction = theNBT.func_74771_c("direction");
        this.oldDirection = theNBT.func_74771_c("oldDir");
        this.goingToStuff = theNBT.func_74767_n("goingToStuff");
        if (theNBT.func_74764_b("destX")) {
            this.hasDest = true;
            this.destX = theNBT.func_74762_e("destX");
            this.destY = theNBT.func_74762_e("destY");
            this.destZ = theNBT.func_74762_e("destZ");
            this.mustGoToDest = theNBT.func_74767_n("mustGo");
        }
        this.step = theNBT.func_74771_c("step");
        this.startX = theNBT.func_74762_e("startX");
        this.startY = theNBT.func_74762_e("startY");
        this.startZ = theNBT.func_74762_e("startZ");
        if (theNBT.func_150297_b("route", 7)) {
            this.myPath = new Route(theNBT.func_74770_j("route"));
        }
    }

    public static TravelingItem fromPacket(PacketBase payload, DuctUnitItem homeTile) {
        return new TravelingItem(payload.getByte(), payload.getByte(), payload.getByte(), payload.getItemStack(), homeTile, payload.getByte());
    }

    public void tickForward(DuctUnitItem homeTile) {
        this.progress = (byte)(this.progress + this.step);
        if (this.myPath == null) {
            this.bounceItem(homeTile);
        } else if (this.progress >= homeTile.getDuctLength()) {
            this.progress = (byte)(this.progress % homeTile.getDuctLength());
            this.advanceTile(homeTile);
        } else if (this.progress >= homeTile.getPipeHalfLength() && this.progress - this.step < homeTile.getPipeHalfLength() && (this.reRoute || homeTile.getRenderConnectionType(this.direction) == BlockDuct.ConnectionType.NONE)) {
            this.bounceItem(homeTile);
        }
    }

    public void advanceTile(DuctUnitItem homeTile) {
        DuctUnitItem newHome = (DuctUnitItem)homeTile.getConnectedSide(this.direction);
        if (newHome != null) {
            if (((DuctUnitItem[])newHome.ductCache)[this.direction ^ 1] != null) {
                homeTile.removeItem(this, false);
                newHome.transferItem(this);
                if (this.myPath.hasNextDirection()) {
                    this.oldDirection = this.direction;
                    this.direction = this.myPath.getNextDirection();
                } else {
                    this.reRoute = true;
                }
            }
        } else if (homeTile.isOutput(this.direction) && homeTile.parent.getConnectionType((int)this.direction).allowTransfer) {
            this.stack.func_190920_e(homeTile.insertIntoInventory(this.stack.func_77946_l(), this.direction));
            if (this.stack.func_190916_E() > 0) {
                this.bounceItem(homeTile);
                return;
            }
            homeTile.removeItem(this, true);
        } else if (homeTile.isInput(this.direction) && this.goingToStuff) {
            if (homeTile.canStuffItem()) {
                this.goingToStuff = false;
                homeTile.stuffItem(this);
                homeTile.removeItem(this, true);
            } else {
                this.goingToStuff = false;
                this.bounceItem(homeTile);
            }
        } else {
            this.bounceItem(homeTile);
        }
    }

    public void bounceItem(DuctUnitItem homeTile) {
        byte side;
        RouteCache<DuctUnitItem, GridItem> routes = homeTile.getCache();
        this.reRoute = false;
        if (this.hasDest) {
            for (Route route : routes.outputRoutes) {
                if (!((DuctUnitItem)route.endPoint).isNode() || ((DuctUnitItem)route.endPoint).x() != this.destX || ((DuctUnitItem)route.endPoint).y() != this.destY || ((DuctUnitItem)route.endPoint).z() != this.destZ) continue;
                for (side = 0; side < 6; side = (byte)(side + 1)) {
                    if (((DuctUnitItem)route.endPoint).canRouteItem(this.stack, side) == -1) continue;
                    this.myPath = route.copy();
                    this.myPath.pathDirections.add(side);
                    this.oldDirection = (byte)(this.direction ^ 1);
                    this.direction = this.myPath.getNextDirection();
                    homeTile.hasChanged = true;
                    return;
                }
            }
            if (homeTile.ticksExisted < 2) {
                return;
            }
        }
        if (!this.hasDest || !this.mustGoToDest && this.hasDest) {
            for (Route route : routes.outputRoutes) {
                if (!((DuctUnitItem)route.endPoint).isNode()) continue;
                for (side = 0; side < 6; side = (byte)(side + 1)) {
                    if (((DuctUnitItem)route.endPoint).canRouteItem(this.stack, side) == -1) continue;
                    this.myPath = route.copy();
                    this.myPath.pathDirections.add(side);
                    this.oldDirection = (byte)(this.direction ^ 1);
                    this.direction = this.myPath.getNextDirection();
                    homeTile.hasChanged = true;
                    this.hasDest = true;
                    this.destX = this.myPath.endPoint.x();
                    this.destY = this.myPath.endPoint.y();
                    this.destZ = this.myPath.endPoint.z();
                    return;
                }
            }
        }
        if (homeTile.ticksExisted <= 6) {
            return;
        }
        if (homeTile.acceptingStuff()) {
            byte d = homeTile.getStuffedSide();
            if (d == this.direction) {
                homeTile.stuffItem(this);
                homeTile.removeItem(this, true);
            } else {
                this.myPath = new Route(homeTile);
                this.myPath.pathDirections.add(this.myPath.endPoint.getStuffedSide());
                this.oldDirection = (byte)(this.direction ^ 1);
                this.direction = this.myPath.getNextDirection();
                homeTile.hasChanged = true;
            }
        } else {
            Route stuffedRoute = this.getStuffedRoute(routes);
            if (stuffedRoute != null) {
                this.goingToStuff = true;
                this.myPath = stuffedRoute;
                this.myPath.pathDirections.add(this.myPath.endPoint.getStuffedSide());
                this.oldDirection = (byte)(this.direction ^ 1);
                this.direction = this.myPath.getNextDirection();
                homeTile.hasChanged = true;
            } else if (homeTile.ticksExisted == 10) {
                CoreUtils.dropItemStackIntoWorld((ItemStack)this.stack, (World)homeTile.world(), (Vec3d)new Vec3d((Vec3i)homeTile.pos()));
                homeTile.removeItem(this, true);
            }
        }
    }

    public Route getStuffedRoute(RouteCache<?, ?> homeTile) {
        if (homeTile.stuffableRoutes.isEmpty()) {
            return null;
        }
        Route backup = null;
        for (Route route : homeTile.stuffableRoutes) {
            if (!route.endPoint.acceptingStuff()) continue;
            if (backup == null) {
                backup = route.copy();
            }
            if (route.endPoint.x() != this.startX || route.endPoint.y() != this.startY || route.endPoint.z() != this.startZ) continue;
            return route.copy();
        }
        return backup;
    }

    public void tickClientForward(DuctUnitItem homeTile) {
        this.progress = (byte)(this.progress + this.step);
        if (this.progress >= homeTile.getDuctLength()) {
            this.progress = (byte)(this.progress % homeTile.getDuctLength());
            if (this.shouldDie) {
                homeTile.removeItem(this, true);
            } else {
                DuctUnitItem itemDuct;
                homeTile.removeItem(this, false);
                this.shouldDie = true;
                TileEntity newTile = BlockHelper.getAdjacentTileEntity((TileEntity)homeTile.parent, (int)this.direction);
                if (newTile instanceof IDuctHolder && (itemDuct = ((IDuctHolder)newTile).getDuct(DuctToken.ITEMS)) != null) {
                    this.oldDirection = this.direction;
                    itemDuct.myItems.add(this);
                    if (!TickHandlerClient.tickBlocks.contains(itemDuct) && !TickHandlerClient.tickBlocksToAdd.contains(itemDuct)) {
                        TickHandlerClient.tickBlocksToAdd.add(itemDuct);
                    }
                }
            }
        }
    }

    public void writePacket(PacketBase myPayload) {
        myPayload.addByte(this.progress);
        myPayload.addByte(this.direction);
        myPayload.addByte(this.oldDirection);
        myPayload.addItemStack(this.stack);
        myPayload.addByte(this.step);
    }

    public void toNBT(NBTTagCompound theNBT) {
        theNBT.func_74782_a("stack", (NBTBase)new NBTTagCompound());
        this.stack.func_77955_b(theNBT.func_74775_l("stack"));
        theNBT.func_74774_a("progress", this.progress);
        theNBT.func_74774_a("direction", this.direction);
        theNBT.func_74774_a("oldDir", this.oldDirection);
        theNBT.func_74757_a("gts", this.goingToStuff);
        theNBT.func_74768_a("step", this.step);
        if (this.hasDest) {
            theNBT.func_74768_a("destX", this.destX);
            theNBT.func_74768_a("destY", this.destY);
            theNBT.func_74768_a("destZ", this.destZ);
            theNBT.func_74757_a("mustGo", this.mustGoToDest);
        }
        theNBT.func_74768_a("startX", this.startX);
        theNBT.func_74768_a("startY", this.startY);
        theNBT.func_74768_a("startZ", this.startZ);
        if (this.myPath != null) {
            theNBT.func_74773_a("route", this.myPath.toByteArray());
        }
    }

    public BlockPos getDest() {
        if (this.myPath == null) {
            return null;
        }
        if (this.myPath.dest == null) {
            if (this.myPath.endPoint == null) {
                if (!this.hasDest) {
                    return null;
                }
                this.myPath.dest = new BlockPos(this.destX, this.destY, this.destZ).func_177972_a(EnumFacing.field_82609_l[this.getLastSide()]);
            } else {
                this.myPath.dest = new BlockPos(this.myPath.endPoint.x(), this.myPath.endPoint.y(), this.myPath.endPoint.z()).func_177972_a(EnumFacing.field_82609_l[this.getLastSide()]);
            }
        }
        return this.myPath.dest;
    }

    public StackMap.ItemEntry getStackEntry() {
        if (this.stack.func_190926_b()) {
            return null;
        }
        if (this.stackItemEntry == null || this.stackItemEntry.side != this.getLastSide()) {
            this.stackItemEntry = new StackMap.ItemEntry(this.stack, this.getLastSide());
        }
        return this.stackItemEntry;
    }

    public int getLastSide() {
        return this.myPath.pathDirections.isEmpty() ? this.direction : this.myPath.getLastSide();
    }
}

