/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.sky;

import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.utils.Utils;
import java.util.Calendar;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public abstract class SkyProviderBase
extends IRenderHandler {
    private static final ResourceLocation sunTexture = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation lmcTexture = new ResourceLocation("asmodeuscore", "textures/environment/background/lmc.png");
    private static final ResourceLocation smcTexture = new ResourceLocation("asmodeuscore", "textures/environment/background/smc.png");
    private static final ResourceLocation andromedaTexture = new ResourceLocation("asmodeuscore", "textures/environment/background/andromeda.png");
    private static final ResourceLocation moonTexture = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation barnardaloopTexture = new ResourceLocation("asmodeuscore", "textures/environment/background/barnardaloop.png");
    public static final ResourceLocation pumpkinsunTexture = new ResourceLocation("asmodeuscore", "textures/environment/pumkinsun.png");
    private final ResourceLocation planetToRender = new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/earth.png");
    public int starList;
    public int glSkyList;
    public int glSkyList2;
    private float sunSize;
    protected float ticks;
    public float[] afloat = new float[4];
    protected Minecraft mc = Minecraft.func_71410_x();

    public SkyProviderBase() {
        int displayLists;
        this.starList = displayLists = GLAllocation.func_74526_a((int)3);
        this.glSkyList = displayLists + 1;
        this.glSkyList2 = displayLists + 2;
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starList, (int)4864);
        if (this.enableStar()) {
            this.renderStars();
        }
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte2 = 64;
        int i = 6;
        float f = 16.0f;
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        for (int j = -384; j <= 384; j += 64) {
            for (int l = -384; l <= 384; l += 64) {
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                worldRenderer.func_181662_b((double)(j + 0), (double)f, (double)(l + 0)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + 64), (double)f, (double)(l + 0)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + 64), (double)f, (double)(l + 64)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + 0), (double)f, (double)(l + 64)).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int i1 = -384; i1 <= 384; i1 += 64) {
                worldRenderer.func_181662_b((double)(k + 64), (double)f, (double)i1).func_181675_d();
                worldRenderer.func_181662_b((double)k, (double)f, (double)i1).func_181675_d();
                worldRenderer.func_181662_b((double)k, (double)f, (double)(i1 + 64)).func_181675_d();
                worldRenderer.func_181662_b((double)(k + 64), (double)f, (double)(i1 + 64)).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float f6;
        this.ticks = partialTicks;
        GL11.glDisable((int)3553);
        Vec3d vec3 = world.func_72833_a(mc.func_175606_aa(), partialTicks);
        float f1 = (float)vec3.field_72450_a;
        float f2 = (float)vec3.field_72448_b;
        float f3 = (float)vec3.field_72449_c;
        if (mc.field_71474_y.field_74337_g) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        Tessellator tessellator1 = Tessellator.func_178181_a();
        BufferBuilder worldRenderer1 = tessellator1.func_178180_c();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        float f9 = 0.0f;
        float f10 = 0.0f;
        float rain = 1.0f - world.func_72867_j(partialTicks);
        float f18 = world.func_72880_h(partialTicks) * rain;
        if (f18 > 0.0f && !this.mc.field_71439_g.func_70090_H()) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-19.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glColor4f((float)f18, (float)f18, (float)f18, (float)f18);
            GL11.glCallList((int)this.starList);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        this.afloat[0] = 1.0f;
        this.afloat[1] = 0.7607843f;
        this.afloat[2] = 0.7058824f;
        this.afloat[3] = 0.3f;
        if (this.colorSunAura() != null) {
            this.afloat[0] = (float)this.colorSunAura().intX() / 255.0f;
            this.afloat[1] = (float)this.colorSunAura().intY() / 255.0f;
            this.afloat[2] = (float)this.colorSunAura().intZ() / 255.0f;
        }
        f6 = this.afloat[0];
        float f7 = this.afloat[1];
        float f8 = this.afloat[2];
        if (mc.field_71474_y.field_74337_g) {
            f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
            f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
            float f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
            f6 = f9;
            f7 = f10;
            f8 = f11;
        }
        f18 = 1.0f - f18;
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(this.mc.field_71441_e.func_72826_c(this.ticks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        f10 = this.sunSize() + 5.5f;
        if (!this.mc.field_71439_g.func_70090_H()) {
            this.renderSunAura(tessellator1, f10 + (float)this.addSizeAura(), f18);
        }
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        GL11.glPushMatrix();
        f7 = 0.0f;
        f8 = 0.0f;
        f9 = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(partialTicks)));
        GL11.glTranslatef((float)f7, (float)f8, (float)f9);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.modeLight() != 2 && !this.mc.field_71439_g.func_70090_H()) {
            f10 = this.sunSize();
            Calendar calendar = Calendar.getInstance();
            if (calendar.get(2) + 1 == 10 && calendar.get(5) >= 30 && calendar.get(5) <= 31 || calendar.get(2) + 1 == 11 && calendar.get(5) <= 1) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(pumpkinsunTexture);
            } else if (this.sunImage() != null) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.sunImage());
            } else {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(sunTexture);
            }
            if (this.enableSmoothRender()) {
                GL11.glDisable((int)3042);
            }
            worldRenderer1.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer1.func_181662_b((double)(-f10), 99.9, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
            worldRenderer1.func_181662_b((double)f10, 99.9, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
            worldRenderer1.func_181662_b((double)f10, 99.9, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
            worldRenderer1.func_181662_b((double)(-f10), 99.9, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator1.func_78381_a();
            if (this.enableSmoothRender()) {
                GL11.glEnable((int)3042);
            }
        }
        if (this.enableBaseImages() && !this.mc.field_71439_g.func_70090_H()) {
            if (Minecraft.func_71410_x().field_71441_e.field_73011_w instanceof WorldProviderSurface) {
                f10 = 20.0f;
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(moonTexture);
                int k = Minecraft.func_71410_x().field_71441_e.func_72853_d();
                int l = k % 4;
                int i1 = k / 4 % 2;
                float f14 = (float)(l + 0) / 4.0f;
                float f15 = (float)(i1 + 0) / 2.0f;
                float f16 = (float)(l + 1) / 4.0f;
                float f17 = (float)(i1 + 1) / 2.0f;
                worldRenderer1.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer1.func_181662_b((double)(-f10), -100.0, (double)f10).func_187315_a((double)f16, (double)f17).func_181675_d();
                worldRenderer1.func_181662_b((double)f10, -100.0, (double)f10).func_187315_a((double)f14, (double)f17).func_181675_d();
                worldRenderer1.func_181662_b((double)f10, -100.0, (double)(-f10)).func_187315_a((double)f14, (double)f15).func_181675_d();
                worldRenderer1.func_181662_b((double)(-f10), -100.0, (double)(-f10)).func_187315_a((double)f16, (double)f15).func_181675_d();
                tessellator1.func_78381_a();
            }
            float light = 0.0f;
            if (this.modeLight() == 0) {
                light = FMLClientHandler.instance().getClient().field_71441_e.func_72880_h(1.0f) - Minecraft.func_71410_x().field_71441_e.func_72867_j(partialTicks);
            }
            if (this.modeLight() == 1) {
                light = 1.0f;
            }
            this.renderImage(lmcTexture, -90.0f, 90.0f, 0.0f, 15.0f, true, light);
            this.renderImage(smcTexture, 0.0f, -40.0f, 0.0f, 5.0f, true, light);
            this.renderImage(andromedaTexture, 100.0f, -150.0f, 0.0f, 4.0f, true, light);
            this.renderImage(barnardaloopTexture, 200.0f, -70.0f, 0.0f, 40.0f, true, light);
            GL11.glDisable((int)3042);
            this.rendererSky(tessellator1, worldRenderer1, f10, partialTicks);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        if ((float)mc.field_71439_g.field_70163_u > 200.0f && this.enableRenderPlanet()) {
            GL11.glEnable((int)3553);
            f10 = 120.0f;
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-360.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(-((float)mc.field_71439_g.field_70163_u) / 8.0f), (float)0.0f);
            if (!(mc.field_71441_e.field_73011_w instanceof WorldProviderSurface)) {
                mc.field_71446_o.func_110577_a(((IGalacticraftWorldProvider)mc.field_71441_e.field_73011_w).getCelestialBody().getBodyIcon());
            } else {
                mc.field_71446_o.func_110577_a(this.planetToRender);
            }
            worldRenderer1.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer1.func_181662_b((double)(-f10), -100.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
            worldRenderer1.func_181662_b((double)f10, -100.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
            worldRenderer1.func_181662_b((double)f10, -100.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
            worldRenderer1.func_181662_b((double)(-f10), -100.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator1.func_78381_a();
            this.renderAtmo(tessellator1, -360.0f, 0.0f, 115.0f, this.getAtmosphereColor());
        }
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = (double)mc.field_71439_g.func_180425_c().func_177956_o() - world.func_72919_O();
        if (world.field_73011_w.func_76561_g()) {
            GL11.glColor3f((float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.2f + 0.04f), (float)(f3 * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)f1, (float)f2, (float)f3);
        }
        GL11.glEnable((int)3553);
        GlStateManager.func_179091_B();
        GL11.glEnable((int)2903);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDepthMask((boolean)true);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
    }

    protected void renderImage(ResourceLocation image, float x, float y, float z, float f10, boolean withsun) {
        this.renderImage(image, x, y, z, f10, withsun, FMLClientHandler.instance().getClient().field_71441_e.func_72880_h(1.0f));
    }

    protected void renderImage(ResourceLocation image, float x, float y, float z, float f10, boolean withsun, float alpha) {
        GL11.glEnable((int)3042);
        if (!withsun) {
            GL11.glPopMatrix();
            GL11.glPushMatrix();
        }
        Tessellator tessellator1 = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator1.func_178180_c();
        GL11.glRotatef((float)x, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)y, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)z, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(image);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)(-f10), -100.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)f10, -100.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)f10, -100.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(-f10), -100.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator1.func_78381_a();
    }

    protected void renderAtmo(Tessellator tessellator1, float x, float y, float f10, Vector3 vec) {
        if (vec != null && AsmodeusConfig.enableRenderAtmosphere) {
            float f15;
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glRotatef((float)y, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)x, (float)1.0f, (float)0.0f, (float)0.0f);
            double planetOrbitalDistance = 5.0;
            double dist = -64.0 - 4.0 * planetOrbitalDistance / 2.0 - (double)((float)this.mc.field_71439_g.field_70163_u / (float)this.mc.field_71439_g.field_70163_u);
            double scalingMult = 1.0 - 0.9 * planetOrbitalDistance;
            float Xoffset = (float)((double)System.currentTimeMillis() / 1000000.0 % 1.0);
            float f14 = 1.0f + Xoffset;
            float f16 = f15 = 0.0f + Xoffset;
            float f17 = f14;
            float[] color = new float[]{vec.floatX(), vec.floatY(), vec.floatZ(), 0.09f};
            BufferBuilder worldRenderer = tessellator1.func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            for (int i = 0; i < 5; ++i) {
                SkyProviderBase.renderTestWithUV(worldRenderer, color, dist + (double)i * scalingMult, -f10, -f10, 0.0, 0.0, f14, f15, f16, f17);
                SkyProviderBase.renderTestWithUV(worldRenderer, color, dist + (double)i * scalingMult, 0.0, 0.0, f10, f10, f14, f15, f16, f17);
                SkyProviderBase.renderTestWithUV(worldRenderer, color, dist + (double)i * scalingMult, -f10, 0.0, 0.0, f10, f14, f15, f16, f17);
                SkyProviderBase.renderTestWithUV(worldRenderer, color, dist + (double)i * scalingMult, 0.0, -f10, f10, 0.0, f14, f15, f16, f17);
            }
            tessellator1.func_78381_a();
        }
    }

    public static void renderTestWithUV(BufferBuilder buff, float[] color, double yMax, double xMin, double zMin, double xMax, double zMax, double uMin, double uMax, double vMin, double vMax) {
        buff.func_181662_b(xMin, yMax, zMin).func_187315_a(uMin, vMin).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
        buff.func_181662_b(xMin, yMax, zMax).func_187315_a(uMin, vMax).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMax).func_187315_a(uMax, vMax).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
        buff.func_181662_b(xMax, yMax, zMin).func_187315_a(uMax, vMin).func_181666_a(color[0], color[1], color[2], color[3]).func_181675_d();
    }

    protected void renderSunAura(Tessellator tessellator1, float f10, float f18) {
        float f6;
        BufferBuilder worldRenderer = tessellator1.func_178180_c();
        Vec3d vec3 = this.mc.field_71441_e.func_72833_a(this.mc.func_175606_aa(), this.ticks);
        float f1 = (float)vec3.field_72450_a;
        float f2 = (float)vec3.field_72448_b;
        float f3 = (float)vec3.field_72449_c;
        float f9 = 0.0f;
        if (this.mc.field_71474_y.field_74337_g) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        this.afloat[0] = 1.0f;
        this.afloat[1] = 0.7607843f;
        this.afloat[2] = 0.7058824f;
        this.afloat[3] = 0.3f;
        if (this.colorSunAura() != null) {
            this.afloat[0] = (float)this.colorSunAura().intX() / 255.0f;
            this.afloat[1] = (float)this.colorSunAura().intY() / 255.0f;
            this.afloat[2] = (float)this.colorSunAura().intZ() / 255.0f;
        }
        f6 = this.afloat[0];
        float f7 = this.afloat[1];
        float f8 = this.afloat[2];
        if (this.mc.field_71474_y.field_74337_g) {
            f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
            f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
            float f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
            f6 = f9;
            f7 = f10;
            f8 = f11;
        }
        float r = f6 * f18;
        float g = f7 * f18;
        float b = f8 * f18;
        float a = this.afloat[3] * 2.0f / f18 - Minecraft.func_71410_x().field_71441_e.func_72867_j(this.ticks);
        if (this.modeLight() != 2) {
            worldRenderer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            worldRenderer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            int b0 = 16;
            r = this.afloat[0] * f18;
            g = this.afloat[1] * f18;
            b = this.afloat[2] * f18;
            a = 0.0f;
            worldRenderer.func_181662_b((double)(-f10), 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(0.0, 100.0, (double)(-f10) * 1.5).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)f10, 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)f10 * 1.5, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)f10, 100.0, (double)f10).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(0.0, 100.0, (double)f10 * 1.5).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-f10), 100.0, (double)f10).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-f10) * 1.5, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-f10), 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            tessellator1.func_78381_a();
        }
        if (this.enableSmoothRender()) {
            GL11.glLineWidth((float)2.0f);
            GL11.glPolygonMode((int)1032, (int)6913);
        }
        if (this.enableLargeSunAura()) {
            worldRenderer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            r = f6 * f18;
            g = f7 * f18;
            b = f8 * f18;
            a = this.enableSmoothRender() ? this.afloat[3] * 2.0f / f18 - Minecraft.func_71410_x().field_71441_e.func_72867_j(this.ticks) : this.afloat[3] * f18;
            worldRenderer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            r = this.afloat[0] * f18;
            g = this.afloat[1] * f18;
            b = this.afloat[2] * f18;
            a = 0.0f;
            f10 += 10.0f;
            int i = this.enableSmoothRender() ? 8 : 0;
            worldRenderer.func_181662_b((double)(-(f10 += (float)i)), 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(0.0, 100.0, (double)(-f10) * 1.5).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(f10 -= (float)(i + i)), 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)f10 * 1.5, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(f10 += (float)i), 100.0, (double)f10).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(0.0, 100.0, (double)f10 * 1.5).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-(f10 -= (float)i)), 100.0, (double)f10).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-f10) * 1.5, 100.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b((double)(-f10), 100.0, (double)(-f10)).func_181666_a(r, g, b, a).func_181675_d();
            tessellator1.func_78381_a();
        }
        GL11.glPolygonMode((int)1032, (int)6914);
    }

    private void renderStars() {
        Random rand = new Random(10842L);
        Tessellator var2 = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = var2.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int starIndex = 0; starIndex < (ConfigManagerCore.moreStars ? 48000 : 6000); ++starIndex) {
            double var4 = rand.nextFloat() * 2.0f - 1.0f;
            double var6 = rand.nextFloat() * 2.0f - 1.0f;
            double var8 = rand.nextFloat() * 2.0f - 1.0f;
            double var10 = 0.15f + rand.nextFloat() * 0.1f;
            double var12 = var4 * var4 + var6 * var6 + var8 * var8;
            if (!(var12 < 1.0) || !(var12 > 0.01)) continue;
            var12 = 1.0 / Math.sqrt(var12);
            double var14 = (var4 *= var12) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 150.0 + 130.0 : 100.0);
            double var16 = (var6 *= var12) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 150.0 + 130.0 : 100.0);
            double var18 = (var8 *= var12) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 150.0 + 130.0 : 100.0);
            double var20 = Math.atan2(var4, var8);
            double var22 = Math.sin(var20);
            double var24 = Math.cos(var20);
            double var26 = Math.atan2(Math.sqrt(var4 * var4 + var8 * var8), var6);
            double var28 = Math.sin(var26);
            double var30 = Math.cos(var26);
            double var32 = rand.nextDouble() * Math.PI * 2.0;
            double var34 = Math.sin(var32);
            double var36 = Math.cos(var32);
            for (int var38 = 0; var38 < 4; ++var38) {
                double var39 = 0.0;
                double var41 = (double)((var38 & 2) - 1) * var10;
                double var43 = (double)((var38 + 1 & 2) - 1) * var10;
                double var47 = var41 * var36 - var43 * var34;
                double var49 = var43 * var36 + var41 * var34;
                double var53 = var47 * var28 + 0.0 * var30;
                double var55 = 0.0 * var28 - var47 * var30;
                double var57 = var55 * var22 - var49 * var24;
                double var61 = var49 * var22 + var55 * var24;
                worldRenderer.func_181662_b(var14 + var57, var16 + var53, var18 + var61).func_181675_d();
            }
        }
        var2.func_78381_a();
    }

    private Vec3d getCustomSkyColor() {
        return new Vec3d(0.26796875, 0.1796875, 0.0);
    }

    public float getSkyBrightness(float par1) {
        float var2 = FMLClientHandler.instance().getClient().field_71441_e.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76126_a((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 1.0f;
    }

    protected abstract void rendererSky(Tessellator var1, BufferBuilder var2, float var3, float var4);

    protected abstract int modeLight();

    protected abstract boolean enableBaseImages();

    protected abstract float sunSize();

    protected abstract ResourceLocation sunImage();

    protected abstract boolean enableStar();

    protected abstract Vector3 colorSunAura();

    protected abstract Vector3 getAtmosphereColor();

    public boolean enableLargeSunAura() {
        return true;
    }

    public boolean enableSmoothRender() {
        return false;
    }

    public boolean enableRenderPlanet() {
        return true;
    }

    public int addSizeAura() {
        return 0;
    }

    protected float getCelestialAngle(long daylength) {
        return Utils.calculateCelestialAngle(this.mc.field_71441_e.func_72820_D(), this.ticks, (int)daylength) * 360.0f;
    }
}

