/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.machinemuse.numina.utils.MuseLogger;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.powersuits.client.model.obj.OBJModelPlus;
import net.machinemuse.powersuits.client.render.modelspec.EnumSpecType;
import net.machinemuse.powersuits.client.render.modelspec.ModelPartSpec;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.machinemuse.powersuits.client.render.modelspec.MorphTarget;
import net.machinemuse.powersuits.client.render.modelspec.SpecBinding;
import net.machinemuse.powersuits.client.render.modelspec.TexturePartSpec;
import net.machinemuse.powersuits.client.render.modelspec.TextureSpec;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.utils.MuseStringUtils;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@SideOnly(value=Side.CLIENT)
public enum ModelSpecXMLReader {
    INSTANCE;


    public static void parseFile(URL file, @Nullable TextureStitchEvent event) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            InputSource x = new InputSource(file.openStream());
            Document xml = dBuilder.parse(new InputSource(file.openStream()));
            ModelSpecXMLReader.parseXML(xml, event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void parseFile(File file, @Nullable TextureStitchEvent event) {
        if (file.exists()) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = null;
                dBuilder = dbFactory.newDocumentBuilder();
                Document xml = dBuilder.parse(file);
                ModelSpecXMLReader.parseXML(xml, event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void parseXML(Document xml, @Nullable TextureStitchEvent event) {
        if (xml != null) {
            try {
                xml.normalizeDocument();
                if (xml.hasChildNodes()) {
                    NodeList specList = xml.getElementsByTagName("modelSpec");
                    block7: for (int i = 0; i < specList.getLength(); ++i) {
                        Node specNode = specList.item(i);
                        if (specNode.getNodeType() != 1) continue;
                        Element eElement = (Element)specNode;
                        EnumSpecType specType = EnumSpecType.getTypeFromName(eElement.getAttribute("type"));
                        String specName = eElement.getAttribute("specName");
                        boolean isDefault = eElement.hasAttribute("default") ? Boolean.parseBoolean(eElement.getAttribute("default")) : false;
                        switch (specType) {
                            case POWER_FIST: {
                                ModelSpecXMLReader.parseModelSpec(specNode, event, EnumSpecType.POWER_FIST, specName, isDefault);
                                continue block7;
                            }
                            case ARMOR_MODEL: {
                                if (!MPSConfig.INSTANCE.allowHighPollyArmorModels()) continue block7;
                                ModelSpecXMLReader.parseModelSpec(specNode, event, EnumSpecType.ARMOR_MODEL, specName, isDefault);
                                continue block7;
                            }
                            case ARMOR_SKIN: {
                                if (event != null) continue block7;
                                TextureSpec textureSpec = new TextureSpec(specName, isDefault);
                                ModelSpecXMLReader.parseTextureSpec(specNode, textureSpec);
                                continue block7;
                            }
                        }
                    }
                } else {
                    System.out.println("XML reader: document has no nodes!!!!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void parseTextureSpec(Node specNode, TextureSpec textureSpec) {
        TextureSpec existingspec = ModelRegistry.getInstance().put(textureSpec.getName(), textureSpec);
        NodeList textures = specNode.getOwnerDocument().getElementsByTagName("texture");
        for (int i = 0; i < textures.getLength(); ++i) {
            Node textureNode = textures.item(i);
            if (textureNode.getNodeType() != 1) continue;
            Element eElement = (Element)textureNode;
            String fileLocation = eElement.getAttribute("file");
            NodeList bindings = eElement.getElementsByTagName("binding");
            for (int j = 0; j < bindings.getLength(); ++j) {
                SpecBinding binding = ModelSpecXMLReader.getBinding(bindings.item(j));
                ModelSpecXMLReader.getTexturePartSpec(existingspec, bindings.item(j), binding.getSlot(), fileLocation);
            }
        }
    }

    public static void parseModelSpec(Node specNode, TextureStitchEvent event, EnumSpecType specType, String specName, boolean isDefault) {
        NodeList models = specNode.getOwnerDocument().getElementsByTagName("model");
        ArrayList<String> textures = new ArrayList<String>();
        IModelState modelState = null;
        for (int i = 0; i < models.getLength(); ++i) {
            Node modelNode = models.item(i);
            if (modelNode.getNodeType() != 1) continue;
            Element modelElement = (Element)modelNode;
            if (event != null) {
                List<String> tempTextures = Arrays.asList(modelElement.getAttribute("textures").split(","));
                for (String texture : tempTextures) {
                    if (textures.contains(texture)) continue;
                    textures.add(texture);
                }
                continue;
            }
            String modelLocation = modelElement.getAttribute("file");
            NodeList cameraTransformList = modelElement.getElementsByTagName("itemCameraTransforms");
            if (cameraTransformList.getLength() > 0) {
                Node cameraTransformNode = cameraTransformList.item(0);
                modelState = ModelSpecXMLReader.getIModelState(cameraTransformNode);
            } else {
                NodeList transformNodeList = modelElement.getElementsByTagName("trsrTransformation");
                modelState = transformNodeList.getLength() > 0 ? ModelSpecXMLReader.getTransform(transformNodeList.item(0)) : TRSRTransformation.identity();
            }
            OBJModelPlus.OBJBakedModelPus bakedModel = ModelRegistry.getInstance().loadBakedModel(new ResourceLocation(modelLocation), modelState);
            if (bakedModel != null && bakedModel instanceof OBJModelPlus.OBJBakedModelPus) {
                ModelSpec modelspec = new ModelSpec(bakedModel, modelState, specName, isDefault, specType);
                NodeList bindingNodeList = ((Element)modelNode).getElementsByTagName("binding");
                if (bindingNodeList.getLength() > 0) {
                    for (int k = 0; k < bindingNodeList.getLength(); ++k) {
                        Node bindingNode = bindingNodeList.item(k);
                        SpecBinding binding = ModelSpecXMLReader.getBinding(bindingNode);
                        NodeList partNodeList = ((Element)bindingNode).getElementsByTagName("part");
                        for (int j = 0; j < partNodeList.getLength(); ++j) {
                            ModelSpecXMLReader.getModelPartSpec(modelspec, partNodeList.item(j), binding);
                        }
                    }
                }
                ModelRegistry.getInstance().put(MuseStringUtils.extractName(modelLocation), modelspec);
                continue;
            }
            MuseLogger.logError("Model file " + modelLocation + " not found! D:");
        }
        if (event != null) {
            for (String texture : textures) {
                event.getMap().func_174942_a(new ResourceLocation(texture));
            }
        }
    }

    public static void getTexturePartSpec(TextureSpec textureSpec, Node bindingNode, EntityEquipmentSlot slot, String fileLocation) {
        Colour colour;
        Element partSpecElement = (Element)bindingNode;
        Colour colour2 = colour = partSpecElement.hasAttribute("defaultColor") ? ModelSpecXMLReader.parseColour(partSpecElement.getAttribute("defaultColor")) : Colour.WHITE;
        if (colour.a == 0.0) {
            colour = colour.withAlpha(1.0);
        }
        if (!Objects.equals(slot, null) && Objects.equals(slot.func_188453_a(), EntityEquipmentSlot.Type.ARMOR)) {
            textureSpec.put(slot.func_188450_d(), new TexturePartSpec(textureSpec, new SpecBinding(null, slot, "all"), textureSpec.addColourIfNotExist(colour), slot.func_188450_d(), fileLocation));
        }
    }

    public static void getModelPartSpec(ModelSpec modelSpec, Node partSpecNode, SpecBinding binding) {
        Colour colour;
        Element partSpecElement = (Element)partSpecNode;
        String partname = ModelSpecXMLReader.validatePolygroup(partSpecElement.getAttribute("partName"), modelSpec);
        boolean glow = Boolean.parseBoolean(partSpecElement.getAttribute("defaultglow"));
        Colour colour2 = colour = partSpecElement.hasAttribute("defaultColor") ? ModelSpecXMLReader.parseColour(partSpecElement.getAttribute("defaultColor")) : Colour.WHITE;
        if (colour.a == 0.0) {
            colour = colour.withAlpha(1.0);
        }
        if (partname == null) {
            System.out.println("partName is NULL!!");
            System.out.println("ModelSpec model: " + modelSpec.getName());
            System.out.println("glow: " + glow);
            System.out.println("colour: " + colour.hexColour());
        } else {
            modelSpec.put(partname, new ModelPartSpec(modelSpec, binding, partname, modelSpec.addColourIfNotExist(colour), glow));
        }
    }

    @Nullable
    public static String validatePolygroup(String s, ModelSpec m) {
        return m.getModel().getModel().getMatLib().getGroups().keySet().contains(s) ? s : null;
    }

    public static IModelState getIModelState(Node itemCameraTransformsNode) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        NodeList transformationList = ((Element)itemCameraTransformsNode).getElementsByTagName("trsrTransformation");
        for (int i = 0; i < transformationList.getLength(); ++i) {
            Node transformationNode = transformationList.item(i);
            ItemCameraTransforms.TransformType transformType = ItemCameraTransforms.TransformType.valueOf((String)((Element)transformationNode).getAttribute("type").toUpperCase());
            TRSRTransformation trsrTransformation = ModelSpecXMLReader.getTransform(transformationNode);
            builder.put((Object)transformType, (Object)trsrTransformation);
        }
        return new SimpleModelState(builder.build());
    }

    public static TRSRTransformation getTransform(Node transformationNode) {
        Vector3f translation = ModelSpecXMLReader.parseVector(((Element)transformationNode).getAttribute("translation"));
        Vector3f rotation = ModelSpecXMLReader.parseVector(((Element)transformationNode).getAttribute("rotation"));
        Vector3f scale = ModelSpecXMLReader.parseVector(((Element)transformationNode).getAttribute("scale"));
        return ModelSpecXMLReader.getTransform(translation, rotation, scale);
    }

    public static SpecBinding getBinding(Node bindingNode) {
        return new SpecBinding(((Element)bindingNode).hasAttribute("target") ? MorphTarget.getMorph(((Element)bindingNode).getAttribute("target")) : null, ((Element)bindingNode).hasAttribute("slot") ? EntityEquipmentSlot.func_188451_a((String)((Element)bindingNode).getAttribute("slot").toLowerCase()) : null, ((Element)bindingNode).hasAttribute("itemState") ? ((Element)bindingNode).getAttribute("itemState") : "all");
    }

    public static TRSRTransformation getTransform(@Nullable Vector3f translation, @Nullable Vector3f rotation, @Nullable Vector3f scale) {
        if (translation == null) {
            translation = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if (rotation == null) {
            rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if (scale == null) {
            scale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        return new TRSRTransformation(new Vector3f(translation.x / 16.0f, translation.y / 16.0f, translation.z / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)rotation), scale, null);
    }

    @Nullable
    public static Vector3f parseVector(String s) {
        try {
            String[] ss = s.split(",");
            float x = Float.parseFloat(ss[0]);
            float y = Float.parseFloat(ss[1]);
            float z = Float.parseFloat(ss[2]);
            return new Vector3f(x, y, z);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Colour parseColour(String colourString) {
        return Colour.fromHexString(colourString);
    }
}

