/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.control;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.utils.MuseLogger;
import net.machinemuse.numina.utils.math.geometry.MusePoint2D;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.control.KeyBindingHelper;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableKeybinding;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.input.Keyboard;

public enum KeybindManager {
    INSTANCE;

    private static KeyBindingHelper keyBindingHelper;
    protected final Set<ClickableKeybinding> keybindings = new HashSet<ClickableKeybinding>();

    public static Set<ClickableKeybinding> getKeybindings() {
        return KeybindManager.INSTANCE.keybindings;
    }

    public static KeyBinding addKeybinding(String keybindDescription, int keycode, MusePoint2D position) {
        KeyBinding kb = new KeyBinding(keybindDescription, keycode, "Modular Powersuits");
        boolean free = !keyBindingHelper.keyBindingHasKey(keycode);
        KeybindManager.INSTANCE.keybindings.add(new ClickableKeybinding(kb, position, free, false));
        return kb;
    }

    public static String parseName(KeyBinding keybind) {
        if (keybind.func_151463_i() < 0) {
            return "Mouse" + (keybind.func_151463_i() + 100);
        }
        return Keyboard.getKeyName((int)keybind.func_151463_i());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOutKeybinds() {
        BufferedWriter writer = null;
        try {
            File file = new File(Loader.instance().getConfigDir() + "/machinemuse/", "powersuits-keybinds.cfg");
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new BufferedWriter(new FileWriter(file));
            List<IPowerModule> modulesToWrite = ModuleManager.INSTANCE.getPlayerInstalledModules((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            for (ClickableKeybinding keybinding : KeybindManager.INSTANCE.keybindings) {
                writer.write(keybinding.getKeyBinding().func_151463_i() + ":" + keybinding.getPosition().getX() + ':' + keybinding.getPosition().getY() + ':' + keybinding.displayOnHUD + ':' + keybinding.toggleval + '\n');
                for (ClickableModule module : keybinding.getBoundModules()) {
                    writer.write(module.getModule().getDataName() + '~' + module.getPosition().getX() + '~' + module.getPosition().getY() + '\n');
                }
            }
        }
        catch (Exception e) {
            MuseLogger.logError("Problem writing out keyconfig :(");
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void readInKeybinds() {
        try {
            File file = new File(Loader.instance().getConfigDir() + "/machinemuse/", "powersuits-keybinds.cfg");
            if (!file.exists()) {
                MuseLogger.logError("No powersuits keybind file found.");
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ClickableKeybinding workingKeybinding = null;
            while (reader.ready()) {
                String[] exploded;
                String line = reader.readLine();
                if (line.contains(":")) {
                    exploded = line.split(":");
                    int id = Integer.parseInt(exploded[0]);
                    if (!keyBindingHelper.keyBindingHasKey(id)) {
                        MusePoint2D position = new MusePoint2D(Double.parseDouble(exploded[1]), Double.parseDouble(exploded[2]));
                        boolean free = !keyBindingHelper.keyBindingHasKey(id);
                        boolean displayOnHUD = false;
                        boolean toggleval = false;
                        if (exploded.length > 3) {
                            displayOnHUD = Boolean.parseBoolean(exploded[3]);
                        }
                        if (exploded.length > 4) {
                            toggleval = Boolean.parseBoolean(exploded[4]);
                        }
                        workingKeybinding = new ClickableKeybinding(new KeyBinding(Keyboard.getKeyName((int)id), id, "Modular Powersuits"), position, free, displayOnHUD);
                        workingKeybinding.toggleval = toggleval;
                        KeybindManager.INSTANCE.keybindings.add(workingKeybinding);
                        continue;
                    }
                    workingKeybinding = null;
                    continue;
                }
                if (!line.contains("~") || workingKeybinding == null) continue;
                exploded = line.split("~");
                MusePoint2D position = new MusePoint2D(Double.parseDouble(exploded[1]), Double.parseDouble(exploded[2]));
                IPowerModule module = ModuleManager.INSTANCE.getModule(exploded[0]);
                if (module == null) continue;
                ClickableModule cmodule = new ClickableModule(module, position);
                workingKeybinding.bindModule(cmodule);
            }
            reader.close();
        }
        catch (Exception e) {
            MuseLogger.logError("Problem reading in keyconfig :(");
            e.printStackTrace();
        }
    }

    static {
        keyBindingHelper = new KeyBindingHelper();
    }
}

