/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.frame;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.machinemuse.numina.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.numina.nbt.IPropertyModifier;
import net.machinemuse.numina.nbt.PropertyModifierLinearAdditiveDouble;
import net.machinemuse.numina.utils.math.Colour;
import net.machinemuse.numina.utils.math.geometry.MusePoint2D;
import net.machinemuse.numina.utils.nbt.MuseNBTUtils;
import net.machinemuse.numina.utils.render.MuseRenderer;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableItem;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableTinkerSlider;
import net.machinemuse.powersuits.gui.tinker.frame.ItemSelectionFrame;
import net.machinemuse.powersuits.gui.tinker.frame.ModuleSelectionFrame;
import net.machinemuse.powersuits.network.MPSPackets;
import net.machinemuse.powersuits.network.packets.MusePacketTweakRequestDouble;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.utils.MuseStringUtils;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class ModuleTweakFrame
extends ScrollableFrame {
    protected static double SCALERATIO = 0.75;
    protected static int margin = 4;
    protected ItemSelectionFrame itemTarget;
    protected ModuleSelectionFrame moduleTarget;
    protected List<ClickableTinkerSlider> sliders;
    protected Map<String, Double> propertyStrings;
    protected ClickableTinkerSlider selectedSlider;
    protected EntityPlayerSP player;

    public ModuleTweakFrame(EntityPlayerSP player, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame itemTarget, ModuleSelectionFrame moduleTarget) {
        super(topleft.times(1.0 / SCALERATIO), bottomright.times(1.0 / SCALERATIO), borderColour, insideColour);
        this.itemTarget = itemTarget;
        this.moduleTarget = moduleTarget;
        this.player = player;
    }

    @Override
    public void update(double mousex, double mousey) {
        mousex /= SCALERATIO;
        if (this.itemTarget.getSelectedItem() != null && this.moduleTarget.getSelectedModule() != null) {
            ItemStack stack = this.itemTarget.getSelectedItem().getItem();
            IPowerModule module = this.moduleTarget.getSelectedModule().getModule();
            if (ModuleManager.INSTANCE.itemHasModule(this.itemTarget.getSelectedItem().getItem(), this.moduleTarget.getSelectedModule().getModule().getDataName())) {
                this.loadTweaks(stack, module);
            } else {
                this.sliders = null;
                this.propertyStrings = null;
            }
        } else {
            this.sliders = null;
            this.propertyStrings = null;
        }
        if (this.selectedSlider != null) {
            this.selectedSlider.setValueByX(mousex);
        }
    }

    @Override
    public void draw() {
        if (this.sliders != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)SCALERATIO, (double)SCALERATIO, (double)SCALERATIO);
            super.draw();
            MuseRenderer.drawCenteredString("Tinker", (this.border.left() + this.border.right()) / 2.0, this.border.top() + 2.0);
            for (ClickableTinkerSlider slider : this.sliders) {
                slider.draw();
            }
            int nexty = (int)((double)(this.sliders.size() * 20) + this.border.top() + 23.0);
            for (Map.Entry<String, Double> property : this.propertyStrings.entrySet()) {
                String formattedValue = MuseStringUtils.formatNumberFromUnits(property.getValue(), PowerModuleBase.getUnit(property.getKey()));
                String name = property.getKey();
                double valueWidth = MuseRenderer.getStringWidth(formattedValue);
                double allowedNameWidth = this.border.width() - valueWidth - (double)(margin * 2);
                List<String> namesList = MuseStringUtils.wrapStringToVisualLength(I18n.func_135052_a((String)("powersuits.tradeoff." + name), (Object[])new Object[0]), allowedNameWidth);
                for (int i = 0; i < namesList.size(); ++i) {
                    MuseRenderer.drawString(namesList.get(i), this.border.left() + (double)margin, nexty + 9 * i);
                }
                MuseRenderer.drawRightAlignedString(formattedValue, this.border.right() - (double)margin, nexty + 9 * (namesList.size() - 1) / 2);
                nexty += 9 * namesList.size() + 1;
            }
            GL11.glPopMatrix();
        }
    }

    private void loadTweaks(ItemStack stack, IPowerModule module) {
        NBTTagCompound itemTag = MuseNBTUtils.getMuseItemTag(stack);
        NBTTagCompound moduleTag = itemTag.func_74775_l(module.getDataName());
        this.propertyStrings = new HashMap<String, Double>();
        HashSet<String> tweaks = new HashSet<String>();
        Map<String, List<IPropertyModifier>> propertyModifiers = module.getPropertyModifiers();
        for (Map.Entry<String, List<IPropertyModifier>> property : propertyModifiers.entrySet()) {
            double currValue = 0.0;
            for (IPropertyModifier modifier : property.getValue()) {
                currValue = (Double)modifier.applyModifier(moduleTag, currValue);
                if (!(modifier instanceof PropertyModifierLinearAdditiveDouble)) continue;
                tweaks.add(((PropertyModifierLinearAdditiveDouble)modifier).getTradeoffName());
            }
            this.propertyStrings.put(property.getKey(), currValue);
        }
        this.sliders = new LinkedList<ClickableTinkerSlider>();
        int y = 0;
        for (String tweak : tweaks) {
            MusePoint2D center = new MusePoint2D((this.border.left() + this.border.right()) / 2.0, this.border.top() + (double)(y += 20));
            ClickableTinkerSlider slider = new ClickableTinkerSlider(center, this.border.right() - this.border.left() - 8.0, moduleTag, tweak, I18n.func_135052_a((String)("powersuits.tradeoff." + tweak), (Object[])new Object[0]));
            this.sliders.add(slider);
            if (this.selectedSlider == null || !slider.hitBox(center.getX(), center.getY())) continue;
            this.selectedSlider = slider;
        }
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
        x /= SCALERATIO;
        y /= SCALERATIO;
        if (button == 0 && this.sliders != null) {
            for (ClickableTinkerSlider slider : this.sliders) {
                if (!slider.hitBox(x, y)) continue;
                this.selectedSlider = slider;
            }
        }
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
        if (this.selectedSlider != null && this.itemTarget.getSelectedItem() != null && this.moduleTarget.getSelectedModule() != null) {
            ClickableItem item = this.itemTarget.getSelectedItem();
            IPowerModule module = this.moduleTarget.getSelectedModule().getModule();
            MPSPackets.sendToServer(new MusePacketTweakRequestDouble((EntityPlayer)this.player, item.inventorySlot, module.getDataName(), this.selectedSlider.id(), this.selectedSlider.getValue()));
        }
        if (button == 0) {
            this.selectedSlider = null;
        }
    }
}

