/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.energy_generation;

import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IToggleableModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class KineticGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public KineticGeneratorModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 2));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
        this.addBasePropertyDouble("energyPerBlock", 2000.0);
        this.addTradeoffPropertyDouble("energyGenerated", "energyPerBlock", 6000.0, "RF");
        this.addBasePropertyDouble("movementResistance", 0.0);
        this.addTradeoffPropertyDouble("energyGenerated", "movementResistance", 0.5, "%");
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_ENERGY_GENERATION;
    }

    @Override
    public String getDataName() {
        return "kineticGenerator";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (ElectricItemUtils.getPlayerEnergy(player) < ElectricItemUtils.getMaxPlayerEnergy(player)) {
            double movementResistance = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "movementResistance");
            if (movementResistance > 0.0) {
                player.field_70159_w *= movementResistance;
                player.field_70179_y *= movementResistance;
            }
            if (!(player.field_70170_p.field_72995_K || player.field_70170_p.func_82737_E() % 20L != 0L || !player.field_70122_E || player.field_71075_bZ.field_75100_b || player.func_184218_aH() || player.func_184613_cA() || player.func_70090_H())) {
                double distance = player.field_70140_Q - player.field_70141_P;
                ElectricItemUtils.givePlayerEnergy(player, (int)(distance * 10.0 * ModuleManager.INSTANCE.getOrSetModularPropertyDouble(item, "energyPerBlock")));
            }
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.kineticGenerator;
    }
}

