/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.common.capabilities.CapabilityScanResultProvider;
import li.cil.scannable.common.config.Constants;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.init.Items;
import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.numina.utils.energy.ElectricItemUtils;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.numina.utils.math.MuseMathUtils;
import net.machinemuse.powersuits.capabilities.ItemHandlerPowerFist;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModularPowersuits;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class OreScannerModule
extends PowerModuleBase
implements IRightClickModule,
IPlayerTickModule {
    static final ResourceLocation scannerCharge = new ResourceLocation("scannable", "scanner_charge");
    static final ResourceLocation scanner_activate = new ResourceLocation("scannable", "scanner_activate");
    ItemStack scanner = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("scannable", "scanner")));

    public OreScannerModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), this.scanner);
    }

    private static boolean tryConsumeEnergy(EntityPlayer player, List<ItemStack> modules, boolean simulate) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int playerEnergy = ElectricItemUtils.getPlayerEnergy(player);
        if (playerEnergy == 0) {
            return false;
        }
        int totalCost = 0;
        for (ItemStack module : modules) {
            totalCost += OreScannerModule.getModuleEnergyCost(player, module);
        }
        if (playerEnergy > totalCost) {
            if (!simulate) {
                ElectricItemUtils.drainPlayerEnergy(player, totalCost);
            }
            return true;
        }
        return false;
    }

    static int getModuleEnergyCost(EntityPlayer player, ItemStack module) {
        ScanResultProvider provider = (ScanResultProvider)module.getCapability(CapabilityScanResultProvider.SCAN_RESULT_PROVIDER_CAPABILITY, null);
        if (provider != null) {
            return provider.getEnergyCost(player, module);
        }
        if (Items.isModuleRange((ItemStack)module)) {
            return Settings.getEnergyCostModuleRange();
        }
        return 0;
    }

    private static boolean collectModules(ItemStack stack, List<ItemStack> modules) {
        boolean hasProvider = false;
        IItemHandler itemHandler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        assert (itemHandler instanceof ItemHandlerPowerFist);
        IItemHandler activeModules = ((ItemHandlerPowerFist)itemHandler).getActiveModules();
        for (int slot = 0; slot < activeModules.getSlots(); ++slot) {
            ItemStack module = activeModules.getStackInSlot(slot);
            if (module.func_190926_b()) continue;
            modules.add(module);
            if (!module.hasCapability(CapabilityScanResultProvider.SCAN_RESULT_PROVIDER_CAPABILITY, null)) continue;
            hasProvider = true;
        }
        return hasProvider;
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_TOOL;
    }

    @Override
    public String getDataName() {
        return "oreScanner";
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        try {
            if (!this.scanner.func_190926_b()) {
                return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(this.scanner).func_177554_e();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MuseIcon.oreScanner;
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    @Override
    public ActionResult onItemRightClick(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            playerIn.openGui((Object)ModularPowersuits.getInstance(), 6, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        ArrayList<ItemStack> modules = new ArrayList<ItemStack>();
        if (!OreScannerModule.collectModules(itemStackIn, modules)) {
            if (worldIn.field_72995_K) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TextComponentTranslation("message.scannable.no_scan_modules", new Object[0]), Constants.CHAT_LINE_ID);
            }
            playerIn.func_184811_cZ().func_185145_a(itemStackIn.func_77973_b(), 10);
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        if (!OreScannerModule.tryConsumeEnergy(playerIn, modules, true)) {
            if (worldIn.field_72995_K) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TextComponentTranslation("message.scannable.not_enough_energy", new Object[0]), Constants.CHAT_LINE_ID);
            }
            playerIn.func_184811_cZ().func_185145_a(itemStackIn.func_77973_b(), 10);
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        playerIn.func_184598_c(hand);
        if (worldIn.field_72995_K) {
            ScanManager.INSTANCE.beginScan(playerIn, modules);
            Musique.playerSound(playerIn, scannerCharge, SoundCategory.PLAYERS, 2.0f, Float.valueOf(1.0f), (Boolean)false);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        ArrayList<ItemStack> modules;
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        int chargeTicks = (int)MuseMathUtils.clampDouble(itemStack.func_77988_m() - timeLeft, 10.0, 40.0);
        if (worldIn.field_72995_K) {
            Musique.stopPlayerSound(player, scannerCharge);
            if (chargeTicks < 40) {
                ScanManager.INSTANCE.cancelScan();
            }
        }
        if (!OreScannerModule.collectModules(itemStack, modules = new ArrayList<ItemStack>())) {
            return;
        }
        if (worldIn.field_72995_K && chargeTicks == 40) {
            if (OreScannerModule.tryConsumeEnergy((EntityPlayer)entityLiving, modules, false)) {
                ScanManager.INSTANCE.updateScan((Entity)entityLiving, true);
                Musique.playerSound((EntityPlayer)entityLiving, scanner_activate, SoundCategory.PLAYERS, 1.0f, Float.valueOf(1.0f), (Boolean)false);
            } else {
                ScanManager.INSTANCE.cancelScan();
            }
        }
        player.func_184811_cZ().func_185145_a(itemStack.func_77973_b(), chargeTicks);
    }

    @Override
    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return 0;
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (player.func_130014_f_().field_72995_K) {
            ScanManager.INSTANCE.updateScan((Entity)player, false);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }
}

