/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.network.messages;

import io.netty.buffer.ByteBuf;
import lumien.randomthings.container.ContainerVoxelProjector;
import lumien.randomthings.network.IRTMessage;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.tileentity.TileEntityVoxelProjector;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageVoxelProjector
implements IRTMessage {
    BlockPos pos;
    VALUE value;
    int newModelRotation;
    String newModel;
    int newScale;
    int newRotationSpeed;
    boolean newAmbientLight;
    boolean newRandomize;

    public MessageVoxelProjector() {
    }

    public MessageVoxelProjector(BlockPos pos) {
        this.pos = pos;
    }

    public void setModel(String newModel) {
        this.value = VALUE.MODEL;
        this.newModel = newModel;
    }

    public void setModelRotation(int newModelRotation) {
        this.value = VALUE.MODEL_ROTATION;
        this.newModelRotation = newModelRotation;
    }

    public void fromBytes(ByteBuf buf) {
        this.value = VALUE.values()[buf.readInt()];
        this.pos = MessageUtil.readBlockPos(buf);
        switch (this.value) {
            case MODEL_ROTATION: {
                this.newModelRotation = buf.readInt();
                break;
            }
            case MODEL: {
                this.newModel = ByteBufUtils.readUTF8String((ByteBuf)buf);
                break;
            }
            case SCALE: {
                this.newScale = buf.readInt();
                break;
            }
            case ROTATION_SPEED: {
                this.newRotationSpeed = buf.readInt();
                break;
            }
            case AMBIENT_LIGHT: {
                this.newAmbientLight = buf.readBoolean();
                break;
            }
            case RANDOMIZE: {
                this.newRandomize = buf.readBoolean();
                break;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.value.ordinal());
        MessageUtil.writeBlockPos(this.pos, buf);
        switch (this.value) {
            case MODEL_ROTATION: {
                buf.writeInt(this.newModelRotation);
                break;
            }
            case MODEL: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.newModel);
                break;
            }
            case SCALE: {
                buf.writeInt(this.newScale);
                break;
            }
            case ROTATION_SPEED: {
                buf.writeInt(this.newRotationSpeed);
                break;
            }
            case AMBIENT_LIGHT: {
                buf.writeBoolean(this.newAmbientLight);
                break;
            }
            case RANDOMIZE: {
                buf.writeBoolean(this.newRandomize);
                break;
            }
        }
    }

    @Override
    public void onMessage(final MessageContext context) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (context.netHandler instanceof NetHandlerPlayServer) {
                    TileEntity te;
                    NetHandlerPlayServer handler = (NetHandlerPlayServer)context.netHandler;
                    EntityPlayerMP player = handler.field_147369_b;
                    if (player != null && player.field_71070_bA != null && player.field_71070_bA instanceof ContainerVoxelProjector && (te = player.field_70170_p.func_175625_s(MessageVoxelProjector.this.pos)) != null && te instanceof TileEntityVoxelProjector) {
                        switch (MessageVoxelProjector.this.value) {
                            case MODEL: {
                                if (MessageVoxelProjector.this.newModel == null) break;
                                ((TileEntityVoxelProjector)te).setModel(MessageVoxelProjector.this.newModel);
                                break;
                            }
                            case MODEL_ROTATION: {
                                if (MessageVoxelProjector.this.newModelRotation < 0 || MessageVoxelProjector.this.newModelRotation >= 361) break;
                                ((TileEntityVoxelProjector)te).setModelRotation(MessageVoxelProjector.this.newModelRotation);
                                break;
                            }
                            case SCALE: {
                                if (MessageVoxelProjector.this.newScale < 1 || MessageVoxelProjector.this.newScale >= 21) break;
                                ((TileEntityVoxelProjector)te).setScale(MessageVoxelProjector.this.newScale);
                                break;
                            }
                            case ROTATION_SPEED: {
                                if (MessageVoxelProjector.this.newRotationSpeed < 0 || MessageVoxelProjector.this.newRotationSpeed >= 41) break;
                                ((TileEntityVoxelProjector)te).setRotationSpeed(MessageVoxelProjector.this.newRotationSpeed);
                                break;
                            }
                            case AMBIENT_LIGHT: {
                                ((TileEntityVoxelProjector)te).setAmbientLight(MessageVoxelProjector.this.newAmbientLight);
                                break;
                            }
                            case RANDOMIZE: {
                                ((TileEntityVoxelProjector)te).setRandomize(MessageVoxelProjector.this.newRandomize);
                                break;
                            }
                        }
                    }
                }
            }
        });
    }

    @Override
    public Side getHandlingSide() {
        return Side.SERVER;
    }

    public void setScale(int scale) {
        this.newScale = scale;
        this.value = VALUE.SCALE;
    }

    public void setRotationSpeed(int rotationSpeed) {
        this.newRotationSpeed = rotationSpeed;
        this.value = VALUE.ROTATION_SPEED;
    }

    public void setRandomize(boolean randomize) {
        this.newRandomize = randomize;
        this.value = VALUE.RANDOMIZE;
    }

    public void setAmbientLight(boolean ambientLight) {
        this.newAmbientLight = ambientLight;
        this.value = VALUE.AMBIENT_LIGHT;
    }

    static enum VALUE {
        MODEL_ROTATION,
        MODEL,
        SCALE,
        ROTATION_SPEED,
        AMBIENT_LIGHT,
        RANDOMIZE;

    }
}

