/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.util;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.network.messages.MessageSetBiome;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.IFluidBlock;

public class WorldUtil {
    public static ChunkPos getChunkPosFromLong(long lng) {
        int x = (int)(lng & 0xFFFFFFFFL);
        int z = (int)(lng >> 32);
        return new ChunkPos(x, z);
    }

    public static RayTraceResult rayTraceAll(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return WorldUtil.rayTraceBlocksAll(worldIn, vec3d, vec3d1, useLiquids, !useLiquids, true);
    }

    public static RayTraceResult rayTraceBlocksAll(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if ((!ignoreBlockWithoutBoundingBox || iblockstate.func_185890_d((IBlockAccess)world, blockpos) != Block.field_185506_k) && (block.func_176209_a(iblockstate, stopOnLiquid) || block instanceof IFluidBlock || block instanceof BlockLiquid) && (raytraceresult = iblockstate.func_185910_a(world, blockpos, vec31, vec32)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = world.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k) continue;
                    if (block1.func_176209_a(iblockstate1, stopOnLiquid) || block1 instanceof IFluidBlock || block1 instanceof BlockLiquid) {
                        RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(world, blockpos, vec31, vec32);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, blockpos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    public static void setBiome(World worldObj, BlockPos pos, Biome biome) {
        Chunk c = worldObj.func_175726_f(new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()));
        int biomeID = Biome.func_185362_a((Biome)biome);
        byte[] biomeArray = c.func_76605_m();
        if ((biomeArray[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] & 0xFF) != biomeID) {
            biomeArray[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] = (byte)(biomeID & 0xFF);
            c.func_76616_a(biomeArray);
        }
        if (!worldObj.field_72995_K) {
            c.func_177427_f(true);
            MessageUtil.sendToAllWatchingPos(worldObj, pos, new MessageSetBiome(pos, Biome.func_185362_a((Biome)biome)));
        } else {
            IBlockState state = worldObj.func_180495_p(pos);
            worldObj.func_184138_a(pos, state, state, 3);
        }
    }

    public static void setEntityPosition(Entity e, double posX, double posY, double posZ) {
        if (e instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)e;
            player.field_71135_a.func_147364_a(posX, posY, posZ, player.field_70177_z, player.field_70125_A);
        } else {
            e.func_70634_a(posX, posY, posZ);
        }
    }

    public static boolean isValidPosition(BlockPos pos) {
        return pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000 && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256;
    }

    public static BlockPos getHeighestPos(World worldObj, int x, int z) {
        int startY;
        for (int y = startY = worldObj.func_175726_f(new BlockPos(x, 0, z)).func_76625_h() + 16; y >= 0; --y) {
            BlockPos toCheck = new BlockPos(x, y, z);
            if (worldObj.func_175623_d(toCheck)) continue;
            return toCheck;
        }
        return null;
    }

    public static List getEntitiesWithinAABBs(World worldObj, Class classEntity, AxisAlignedBB ... bbs) {
        return WorldUtil.getEntitiesWithinAABBs(worldObj, classEntity, EntitySelectors.field_180132_d, bbs);
    }

    public static List getEntitiesWithinAABBs(World worldObj, Class clazz, Predicate filter, AxisAlignedBB ... bbs) {
        ArrayList<Entity> arraylist = new ArrayList<Entity>();
        HashMap<Vec3i, ArrayList<AxisAlignedBB>> boxMap = new HashMap<Vec3i, ArrayList<AxisAlignedBB>>();
        for (AxisAlignedBB bb : bbs) {
            int minChunkX = MathHelper.func_76128_c((double)((bb.field_72340_a - World.MAX_ENTITY_RADIUS) / 16.0));
            int maxChunkX = MathHelper.func_76128_c((double)((bb.field_72336_d + World.MAX_ENTITY_RADIUS) / 16.0));
            int minChunkZ = MathHelper.func_76128_c((double)((bb.field_72339_c - World.MAX_ENTITY_RADIUS) / 16.0));
            int maxChunkZ = MathHelper.func_76128_c((double)((bb.field_72334_f + World.MAX_ENTITY_RADIUS) / 16.0));
            int minChunkY = MathHelper.func_76128_c((double)((bb.field_72338_b - World.MAX_ENTITY_RADIUS) / 16.0));
            int maxChunkY = MathHelper.func_76128_c((double)((bb.field_72337_e + World.MAX_ENTITY_RADIUS) / 16.0));
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    for (int y = minChunkY; y <= maxChunkY; ++y) {
                        if (y < 0 || y >= worldObj.func_72800_K() / 16) continue;
                        Vec3i chunkVec = new Vec3i(x, y, z);
                        ArrayList<AxisAlignedBB> boxList = (ArrayList<AxisAlignedBB>)boxMap.get(chunkVec);
                        if (boxList == null) {
                            boxList = new ArrayList<AxisAlignedBB>();
                            boxMap.put(chunkVec, boxList);
                        }
                        boxList.add(bb);
                    }
                }
            }
        }
        for (Vec3i chunkVec : boxMap.keySet()) {
            Chunk chunk = worldObj.func_72964_e(chunkVec.func_177958_n(), chunkVec.func_177952_p());
            ClassInheritanceMultiMap[] entityMapArray = chunk.func_177429_s();
            for (Entity entity : entityMapArray[chunkVec.func_177956_o()].func_180215_b(clazz)) {
                for (AxisAlignedBB bb : (ArrayList)boxMap.get(chunkVec)) {
                    if (!entity.func_174813_aQ().func_72326_a(bb) || filter != null && !filter.apply((Object)entity)) continue;
                    arraylist.add(entity);
                    Entity[] entityParts = entity.func_70021_al();
                    if (entityParts == null) continue;
                    for (int l = 0; l < entityParts.length; ++l) {
                        entity = entityParts[l];
                        if (!entity.func_174813_aQ().func_72326_a(bb) || filter != null && !filter.apply((Object)entity)) continue;
                        arraylist.add(entity);
                    }
                }
            }
        }
        return arraylist;
    }

    public static void spawnItemStack(World worldIn, BlockPos pos, ItemStack stack) {
        WorldUtil.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        float f = 0.5f;
        double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
        EntityItem entityitem = new EntityItem(worldIn, x + d0, y + d1, z + d2, stack);
        entityitem.func_174869_p();
        worldIn.func_72838_d((Entity)entityitem);
    }
}

